/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.binding.soap.internal.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.binding.soap.SOAPAddress;
import org.eclipse.wst.wsdl.binding.soap.SOAPBinding;
import org.eclipse.wst.wsdl.binding.soap.SOAPBody;
import org.eclipse.wst.wsdl.binding.soap.SOAPFactory;
import org.eclipse.wst.wsdl.binding.soap.SOAPFault;
import org.eclipse.wst.wsdl.binding.soap.SOAPOperation;
import org.eclipse.wst.wsdl.internal.generator.ContentGenerator;

public class SOAPContentGenerator
implements ContentGenerator {
    public static final int OPTION_NOT_SET = -1;
    public static final int STYLE_DOCUMENT = 1;
    public static final int STYLE_RPC = 2;
    public static final int USE_LITERAL = 1;
    public static final int USE_ENCODED = 2;
    private int styleOption = -1;
    private int useOption = -1;
    protected String namespaceValue = "";
    protected String addressLocation = "http://www.example.org/";
    protected static final String[] requiredNamespaces = new String[]{"http://schemas.xmlsoap.org/wsdl/soap/"};
    protected static final String[] preferredNamespacePrefixes = new String[]{"soap"};

    public String[] getRequiredNamespaces() {
        return requiredNamespaces;
    }

    public String getPreferredNamespacePrefix(String namespace) {
        if (namespace.equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
            return "soap";
        }
        return "";
    }

    public void setStyle(int style) {
        this.styleOption = style;
    }

    public void setUse(int use) {
        this.useOption = use;
    }

    public void setAddressLocation(String addressLocation) {
        this.addressLocation = addressLocation;
    }

    public void generatePortContent(Port port) {
        ArrayList removeList = new ArrayList(port.getEExtensibilityElements());
        this.removeExtensebilityElements((List)port.getEExtensibilityElements(), removeList);
        SOAPAddress soapAddress = SOAPFactory.eINSTANCE.createSOAPAddress();
        soapAddress.setLocationURI(this.addressLocation);
        port.addExtensibilityElement(soapAddress);
    }

    public void generateBindingContent(Binding binding, PortType portType) {
        ArrayList removeList = new ArrayList(binding.getEExtensibilityElements());
        this.removeExtensebilityElements((List)binding.getEExtensibilityElements(), removeList);
        SOAPFactory soapFactory = SOAPFactory.eINSTANCE;
        SOAPBinding soapBinding = soapFactory.createSOAPBinding();
        soapBinding.setStyle(this.getStyleOption(binding) == 1 ? "document" : "rpc");
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement(soapBinding);
    }

    public void generateBindingOperationContent(BindingOperation bindingOperation, Operation operation) {
        ArrayList removeList = new ArrayList(bindingOperation.getEExtensibilityElements());
        this.removeExtensebilityElements((List)bindingOperation.getEExtensibilityElements(), removeList);
        SOAPOperation soapOperation = SOAPFactory.eINSTANCE.createSOAPOperation();
        String soapActionValue = this.getNamespace(bindingOperation);
        if (!soapActionValue.endsWith("/")) {
            soapActionValue = soapActionValue + "/";
        }
        soapActionValue = soapActionValue + operation.getName();
        soapOperation.setSoapActionURI(soapActionValue);
        bindingOperation.addExtensibilityElement(soapOperation);
    }

    public void generateBindingInputContent(BindingInput bindingInput, Input input) {
        ArrayList removeList = new ArrayList(bindingInput.getEExtensibilityElements());
        this.removeExtensebilityElements((List)bindingInput.getEExtensibilityElements(), removeList);
        SOAPFactory soapFactory = SOAPFactory.eINSTANCE;
        SOAPBody soapBody = soapFactory.createSOAPBody();
        soapBody.setUse(this.getUseOption(null) == 2 ? "encoded" : "literal");
        if (this.getUseOption(bindingInput) == 2 && this.getStyleOption(bindingInput) == 2) {
            BasicEList encodingList = new BasicEList();
            encodingList.add("http://schemas.xmlsoap.org/soap/encoding/");
            soapBody.setEncodingStyles((List)encodingList);
            soapBody.setNamespaceURI(this.getNamespace(bindingInput));
        } else if (this.getUseOption(bindingInput) == 1 && this.getStyleOption(bindingInput) == 2) {
            soapBody.setNamespaceURI(this.getNamespace(bindingInput));
        }
        bindingInput.addExtensibilityElement(soapBody);
    }

    public void generateBindingOutputContent(BindingOutput bindingOutput, Output output) {
        ArrayList removeList = new ArrayList(bindingOutput.getEExtensibilityElements());
        this.removeExtensebilityElements((List)bindingOutput.getEExtensibilityElements(), removeList);
        SOAPFactory soapFactory = SOAPFactory.eINSTANCE;
        SOAPBody soapBody = soapFactory.createSOAPBody();
        soapBody.setUse(this.getUseOption(bindingOutput) == 2 ? "encoded" : "literal");
        if (this.getUseOption(bindingOutput) == 2 && this.getStyleOption(bindingOutput) == 2) {
            BasicEList encodingList = new BasicEList();
            encodingList.add("http://schemas.xmlsoap.org/soap/encoding/");
            soapBody.setEncodingStyles((List)encodingList);
            soapBody.setNamespaceURI(this.getNamespace(bindingOutput));
        } else if (this.getUseOption(bindingOutput) == 1 && this.getStyleOption(bindingOutput) == 2) {
            soapBody.setNamespaceURI(this.getNamespace(bindingOutput));
        }
        bindingOutput.addExtensibilityElement(soapBody);
    }

    public void generateBindingFaultContent(BindingFault bindingFault, Fault fault) {
        ArrayList removeList = new ArrayList(bindingFault.getEExtensibilityElements());
        this.removeExtensebilityElements((List)bindingFault.getEExtensibilityElements(), removeList);
        SOAPFactory soapFactory = SOAPFactory.eINSTANCE;
        SOAPFault soapFault = soapFactory.createSOAPFault();
        soapFault.setUse(this.getUseOption(bindingFault) == 2 ? "encoded" : "literal");
        soapFault.setName(fault.getName());
        if (this.getUseOption(bindingFault) == 2 && this.getStyleOption(bindingFault) == 2) {
            BasicEList encodingList = new BasicEList();
            encodingList.add("http://schemas.xmlsoap.org/soap/encoding/");
            soapFault.setEncodingStyles((List)encodingList);
        }
        bindingFault.addExtensibilityElement(soapFault);
    }

    private String getNamespace(WSDLElement wsdlElement) {
        if (this.namespaceValue.equals("") && wsdlElement != null) {
            this.namespaceValue = wsdlElement.getEnclosingDefinition().getTargetNamespace();
        }
        if (this.namespaceValue == null) {
            this.namespaceValue = "";
        }
        return this.namespaceValue;
    }

    private void removeExtensebilityElements(List originalList, List removeList) {
        Iterator removeIt = removeList.iterator();
        while (removeIt.hasNext()) {
            originalList.remove(removeIt.next());
        }
    }

    private Binding getBindingObject(Object genericBindingObject) {
        Object parent = genericBindingObject;
        for (int index = 0; parent != null && index < 5 && !((parent = this.getGenericBindingObjectParent(parent)) instanceof Binding); ++index) {
        }
        return parent instanceof Binding ? (Binding)parent : null;
    }

    private Object getGenericBindingObjectParent(Object genericBindingObject) {
        WSDLElement parent = null;
        if (genericBindingObject != null) {
            if (genericBindingObject instanceof BindingOperation) {
                parent = ((BindingOperation)genericBindingObject).getContainer();
            } else if (genericBindingObject instanceof BindingInput) {
                parent = ((BindingInput)genericBindingObject).getContainer();
            } else if (genericBindingObject instanceof BindingOutput) {
                parent = ((BindingOutput)genericBindingObject).getContainer();
            } else if (genericBindingObject instanceof BindingFault) {
                parent = ((BindingFault)genericBindingObject).getContainer();
            }
        }
        return parent;
    }

    private int getStyleOption(Object genericBindingObject) {
        Binding binding;
        if (this.styleOption == -1 && genericBindingObject != null && (binding = this.getBindingObject(genericBindingObject)) != null) {
            EList list = binding.getEExtensibilityElements();
            for (String style : this.getExtensibilityElementAttributeValue((List)list, "style")) {
                if (style.equals("document")) {
                    this.styleOption = 1;
                } else if (style.equals("rpc")) {
                    this.styleOption = 2;
                }
                if (this.styleOption == -1) continue;
                break;
            }
        }
        if (this.styleOption == -1) {
            this.styleOption = 1;
        }
        return this.styleOption;
    }

    private int getUseOption(Object genericBindingObject) {
        if (this.useOption == -1) {
            for (Object messageRef : this.getMessageReferenceBindingObjects(genericBindingObject)) {
                EList list;
                List values = new ArrayList();
                if (messageRef instanceof BindingInput) {
                    list = ((BindingInput)messageRef).getEExtensibilityElements();
                    values = this.getExtensibilityElementAttributeValue((List)list, "use");
                } else if (messageRef instanceof BindingOutput) {
                    list = ((BindingOutput)messageRef).getEExtensibilityElements();
                    values = this.getExtensibilityElementAttributeValue((List)list, "use");
                } else if (messageRef instanceof BindingFault) {
                    list = ((BindingFault)messageRef).getEExtensibilityElements();
                    values = this.getExtensibilityElementAttributeValue((List)list, "use");
                }
                for (String use : values) {
                    if (use.equals("literal")) {
                        this.useOption = 1;
                        continue;
                    }
                    if (!use.equals("encoded")) continue;
                    this.useOption = 2;
                }
                if (this.useOption == -1) continue;
                break;
            }
        }
        if (this.useOption == -1) {
            this.useOption = 1;
        }
        return this.useOption;
    }

    private List getMessageReferenceBindingObjects(Object genericBindingObject) {
        ArrayList<ExtensibleElement> list = new ArrayList<ExtensibleElement>();
        Binding binding = this.getBindingObject(genericBindingObject);
        if (binding != null) {
            for (BindingOperation op : binding.getEBindingOperations()) {
                list.add(op.getEBindingInput());
                list.add(op.getEBindingOutput());
                list.addAll((Collection<ExtensibleElement>)op.getEBindingFaults());
            }
        }
        return list;
    }

    private List getExtensibilityElementAttributeValue(List eeList, String attributeKey) {
        ArrayList<String> values = new ArrayList<String>();
        for (ExtensibilityElement eeElement : eeList) {
            String attributeValue = eeElement.getElement().getAttribute(attributeKey);
            if (attributeValue == null || attributeValue.equals("")) continue;
            values.add(attributeValue);
        }
        return values;
    }

    public String getProtocol() {
        return "SOAP";
    }
}

