/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.util.WSDLConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLUtil
extends WSDLConstants {
    protected static WSDLUtil instance;
    protected HashMap elementNameToTypeMap = new HashMap();

    public static WSDLUtil getInstance() {
        if (instance == null) {
            instance = new WSDLUtil();
        }
        return instance;
    }

    public WSDLUtil() {
        this.elementNameToTypeMap.put("binding", new Integer(0));
        this.elementNameToTypeMap.put("definitions", new Integer(1));
        this.elementNameToTypeMap.put("documentation", new Integer(2));
        this.elementNameToTypeMap.put("fault", new Integer(3));
        this.elementNameToTypeMap.put("import", new Integer(4));
        this.elementNameToTypeMap.put("input", new Integer(5));
        this.elementNameToTypeMap.put("message", new Integer(6));
        this.elementNameToTypeMap.put("operation", new Integer(7));
        this.elementNameToTypeMap.put("output", new Integer(8));
        this.elementNameToTypeMap.put("part", new Integer(9));
        this.elementNameToTypeMap.put("port", new Integer(10));
        this.elementNameToTypeMap.put("portType", new Integer(11));
        this.elementNameToTypeMap.put("service", new Integer(12));
        this.elementNameToTypeMap.put("types", new Integer(13));
    }

    public int getWSDLType(Element element) {
        Integer integer;
        int result = -1;
        if (WSDLConstants.isWSDLNamespace(element.getNamespaceURI()) && (integer = (Integer)this.elementNameToTypeMap.get(element.getLocalName())) != null) {
            result = integer;
        }
        return result;
    }

    protected List getParentElementChain(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (element != null) {
            list.add(0, element);
            Node node = element.getParentNode();
            element = node != null && node.getNodeType() == 1 ? (Element)node : null;
        }
        return list;
    }

    public static QName createQName(Definition definition, String prefixedName) {
        QName qname = null;
        if (prefixedName != null) {
            String namespace;
            String prefix;
            int index = prefixedName.indexOf(":");
            String string = prefix = index == -1 ? null : prefixedName.substring(0, index);
            if (prefix != null && (namespace = definition.getNamespace(prefix)) != null) {
                String localPart = prefixedName.substring(index + 1);
                qname = new QName(namespace, localPart);
            }
        }
        return qname;
    }

    public List getExtensibilityElementNodes(ExtensibleElement extensibleElement) {
        ArrayList<Element> childList = new ArrayList<Element>();
        for (ExtensibilityElement extensibilityElement : extensibleElement.getEExtensibilityElements()) {
            Element element;
            if (extensibilityElement == null || (element = extensibilityElement.getElement()) == null) continue;
            childList.add(element);
        }
        return childList;
    }
}

