/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.http;

import com.ibm.wsdl.BindingImpl;
import com.ibm.wsdl.BindingInputImpl;
import com.ibm.wsdl.BindingOperationImpl;
import com.ibm.wsdl.PortImpl;
import com.ibm.wsdl.extensions.http.HTTPAddressImpl;
import com.ibm.wsdl.extensions.http.HTTPBindingImpl;
import com.ibm.wsdl.extensions.http.HTTPOperationImpl;
import com.ibm.wsdl.extensions.http.HTTPUrlEncodedImpl;
import com.ibm.wsdl.extensions.http.HTTPUrlReplacementImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPOperation;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;

public class HTTPValidator
implements IWSDL11Validator {
    private static String HTTP_RESOURCE_BUNDLE_NAME = "validatewsdlhttp";
    private final String _ERROR_INVALID_PORT_ELEMENT = "_ERROR_INVALID_PORT_ELEMENT";
    private final String _ERROR_INVALID_BINDING_ELEMENT = "_ERROR_INVALID_BINDING_ELEMENT";
    private final String _ERROR_INVALID_BINDING_OPERATION_ELEMENT = "_ERROR_INVALID_BINDING_OPERATION_ELEMENT";
    private final String _ERROR_INVALID_BINDING_INPUT_ELEMENT = "_ERROR_INVALID_BINDING_INPUT_ELEMENT";
    private final String _ERROR_INVALID_HTTP_ELEMENT_FOR_LOCATION = "_ERROR_INVALID_HTTP_ELEMENT_FOR_LOCATION";
    private final String _ERROR_NO_LOCATION_FOR_ADDRESS = "_ERROR_NO_LOCATION_FOR_ADDRESS";
    private final String _ERROR_NO_HTTPBINDING_FOR_ADDRESS = "_ERROR_NO_HTTPBINDING_FOR_ADDRESS";
    private final String _ERROR_INVALID_BINDING_VERB = "_ERROR_INVALID_BINDING_VERB";
    private final String _ERROR_INVALID_LOCATION_URI = "_ERROR_INVALID_LOCATION_URI";
    private final String _ERROR_NO_HTTPBINDING_FOR_OPERATION = "_ERROR_NO_HTTPBINDING_FOR_OPERATION";
    private final String _ERROR_NOT_ONLY_ELEMENT_DEFINED = "_ERROR_NOT_ONLY_ELEMENT_DEFINED";
    private final String _ERROR_NO_HTTPOPERATION_FOR_URL = "_ERROR_NO_HTTPOPERATION_FOR_URL";
    private final String GET = "GET";
    private final String POST = "POST";
    private final String QUOTE = "'";
    private final String EMPTY_STRING = "";
    private MessageGenerator messagegenerator;

    public HTTPValidator() {
        ResourceBundle rb = ResourceBundle.getBundle(HTTP_RESOURCE_BUNDLE_NAME, Locale.getDefault());
        this.messagegenerator = new MessageGenerator(rb);
    }

    public void validate(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        if (parents.get(0).getClass() == PortImpl.class) {
            if (element.getClass() == HTTPAddressImpl.class) {
                this.validateAddress(element, parents, valInfo);
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_PORT_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
        } else if (parents.get(0).getClass() == BindingImpl.class) {
            if (element.getClass() == HTTPBindingImpl.class) {
                this.validateBinding(element, parents, valInfo);
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
        } else if (parents.get(0).getClass() == BindingOperationImpl.class) {
            if (element.getClass() == HTTPOperationImpl.class) {
                this.validateOperation(element, parents, valInfo);
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_OPERATION_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
        } else if (parents.get(0).getClass() == BindingInputImpl.class) {
            if (element.getClass() == HTTPUrlEncodedImpl.class || element.getClass() == HTTPUrlReplacementImpl.class) {
                this.validateHttpUrl(element, parents, valInfo);
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_INPUT_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
        } else {
            ExtensibilityElement e = (ExtensibilityElement)element;
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_HTTP_ELEMENT_FOR_LOCATION", "'" + e.getElementType().getLocalPart() + "'"), element);
        }
    }

    protected void validateAddress(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Port port;
        Binding binding;
        HTTPAddressImpl ha = (HTTPAddressImpl)element;
        String uri = ha.getLocationURI();
        if (uri == null || uri.equalsIgnoreCase("")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_LOCATION_FOR_ADDRESS"), ha);
        }
        if (!this.hasHttpBinding(binding = (port = (Port)parents.get(0)).getBinding())) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_HTTPBINDING_FOR_ADDRESS", "'" + binding.getQName().getLocalPart() + "'", "'" + port.getName() + "'"), ha);
        }
    }

    protected void validateBinding(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        HTTPBindingImpl hb = (HTTPBindingImpl)element;
        String verb = hb.getVerb();
        if (verb != null && !verb.equals("GET") && !verb.equals("POST")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_VERB", "'" + verb + "'"), element);
        }
    }

    protected void validateOperation(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Binding binding;
        HTTPOperation ho = (HTTPOperation)element;
        String locationURI = ho.getLocationURI();
        if (locationURI != null && locationURI.equalsIgnoreCase("")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_LOCATION_URI"), element);
        }
        if (!this.hasHttpBinding(binding = (Binding)parents.get(1))) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_HTTPBINDING_FOR_OPERATION", "'" + binding.getQName().getLocalPart() + "'"), ho);
        }
    }

    protected void validateHttpUrl(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        BindingOperation operation = (BindingOperation)parents.get(1);
        String elementName = element.getClass() == HTTPUrlEncodedImpl.class ? "urlEncoded" : (element.getClass() == HTTPUrlReplacementImpl.class ? "urlReplacement" : "");
        BindingInput input = (BindingInput)parents.get(0);
        if (input.getExtensibilityElements().size() != 1) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NOT_ONLY_ELEMENT_DEFINED", elementName), element);
        }
        if (!this.hasHttpOperation(operation)) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_HTTPOPERATION_FOR_URL", "'" + operation.getName() + "'", elementName), element);
        }
    }

    protected boolean hasHttpOperation(BindingOperation operation) {
        List extelems;
        if (operation != null && (extelems = operation.getExtensibilityElements()) != null) {
            Iterator iextelems = extelems.iterator();
            while (iextelems.hasNext()) {
                if (iextelems.next().getClass() != HTTPOperationImpl.class) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasHttpBinding(Binding binding) {
        List extelems;
        if (binding != null && (extelems = binding.getExtensibilityElements()) != null) {
            Iterator iextelems = extelems.iterator();
            while (iextelems.hasNext()) {
                if (iextelems.next().getClass() != HTTPBindingImpl.class) continue;
                return true;
            }
        }
        return false;
    }
}

