/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InlineSchemaGenerator {
    protected static boolean GENERATE_INLINE_IMPORTS = false;
    protected static final String SOAP_ENCODING_URI = "http://schemas.xmlsoap.org/soap/encoding/";
    protected static final String FILE_PREFIX = "file:///";
    protected static final String XMLNS = "xmlns";
    protected static final String TARGETNAMESPACE = "targetNamespace";
    protected static final String NAMESPACE = "namespace";
    protected static final String IMPORT = "import";
    protected static final String INCLUDE = "include";
    protected static final String SCHEMA = "schema";
    protected static final String SCHEMALOCATION = "schemaLocation";
    protected static final String TYPE = "type";
    protected static final String NAME = "name";
    protected static final String[] ignoreNamespaces = new String[]{"http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/2001/XMLSchema"};
    protected static InlineSchemaGenerator instance = null;

    protected InlineSchemaGenerator() {
        String genInlineImports = System.getProperty("wsdl.require.inline.imports");
        if (genInlineImports != null && genInlineImports.equals("false")) {
            GENERATE_INLINE_IMPORTS = true;
        }
    }

    protected static InlineSchemaGenerator getInstance() {
        if (instance == null) {
            instance = new InlineSchemaGenerator();
        }
        return instance;
    }

    public static String createXSDString(Element element, List elements, String filelocation, Set validImportNSs) {
        return InlineSchemaGenerator.createXSDString(element, elements, filelocation, new Hashtable(), validImportNSs);
    }

    public static String createXSDString(Element element, List elements, String filelocation, Hashtable parentNSs, Set validImportNSs) {
        TreeSet<String> importNSs = new TreeSet<String>();
        importNSs.addAll(validImportNSs);
        importNSs.add(SOAP_ENCODING_URI);
        InlineSchemaGenerator schemaGenerator = InlineSchemaGenerator.getInstance();
        Hashtable nsResolver = schemaGenerator.getNSResolver(element);
        List reqns = schemaGenerator.getNamespacePrefixes(element);
        Hashtable reqNSDecl = schemaGenerator.resolveNamespaces(reqns, nsResolver, parentNSs);
        if (GENERATE_INLINE_IMPORTS) {
            List importNS = schemaGenerator.getImportNamespaces(element);
            reqns = schemaGenerator.removeImports(reqns, importNS);
            reqns = schemaGenerator.removeLocalNamespaces(reqns, element);
            reqns = schemaGenerator.restrictImports(reqns, validImportNSs);
        } else {
            reqns.clear();
        }
        return schemaGenerator.createXSDStringRecursively(element, elements, reqns, reqNSDecl, filelocation);
    }

    public static boolean soapEncodingRequiredNotImported(Element element, String filelocation, Hashtable parentNSs) {
        InlineSchemaGenerator schemaGenerator = InlineSchemaGenerator.getInstance();
        Hashtable nsResolver = schemaGenerator.getNSResolver(element);
        List reqns = null;
        reqns = schemaGenerator.getNamespacePrefixes(element);
        schemaGenerator.resolveNamespaces(reqns, nsResolver, parentNSs);
        List importNS = schemaGenerator.getImportNamespaces(element);
        reqns = schemaGenerator.removeImports(reqns, importNS);
        reqns = schemaGenerator.removeLocalNamespaces(reqns, element);
        return schemaGenerator.checkSOAPEncodingRequired(reqns);
    }

    protected String createXSDStringRecursively(Element elem, List elements, List requiredNamespaces, Hashtable reqNSDecl, String filelocation) {
        if (elem == null) {
            return "";
        }
        elements.add(elem);
        StringBuffer xsdString = new StringBuffer();
        String elementName = elem.getTagName();
        xsdString.append("<").append(elementName);
        String namePrefix = "";
        NamedNodeMap atts = elem.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node n = atts.item(i);
            xsdString.append(" ").append(n.getNodeName()).append("=\"");
            String nodeName = n.getNodeName();
            if (nodeName.equalsIgnoreCase(SCHEMALOCATION) && filelocation != null) {
                String relativePath = n.getNodeValue();
                xsdString.append(relativePath).append("\"");
                continue;
            }
            String nodeValue = n.getNodeValue();
            if (nodeName.indexOf(XMLNS) != -1 && nodeValue.equalsIgnoreCase(elem.getNamespaceURI())) {
                namePrefix = nodeName;
                namePrefix = namePrefix.equalsIgnoreCase(XMLNS) ? "" : namePrefix.substring(6) + ":";
            }
            if (nodeValue.equals("http://www.w3.org/1999/XMLSchema") || nodeValue.equals("http://www.w3.org/2000/10/XMLSchema")) {
                nodeValue = "http://www.w3.org/2001/XMLSchema";
            }
            xsdString.append(nodeValue).append("\"");
        }
        if (reqNSDecl != null) {
            Enumeration keys = reqNSDecl.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String declNS = (String)reqNSDecl.get(key);
                if (declNS.equals("http://www.w3.org/1999/XMLSchema") || declNS.equals("http://www.w3.org/2000/10/XMLSchema")) {
                    declNS = "http://www.w3.org/2001/XMLSchema";
                }
                xsdString.append(" ").append(key).append("=\"").append(declNS).append("\"");
            }
        }
        xsdString.append(">");
        if (requiredNamespaces != null) {
            for (String ns : requiredNamespaces) {
                xsdString.append("<").append(namePrefix).append(IMPORT).append(" ").append(NAMESPACE).append("=\"").append(ns).append("\" ").append(SCHEMALOCATION).append("=\"").append(ns).append("\"/>");
            }
        }
        xsdString.append("\n");
        NodeList childNodes = elem.getChildNodes();
        for (int i = 0; i < childNodes.getLength() || i < 5; ++i) {
            Node n = childNodes.item(i);
            if (!(n instanceof Element)) continue;
            Element child = (Element)n;
            xsdString.append(this.createXSDStringRecursively(child, elements, null, null, filelocation));
        }
        xsdString.append("</").append(elem.getTagName()).append(">");
        return xsdString.toString();
    }

    protected List getNamespacePrefixes(Element elem) {
        String localname;
        ArrayList<String> namespace = new ArrayList<String>();
        NodeList childNodes = elem.getChildNodes();
        int numChildren = childNodes.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node n = childNodes.item(i);
            if (!(n instanceof Element)) continue;
            Element child = (Element)n;
            List childns = this.getNamespacePrefixes(child);
            for (int j = childns.size() - 1; j >= 0; --j) {
                String ns = (String)childns.get(j);
                if (namespace.contains(ns)) continue;
                namespace.add(ns);
            }
        }
        String elemNS = elem.getPrefix();
        if (elemNS == null) {
            elemNS = "";
        }
        if (!namespace.contains(elemNS)) {
            namespace.add(elemNS);
        }
        if (!((localname = elem.getLocalName()).equals(IMPORT) || localname.equals(INCLUDE) || localname.equals(SCHEMA))) {
            NamedNodeMap atts = elem.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                String nodeValue;
                int colonIndex;
                String prefix;
                Node n = atts.item(i);
                String nodeName = n.getNodeName();
                if (nodeName.indexOf(XMLNS) != -1 || nodeName.equals(TARGETNAMESPACE) || nodeName.equals(NAME)) continue;
                int colonIndex2 = nodeName.indexOf(":");
                if (colonIndex2 != -1 && colonIndex2 + 1 < nodeName.length() && nodeName.charAt(colonIndex2 + 1) != '/' && !namespace.contains(prefix = nodeName.substring(0, colonIndex2))) {
                    namespace.add(prefix);
                }
                if ((colonIndex = (nodeValue = n.getNodeValue()).indexOf(":")) == -1 || colonIndex + 1 < nodeValue.length() && nodeValue.charAt(colonIndex + 1) == '/' || namespace.contains(nodeValue = nodeValue.substring(0, colonIndex))) continue;
                namespace.add(nodeValue);
            }
        }
        return namespace;
    }

    protected List getImportNamespaces(Element elem) {
        Vector<String> namespace = new Vector<String>();
        NodeList childNodes = elem.getChildNodes();
        for (int i = 0; i < childNodes.getLength() || i < 5; ++i) {
            Node n = childNodes.item(i);
            if (!(n instanceof Element)) continue;
            Element child = (Element)n;
            List childns = this.getImportNamespaces(child);
            for (int j = childns.size() - 1; j >= 0; --j) {
                String ns = (String)childns.get(j);
                if (namespace.contains(ns)) continue;
                namespace.add(ns);
            }
        }
        if (elem.getLocalName().equalsIgnoreCase(IMPORT)) {
            NamedNodeMap atts = elem.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                String nodeValue;
                Node n = atts.item(i);
                String nodeName = n.getNodeName();
                if (!nodeName.equalsIgnoreCase(NAMESPACE) || namespace.contains(nodeValue = n.getNodeValue())) continue;
                namespace.add(nodeValue);
            }
        }
        return namespace;
    }

    protected Hashtable getNSResolver(Element elem) {
        Hashtable<String, String> nsResolver = new Hashtable<String, String>();
        NamedNodeMap atts = elem.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node n = atts.item(i);
            String nodeName = n.getNodeName();
            if (nodeName.indexOf(XMLNS) == -1) continue;
            String nodeValue = n.getNodeValue();
            String namePrefix = nodeName;
            namePrefix = namePrefix.equalsIgnoreCase(XMLNS) ? "" : namePrefix.substring(6);
            nsResolver.put(namePrefix, nodeValue);
        }
        return nsResolver;
    }

    protected Hashtable resolveNamespaces(List namespaces, Hashtable nsResolver, Hashtable parentNSResolver) {
        Hashtable reqNSDecl = new Hashtable();
        if (namespaces != null && !namespaces.isEmpty() && nsResolver != null) {
            for (int i = namespaces.size() - 1; i >= 0; --i) {
                Object resolvedNS;
                String ns = (String)namespaces.get(i);
                namespaces.remove(i);
                if (nsResolver.containsKey(ns)) {
                    resolvedNS = nsResolver.get(ns);
                    if (namespaces.contains(resolvedNS)) continue;
                    namespaces.add(i, nsResolver.get(ns));
                    continue;
                }
                if (!parentNSResolver.containsKey(ns = ns.equals("") ? XMLNS : "xmlns:" + ns)) continue;
                resolvedNS = parentNSResolver.get(ns);
                if (!namespaces.contains(resolvedNS)) {
                    namespaces.add(i, resolvedNS);
                }
                reqNSDecl.put(ns, resolvedNS);
            }
        }
        return reqNSDecl;
    }

    protected List removeImports(List namespaces, List importedNamespaces) {
        if (namespaces != null && importedNamespaces != null && !importedNamespaces.isEmpty()) {
            for (String iNS : importedNamespaces) {
                namespaces.remove(iNS);
            }
        }
        return namespaces;
    }

    protected List removeLocalNamespaces(List namespaces, Element elem) {
        if (namespaces != null && elem != null) {
            String ns = elem.getAttribute(TARGETNAMESPACE);
            namespaces.remove(ns);
            for (int i = ignoreNamespaces.length - 1; i >= 0; --i) {
                if (!namespaces.remove(ignoreNamespaces[i])) continue;
                ++i;
            }
        }
        return namespaces;
    }

    protected List restrictImports(List namespaces, Set validImportNSs) {
        Iterator nsIter = namespaces.iterator();
        while (nsIter.hasNext()) {
            String ns = (String)nsIter.next();
            if (validImportNSs.contains(ns)) continue;
            namespaces.remove(ns);
            nsIter = namespaces.iterator();
        }
        return namespaces;
    }

    protected boolean checkSOAPEncodingRequired(List reqns) {
        return reqns.contains(SOAP_ENCODING_URI);
    }
}

