/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.xerces.impl.Version;
import org.eclipse.wst.wsi.internal.core.util.XMLInfo;

public class ToolEnvironment {
    public static final String ELEM_NAME = "environment";
    protected String runtimeName = System.getProperty("java.runtime.name");
    protected String runtimeVersion = System.getProperty("java.runtime.version");
    protected String osName = System.getProperty("os.name");
    protected String osVersion = System.getProperty("os.version");
    protected String xmlParserName = "?";
    protected String xmlParserVersion = "?";
    protected XMLInfo xmlInfo = null;

    public ToolEnvironment() {
        try {
            this.xmlParserVersion = Version.getVersion();
            this.xmlParserName = "Apache Xerces";
        }
        catch (Exception e) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public ToolEnvironment(XMLInfo xmlInfo) {
        this.xmlInfo = xmlInfo;
    }

    public String getOSName() {
        return this.osName;
    }

    public String getOSVersion() {
        return this.osVersion;
    }

    public String getXMLParserName() {
        return this.xmlParserName;
    }

    public String getXMLParserVersion() {
        return this.xmlParserVersion;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setOSName(String osName) {
        this.osName = osName;
    }

    public void setOSVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setXMLParserName(String xmlParserName) {
        this.xmlParserName = xmlParserName;
    }

    public void setXMLParserVersion(String xmlParserVersion) {
        this.xmlParserVersion = xmlParserVersion;
    }

    public void setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public void setAdditionalToolEnvironment(XMLInfo xmlInfo) {
        this.xmlInfo = xmlInfo;
    }

    public String toXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("")) {
            nsName = nsName + ":";
        }
        pw.println("    <" + nsName + ELEM_NAME + ">");
        pw.print("      <" + nsName + "runtime" + " ");
        pw.print("name=\"" + this.runtimeName + "\" ");
        pw.println("version=\"" + this.runtimeVersion + "\"/>");
        pw.print("      <" + nsName + "operatingSystem" + " ");
        pw.print("name=\"" + this.osName + "\" ");
        pw.println("version=\"" + this.osVersion + "\"/>");
        pw.print("      <" + nsName + "xmlParser" + " ");
        pw.print("name=\"" + this.xmlParserName + "\" ");
        pw.println("version=\"" + this.xmlParserVersion + "\"/>");
        if (this.xmlInfo != null) {
            pw.print(this.xmlInfo.toXMLString(nsName));
        }
        pw.println("    </" + nsName + ELEM_NAME + ">");
        return sw.toString();
    }
}

