/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AnalyzerContext;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.report.Entry;
import org.eclipse.wst.wsi.internal.core.util.EntryType;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;

public class EntryContext {
    protected Entry entry = null;
    protected MessageEntry request = null;
    protected MessageEntry response = null;
    protected MessageEntry messageEntry = null;
    protected Document requestDocument = null;
    protected Document responseDocument = null;
    protected Document messageEntryDocument = null;
    protected WSDLDocument wsdlDocument = null;
    protected AnalyzerContext analyzerContext = null;

    public EntryContext(Entry entry, MessageEntry request, MessageEntry response) {
        this(entry, request, response, null);
    }

    public EntryContext(Entry entry, MessageEntry request, MessageEntry response, AnalyzerContext analyzerContext) {
        this.entry = entry;
        this.request = request;
        this.response = response;
        this.analyzerContext = analyzerContext;
        try {
            MimePart part;
            if (request.isMimeContent()) {
                part = request.getMimeParts().getRootPart();
                if (part != null && part.getContent().length() > 0) {
                    this.requestDocument = XMLUtils.parseXML(part.getContent());
                }
            } else if (request.getMessage().length() > 0) {
                this.requestDocument = XMLUtils.parseXML(request.getMessage());
            }
            if (response != null) {
                if (response.isMimeContent()) {
                    part = response.getMimeParts().getRootPart();
                    if (part != null && part.getContent().length() > 0) {
                        this.responseDocument = XMLUtils.parseXML(part.getContent());
                    }
                } else if (response.getMessage().length() > 0) {
                    this.responseDocument = XMLUtils.parseXML(response.getMessage());
                }
            }
        }
        catch (WSIException we) {
            // empty catch block
        }
        if (entry.getEntryType().equals(EntryType.getEntryType("requestMessage"))) {
            this.messageEntry = request;
            this.messageEntryDocument = this.requestDocument;
        } else {
            this.messageEntry = response;
            this.messageEntryDocument = this.responseDocument;
        }
    }

    public EntryContext(Entry entry, WSDLDocument wsdlDocument) {
        this.entry = entry;
        this.wsdlDocument = wsdlDocument;
    }

    public EntryContext(Entry entry, AnalyzerContext analyzerContext) {
        this.entry = entry;
        this.analyzerContext = analyzerContext;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public MessageEntry getRequest() {
        return this.request;
    }

    public MessageEntry getResponse() {
        return this.response;
    }

    public MessageEntry getMessageEntry() {
        return this.messageEntry;
    }

    public Document getRequestDocument() {
        return this.requestDocument;
    }

    public Document getResponseDocument() {
        return this.responseDocument;
    }

    public Document getMessageEntryDocument() {
        return this.messageEntryDocument;
    }

    public WSDLDocument getWSDLDocument() {
        return this.wsdlDocument;
    }

    public AnalyzerContext getAnalyzerContext() {
        return this.analyzerContext;
    }
}

