/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BP1301
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1301(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String message = entryContext.getMessageEntry().getMessage();
        Object[] mustUnderstandAttributes = this.getMustUnderstandAttributes(message);
        if (mustUnderstandAttributes == null) {
            this.result = "notApplicable";
        } else {
            for (int index = 0; index < mustUnderstandAttributes.length; ++index) {
                if (mustUnderstandAttributes[index] != null && (mustUnderstandAttributes[index].equals("1") || mustUnderstandAttributes[index].equals("0"))) {
                    this.result = "passed";
                    continue;
                }
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("The SOAP mustUnderstand attribute was present  and its value was  " + mustUnderstandAttributes[index], entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private Object[] getMustUnderstandAttributes(String message) throws WSIException {
        if (message == null || message.trim().equals("")) {
            return null;
        }
        Document doc = XMLUtils.parseXML(message);
        NodeList headers = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
        if (headers.getLength() <= 0) {
            return null;
        }
        Vector<String> mustUnderstandAttributes = new Vector<String>();
        Element header = (Element)headers.item(0);
        if (header == null) {
            return null;
        }
        NodeList headerEntries = header.getChildNodes();
        boolean headerTargets = false;
        for (int index = 0; index < headerEntries.getLength(); ++index) {
            Node headerEntry = headerEntries.item(index);
            if (headerEntry.getNodeType() != 1) continue;
            headerTargets = true;
            Attr mustUnderstand = ((Element)headerEntry).getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
            if (mustUnderstand != null) {
                String mustUnderstandValue = mustUnderstand.getNodeValue();
                mustUnderstandAttributes.add(mustUnderstandValue);
                continue;
            }
            this.result = "notApplicable";
        }
        if (!headerTargets) {
            this.result = "notApplicable";
        }
        return mustUnderstandAttributes.toArray();
    }

    public boolean isMustUnderstandFaultCode(Element faultCodeElem) {
        if (faultCodeElem == null) {
            return false;
        }
        String faultCode = faultCodeElem.getFirstChild().getNodeValue().trim();
        if (faultCode == null) {
            return false;
        }
        String faultCodeElemPrefix = faultCodeElem.getPrefix();
        String faultCodePrefix = faultCode.substring(0, faultCode.indexOf(58));
        String faultCodeName = faultCode.substring(faultCode.indexOf(58) + 1, faultCode.length());
        if (faultCodeElemPrefix != null || faultCodePrefix != null) {
            return faultCodePrefix.equals(faultCodeElemPrefix) && (faultCodeName.equals("MustUnderstand") || faultCodeName.startsWith("MustUnderstand."));
        }
        return faultCode.equals("MustUnderstand") || faultCodeName.startsWith("MustUnderstand.");
    }
}

