/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.MIMEUtils;

public class AP1933
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1933(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (!entryContext.getMessageEntry().isMimeContent()) {
                throw new AssertionNotApplicableException();
            }
            MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), entryContext.getMessageEntryDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            List extElems = null;
            if (entryContext.getMessageEntry().getType().equals("request") && bindingOperation.getBindingInput() != null) {
                extElems = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response") && bindingOperation.getBindingOutput() != null) {
                extElems = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (extElems == null || extElems.size() == 0 || !(extElems.get(0) instanceof MIMEMultipartRelated)) {
                throw new AssertionNotApplicableException();
            }
            MIMEMultipartRelated mime = (MIMEMultipartRelated)extElems.get(0);
            List parts = mime.getMIMEParts();
            for (int i = 1; i < parts.size(); ++i) {
                String partName = this.getMIMEContentPart((MIMEPart)parts.get(i));
                if (this.findMIMEPart(mimeParts.getParts(), partName) != null) continue;
                throw new AssertionFailException("The corresponding binding operation \"" + bindingOperation.getName() + "\" does not contain part \"" + partName + "\"");
            }
        }
        catch (AssertionNotApplicableException e) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException e) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String findMIMEPart(Collection parts, String partName) throws WSIException, AssertionFailException {
        if (partName == null) {
            return null;
        }
        Iterator iparts = parts.iterator();
        int i = 0;
        while (iparts.hasNext()) {
            int atIdx;
            ++i;
            MimePart part = (MimePart)iparts.next();
            String m_partName = MIMEUtils.getMimeHeaderAttribute(part.getHeaders(), "Content-ID");
            if (m_partName == null || !m_partName.startsWith("<") || !m_partName.endsWith(">")) continue;
            String enPartName = null;
            String uid = null;
            String host = null;
            int idx = m_partName.indexOf("=");
            if (idx != -1) {
                enPartName = this.encodePartName(m_partName.substring(1, idx));
            }
            if ((atIdx = m_partName.indexOf("@")) != -1 && atIdx > idx) {
                uid = m_partName.substring(idx + 1, atIdx);
                host = m_partName.substring(atIdx + 1, m_partName.length() - 1);
            }
            if (enPartName == null || !enPartName.equals(partName)) continue;
            if (uid == null || uid.length() == 0) {
                throw new AssertionFailException("The \"Content-ID\" attribute of the part \"" + (i + 1) + "\"contains value \"" + m_partName + "\" which has a incorrect UID format");
            }
            if (host == null) {
                throw new AssertionFailException("The \"Content-ID\" attribute of the part \"" + (i + 1) + "\"contains value \"" + m_partName + "\" which has a incorrect host format");
            }
            try {
                new URL("HTTP", host, "");
            }
            catch (MalformedURLException e) {
                throw new AssertionFailException("The \"Content-ID\" attribute of the part \"" + (i + 1) + "\"contains value \"" + m_partName + "\" which has a incorrect host format");
            }
            return m_partName;
        }
        return null;
    }

    private String getMIMEContentPart(MIMEPart part) {
        List list = part.getExtensibilityElements();
        if (list.size() == 0) {
            return null;
        }
        return ((MIMEContent)list.get(0)).getPart();
    }

    private String encodePartName(String str) {
        StringBuffer res = new StringBuffer("");
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '%' && str.length() > i + 2) {
                try {
                    int value = Integer.parseInt(String.valueOf(str.charAt(i + 1)) + String.valueOf(str.charAt(i + 2)), 16);
                    res.append((char)value);
                    i += 2;
                }
                catch (NumberFormatException e) {}
                continue;
            }
            res.append(str.charAt(i));
        }
        return res.toString();
    }
}

