/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class AP1935
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1935(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (!entryContext.getMessageEntry().isMimeContent()) {
            this.result = "notApplicable";
        } else {
            MimeParts parts = entryContext.getMessageEntry().getMimeParts();
            if (parts.count() == 0) {
                this.result = "notApplicable";
            } else {
                Iterator iparts = parts.getParts().iterator();
                int i = 0;
                MimePart root = parts.getRootPart();
                while (iparts.hasNext()) {
                    i = 1;
                    try {
                        MimePart part = (MimePart)iparts.next();
                        String encoding = HTTPUtils.getHttpHeaderAttribute(part.getHeaders(), "Content-Transfer-Encoding");
                        if (part == root || encoding != null && encoding.equalsIgnoreCase("base64")) {
                            this.checkPart(part, encoding, false);
                            continue;
                        }
                        this.checkPart(part, encoding, true);
                    }
                    catch (AssertionFailException e) {
                        this.result = "failed";
                        this.failureDetail = this.validator.createFailureDetail("part " + (i + 1) + " Error: " + e.getMessage(), entryContext);
                    }
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void checkPart(MimePart part, String encoding, boolean encoded) throws AssertionFailException, WSIException {
        String content = null;
        content = encoded ? new String(Utils.decodeBase64(part.getContent())) : part.getContent();
        if (encoding == null) {
            this.result = "notApplicable";
        } else if (encoding.equalsIgnoreCase("7bit")) {
            this.checkOn7bit(content);
        } else if (encoding.equalsIgnoreCase("8bit")) {
            this.checkOn8bit(content);
        } else if (encoding.equalsIgnoreCase("quoted-printable")) {
            this.checkOnQuotedPrintable(content);
        } else if (encoding.equalsIgnoreCase("base64")) {
            this.checkOnBase64(content);
        }
    }

    private void checkOn7bit(String message) throws AssertionFailException {
        String[] strs = this.split(message);
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (str.length() > 998) {
                throw new AssertionFailException("The length (" + str.length() + ") of the line (" + (i + 1) + ") greater than 998");
            }
            char[] chars = str.toCharArray();
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] <= '\u007f' && chars[j] != '\u0000' && chars[j] != '\n' && chars[j] != '\r') continue;
                throw new AssertionFailException("The char (" + chars[j] + ")[code=" + (byte)chars[j] + " position=" + j + "] does not allows in 7bit encoding content");
            }
        }
    }

    private void checkOn8bit(String message) throws AssertionFailException {
        String[] strs = this.split(message);
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (str.length() > 998) {
                throw new AssertionFailException("The length (" + str.length() + ") of the line (" + (i + 1) + ") greater than 998");
            }
            char[] chars = str.toCharArray();
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != '\u0000' && chars[j] != '\n' && chars[j] != '\r') continue;
                throw new AssertionFailException("The char (" + chars[j] + ")[code=" + (byte)chars[j] + " position=" + j + "] does not allows in 8bit encoding content");
            }
        }
    }

    private void checkOnQuotedPrintable(String message) throws AssertionFailException {
        String[] strs = this.split(message);
        for (int i = 0; i < strs.length; ++i) {
            if ((strs[i].indexOf("\t") != -1 || strs[i].indexOf(" ") != -1) && strs[i].length() > 76) {
                throw new AssertionFailException("The length (" + strs[i].length() + ") of the line (" + (i + 1) + ") greater than 76, \"soft\" line breaks must be used");
            }
            char[] chars = strs[i].toCharArray();
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] == '=' && chars.length > j + 2) {
                    if (!this.isHex(chars[j + 1]) || !this.isHex(chars[j + 2])) {
                        throw new AssertionFailException("the quoted char (" + chars[j] + chars[j + 1] + chars[j + 2] + ") is incorrect");
                    }
                    j += 2;
                    continue;
                }
                if (chars[j] == '\t' || chars[j] == ' ' || chars[j] != '\u0000' && chars[j] != '\n' && chars[j] != '\r' && chars[j] >= '!' && chars[j] <= '~' && chars[j] != '=') continue;
                throw new AssertionFailException("The char (" + chars[j] + ")[code=" + (byte)chars[j] + " position=" + j + "] must be quoted");
            }
        }
    }

    private void checkOnBase64(String message) throws AssertionFailException {
        String[] strs = this.split(message);
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (str.length() > 76) {
                throw new AssertionFailException("The length (" + str.length() + ") of the line (" + (i + 1) + ") greater than 998");
            }
            char[] chars = str.toCharArray();
            for (int j = 0; j < chars.length; ++j) {
                char c = chars[i];
                if (c >= '/' && c <= 'z' && (c <= '9' || c >= 'A') && (c <= 'Z' || c >= 'a')) continue;
                throw new AssertionFailException("The char (" + chars[j] + ")[code=" + (byte)chars[j] + " position=" + j + "] does not allows in base64 encoding content");
            }
        }
    }

    private String[] split(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int idx = str.indexOf("\r\n");
        while (idx != -1) {
            list.add(str.substring(0, idx));
            str = str.substring(idx + 2);
            idx = str.indexOf("\r\n");
        }
        list.add(str);
        return list.toArray(new String[list.size()]);
    }

    private boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F';
    }
}

