/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSI1110
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1110(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document doc;
        if (entryContext.getMessageEntry() != null && !this.validator.isOneWayResponse(entryContext) && (doc = entryContext.getMessageEntryDocument()) != null) {
            Element root = doc.getDocumentElement();
            NodeList claimList = root.getElementsByTagNameNS("http://ws-i.org/schemas/conformanceClaim/", "Claim");
            if (claimList == null || claimList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                for (int i = 0; i < claimList.getLength(); ++i) {
                    Element elem = (Element)claimList.item(i);
                    Attr node = elem.getAttributeNode("conformsTo");
                    if (node != null) continue;
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail("\nSOAP message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                    break;
                }
            }
        } else {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

