/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class AP2910
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2910(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            boolean mimeContentsFound = false;
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List ops = binding.getBindingOperations();
            for (int i = 0; i < ops.size(); ++i) {
                String part;
                BindingOperation bindingOperation = (BindingOperation)ops.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                List inputMimeContents = this.getMimeContentElements(bindingInput == null ? null : bindingInput.getExtensibilityElements());
                List outputMimeContents = this.getMimeContentElements(bindingOutput == null ? null : bindingOutput.getExtensibilityElements());
                if (!inputMimeContents.isEmpty()) {
                    mimeContentsFound = true;
                    Input portTypeInput = bindingOperation.getOperation().getInput();
                    if (portTypeInput == null || portTypeInput.getMessage() == null) {
                        throw new AssertionFailException("The corresponging operation in the wsdl:portType for the \"" + bindingOperation.getName() + "\" binding operation is invalid.");
                    }
                    part = this.getInvalidMimeContentPart(inputMimeContents, portTypeInput.getMessage());
                    if (part != null) {
                        throw new AssertionFailException("part=\"" + part + "\", the input of the binding operation \"" + bindingOperation.getName() + "\"");
                    }
                }
                if (outputMimeContents.isEmpty()) continue;
                mimeContentsFound = true;
                Output portTypeOutput = bindingOperation.getOperation().getOutput();
                if (portTypeOutput == null || portTypeOutput.getMessage() == null) {
                    throw new AssertionFailException("The corresponging operation in the wsdl:portType for the \"" + bindingOperation.getName() + "\" binding operation is invalid.");
                }
                part = this.getInvalidMimeContentPart(outputMimeContents, portTypeOutput.getMessage());
                if (part == null) continue;
                throw new AssertionFailException("part=\"" + part + "\", the output of the binding operation \"" + bindingOperation.getName() + "\"");
            }
            if (!mimeContentsFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException anae) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String getInvalidMimeContentPart(List mimeContents, Message message) {
        for (int i = 0; i < mimeContents.size(); ++i) {
            String partName = ((MIMEContent)mimeContents.get(i)).getPart();
            Part part = message.getPart(partName);
            if (part == null || (part.getTypeName() != null || part.getElementName() != null) && (part.getTypeName() == null || part.getElementName() == null)) continue;
            return partName;
        }
        return null;
    }

    private List getMimeContentElements(List extElems) {
        ArrayList<ExtensibilityElement> mimeContentElements = new ArrayList<ExtensibilityElement>();
        if (extElems != null) {
            for (int i = 0; i < extElems.size(); ++i) {
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (extElem.getElementType().equals(WSDL_MIME_MULTIPART)) {
                    List mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                    for (int j = 0; j < mimeParts.size(); ++j) {
                        List elems = this.getMimeContentElements(((MIMEPart)mimeParts.get(j)).getExtensibilityElements());
                        mimeContentElements.addAll(elems);
                    }
                    continue;
                }
                if (!extElem.getElementType().equals(WSDL_MIME_CONTENT)) continue;
                mimeContentElements.add(extElem);
            }
        }
        return mimeContentElements;
    }
}

