/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Element;

public class AP2941
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2941(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List ops = binding.getBindingOperations();
            for (int i = 0; i < ops.size(); ++i) {
                List outputParts;
                List inputParts;
                BindingOperation bindingOperation = (BindingOperation)ops.get(i);
                Input portTypeInput = bindingOperation.getOperation().getInput();
                Output portTypeOutput = bindingOperation.getOperation().getOutput();
                if (portTypeInput != null && portTypeInput.getMessage() != null && !(inputParts = this.getBindingParts(bindingOperation.getBindingInput().getExtensibilityElements(), portTypeInput.getMessage())).containsAll(portTypeInput.getMessage().getParts().keySet())) {
                    throw new AssertionFailException("The wsdl:input of the \"" + bindingOperation.getName() + "\" binding operation does not " + "bind all the corresponding wsdl:partS.");
                }
                if (portTypeOutput != null && portTypeOutput.getMessage() != null && !(outputParts = this.getBindingParts(bindingOperation.getBindingOutput().getExtensibilityElements(), portTypeOutput.getMessage())).containsAll(portTypeOutput.getMessage().getParts().keySet())) {
                    throw new AssertionFailException("The wsdl:output of the \"" + bindingOperation.getName() + "\" binding operation does not " + "bind all the corresponding wsdl:partS.");
                }
                if (bindingOperation.getOperation().getFaults().isEmpty()) continue;
                ArrayList<String> faultNames = new ArrayList<String>();
                Collection faults = bindingOperation.getBindingFaults().values();
                Iterator it = faults.iterator();
                while (it.hasNext()) {
                    List extElems = ((BindingFault)it.next()).getExtensibilityElements();
                    for (int j = 0; j < extElems.size(); ++j) {
                        if (!((ExtensibilityElement)extElems.get(j)).getElementType().equals(WSDL_SOAP_FAULT)) continue;
                        faultNames.add(((SOAPFault)extElems.get(j)).getName());
                    }
                }
                faultNames.addAll(this.findAllHeaderFaults(bindingOperation));
                if (faultNames.containsAll(bindingOperation.getOperation().getFaults().keySet())) continue;
                throw new AssertionFailException("The binding operation \"" + bindingOperation.getName() + "\" does not " + "bind all the corresponding wsdl:faultS.");
            }
        }
        catch (AssertionFailException afe) {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private List getBindingParts(List extElems, Message message) {
        ArrayList<Object> parts = new ArrayList<Object>();
        if (extElems != null) {
            for (int i = 0; i < extElems.size(); ++i) {
                int j;
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (extElem.getElementType().equals(WSDL_SOAP_BODY)) {
                    List pts = ((SOAPBody)extElem).getParts();
                    if (pts != null) {
                        parts.addAll(pts);
                        continue;
                    }
                    parts.addAll(message.getParts().keySet());
                    continue;
                }
                if (extElem.getElementType().equals(WSDL_SOAP_HEADER)) {
                    Object header;
                    List headerFaults = null;
                    if (extElem instanceof SOAPHeader) {
                        header = (SOAPHeader)extElem;
                        if (message.getQName().equals(header.getMessage())) {
                            parts.add(header.getPart());
                        }
                        headerFaults = header.getSOAPHeaderFaults();
                    } else {
                        header = ((UnknownExtensibilityElement)extElem).getElement();
                        if (this.referencesMessage((Element)header, message.getQName())) {
                            parts.add(header.getAttribute("part"));
                        }
                        headerFaults = this.getHeaderFaults((Element)header);
                    }
                    for (j = 0; j < headerFaults.size(); ++j) {
                        Object shf;
                        if (headerFaults.get(j) instanceof SOAPHeaderFault) {
                            shf = (SOAPHeaderFault)headerFaults.get(j);
                            if (!message.equals(shf.getMessage())) continue;
                            parts.add(shf.getPart());
                            continue;
                        }
                        shf = (Element)headerFaults.get(j);
                        if (!this.referencesMessage((Element)shf, message.getQName())) continue;
                        parts.add(shf.getAttribute("part"));
                    }
                    continue;
                }
                if (extElem.getElementType().equals(WSDL_MIME_CONTENT)) {
                    parts.add(((MIMEContent)extElem).getPart());
                    continue;
                }
                if (!extElem.getElementType().equals(WSDL_MIME_MULTIPART)) continue;
                List mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                for (j = 0; j < mimeParts.size(); ++j) {
                    parts.addAll(this.getBindingParts(((MIMEPart)mimeParts.get(j)).getExtensibilityElements(), message));
                }
            }
        }
        return parts;
    }

    private boolean referencesMessage(Element elem, QName messageName) {
        String lp;
        String message = elem.getAttribute("message");
        int colonPos = message.indexOf(":");
        String ns = null;
        String string = lp = colonPos > -1 ? message.substring(colonPos + 1) : message;
        if (colonPos > -1) {
            ns = this.validator.wsdlDocument.getDefinitions().getNamespace(message.substring(0, colonPos));
        }
        return messageName.getLocalPart().equals(lp) && messageName.getNamespaceURI().equals(ns);
    }

    private List findAllHeaderFaults(BindingOperation bindingOp) {
        ArrayList<String> headerFaults = new ArrayList<String>();
        if (bindingOp == null) {
            return headerFaults;
        }
        List ioElements = bindingOp.getBindingInput().getExtensibilityElements();
        ioElements.addAll(bindingOp.getBindingOutput().getExtensibilityElements());
        for (int i = 0; i < ioElements.size(); ++i) {
            int j;
            ExtensibilityElement extElem = (ExtensibilityElement)ioElements.get(i);
            if (extElem.getElementType().equals(WSDL_SOAP_HEADER)) {
                List shfList = ((SOAPHeader)extElem).getSOAPHeaderFaults();
                for (j = 0; j < shfList.size(); ++j) {
                    headerFaults.add(((SOAPHeaderFault)shfList.get(j)).getPart());
                }
                continue;
            }
            if (extElem.getElementType().equals(WSDL_SOAP_BODY)) continue;
            List elList = this.getHeaderFaults(((UnknownExtensibilityElement)extElem).getElement());
            for (j = 0; j < elList.size(); ++j) {
                headerFaults.add(((Element)elList.get(j)).getAttribute("part"));
            }
        }
        return headerFaults;
    }

    private List getHeaderFaults(Element element) {
        ArrayList<Element> headerFaults = new ArrayList<Element>();
        if (element != null) {
            Element child = XMLUtils.getFirstChild(element);
            while (child != null) {
                if (child.getNamespaceURI().equals(WSDL_SOAP_HEADERFAULT.getNamespaceURI()) && child.getLocalName().equals(WSDL_SOAP_HEADERFAULT.getLocalPart())) {
                    headerFaults.add(child);
                }
                child = XMLUtils.getNextSibling(child);
            }
        }
        return headerFaults;
    }
}

