/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class AP2944
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean mimeContentFound;

    public AP2944(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.mimeContentFound = false;
        try {
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List ops = binding.getBindingOperations();
            for (int i = 0; i < ops.size(); ++i) {
                Output portTypeOutput;
                MIMEContent imc;
                Input portTypeInput;
                BindingOperation bindingOperation = (BindingOperation)ops.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                List inputMimeContents = this.getMimeContentElements(bindingInput == null ? null : bindingInput.getExtensibilityElements());
                List outputMimeContents = this.getMimeContentElements(bindingOutput == null ? null : bindingOutput.getExtensibilityElements());
                if (!inputMimeContents.isEmpty() && (portTypeInput = bindingOperation.getOperation().getInput()) != null && portTypeInput.getMessage() != null && (imc = this.getInvalidMimeContent(inputMimeContents, portTypeInput.getMessage())) != null) {
                    throw new AssertionFailException("The mime:content element in the wsdl:input of the \"" + bindingOperation.getName() + "\" that binds the \"" + imc.getPart() + "\" wsdl:part uses the invalid content type \"" + imc.getType() + "\". ");
                }
                if (outputMimeContents.isEmpty() || (portTypeOutput = bindingOperation.getOperation().getOutput()) == null || portTypeOutput.getMessage() == null || (imc = this.getInvalidMimeContent(outputMimeContents, portTypeOutput.getMessage())) == null) continue;
                throw new AssertionFailException("The mime:content element in the wsdl:output of the \"" + bindingOperation.getName() + "\" that binds the \"" + imc.getPart() + "\" wsdl:part uses the invalid content type \"" + imc.getType() + "\". ");
            }
            if (!this.mimeContentFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException anae) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private MIMEContent getInvalidMimeContent(List mimeContents, Message message) {
        for (int i = 0; i < mimeContents.size(); ++i) {
            MIMEContent mimeContent = (MIMEContent)mimeContents.get(i);
            Part part = message.getPart(mimeContent.getPart());
            if (part == null || part.getElementName() == null) continue;
            this.mimeContentFound = true;
            if ("text/xml".equals(mimeContent.getType())) continue;
            return mimeContent;
        }
        return null;
    }

    private List getMimeContentElements(List extElems) {
        ArrayList<ExtensibilityElement> mimeContentElements = new ArrayList<ExtensibilityElement>();
        if (extElems != null) {
            for (int i = 0; i < extElems.size(); ++i) {
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (extElem.getElementType().equals(WSDL_MIME_MULTIPART)) {
                    List mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                    for (int j = 0; j < mimeParts.size(); ++j) {
                        List elems = this.getMimeContentElements(((MIMEPart)mimeParts.get(j)).getExtensibilityElements());
                        mimeContentElements.addAll(elems);
                    }
                    continue;
                }
                if (!extElem.getElementType().equals(WSDL_MIME_CONTENT)) continue;
                mimeContentElements.add(extElem);
            }
        }
        return mimeContentElements;
    }
}

