/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP2406
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2406(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        SOAPBody[] soapBodies = this.validator.getSoapBodies(binding);
        for (int i = 0; i < soapBodies.length; ++i) {
            SOAPBody soapBody = soapBodies[i];
            if (soapBody.getUse() == null || soapBody.getUse().equals("literal")) continue;
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(soapBody.toString(), entryContext);
            break;
        }
        SOAPFault[] soapFaults = this.validator.getSoapFaults(binding);
        for (int i = 0; i < soapFaults.length; ++i) {
            SOAPFault soapFault = soapFaults[i];
            if (soapFault.getUse() == null || soapFault.getUse().equals("literal")) continue;
            this.result = "failed";
            String string = this.failureDetailMessage = this.failureDetailMessage == null ? soapFault.toString() : this.failureDetailMessage + "\n\n" + soapFault.toString();
            if (this.failureDetail == null) {
                this.failureDetail = this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
                break;
            }
            this.failureDetail.setFailureMessage(this.failureDetailMessage);
            break;
        }
        SOAPHeader[] soapHeaders = this.validator.getSoapHeaders(binding);
        for (int i = 0; i < soapHeaders.length; ++i) {
            SOAPHeader soapHeader = soapHeaders[i];
            if (soapHeader.getUse() == null || soapHeader.getUse().equals("literal")) continue;
            this.result = "failed";
            String string = this.failureDetailMessage = this.failureDetailMessage == null ? soapHeader.toString() : this.failureDetailMessage + "\n\n" + soapHeader.toString();
            if (this.failureDetail == null) {
                this.failureDetail = this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
                break;
            }
            this.failureDetail.setFailureMessage(this.failureDetailMessage);
            break;
        }
        SOAPHeaderFault[] soapHeaderFaults = this.validator.getSoapHeaderFaults(binding);
        for (int i = 0; i < soapHeaderFaults.length; ++i) {
            SOAPHeaderFault soapHeaderFault = soapHeaderFaults[i];
            if (soapHeaderFault.getUse() == null || soapHeaderFault.getUse().equals("literal")) continue;
            this.result = "failed";
            String string = this.failureDetailMessage = this.failureDetailMessage == null ? soapHeaderFault.toString() : this.failureDetailMessage + "\n\n" + soapHeaderFault.toString();
            if (this.failureDetail == null) {
                this.failureDetail = this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
                break;
            }
            this.failureDetail.setFailureMessage(this.failureDetailMessage);
            break;
        }
        if (!(this.result != "passed" || soapBodies != null && soapBodies.length != 0 || soapFaults != null && soapFaults.length != 0 || soapHeaders != null && soapHeaders.length != 0 || soapHeaderFaults != null && soapHeaderFaults.length != 0)) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

