/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.validator.BaseValidator;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLVisitor;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class TypesRegistry
implements WSITag,
WSDLVisitor {
    List schemaProcessedList = new ArrayList();
    private Map element2Type = new HashMap();
    private Set extendsArray = new HashSet();
    private Set usesWsdlArrayType = new HashSet();
    protected BaseValidator baseValidator = null;

    public void visit(Part obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Service obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Types obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Operation obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Input obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Output obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Fault obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Binding obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(BindingOperation obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(BindingInput obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(BindingOutput obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(BindingFault obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Element obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Message obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Port obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(PortType obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(Definition obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(ExtensibilityElement obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(SOAPBinding obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(SOAPBody obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(SOAPHeader obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(SOAPHeaderFault obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(SOAPFault obj, Object parent, WSDLTraversalContext ctx) {
    }

    public void visit(SOAPOperation obj, Object parent, WSDLTraversalContext ctx) {
    }

    public TypesRegistry(Definition def, BaseValidator baseValidator) {
        this.baseValidator = baseValidator;
        if (def == null) {
            throw new IllegalArgumentException("Definition can not be null");
        }
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitImport(true);
        this.processTypes(def.getTypes(), def.getDocumentBaseURI());
        traversal.traverse(def);
    }

    public TypesRegistry(Types types, String context, BaseValidator baseValidator) {
        this.baseValidator = baseValidator;
        this.processTypes(types, context);
    }

    public QName getType(QName elementName) {
        return (QName)this.element2Type.get(elementName);
    }

    public Set getArrayTypes() {
        HashSet s = new HashSet();
        s.addAll(this.usesWsdlArrayType);
        s.addAll(this.extendsArray);
        return s;
    }

    public Set getElementList() {
        return this.element2Type.keySet();
    }

    public boolean isUsesWSDLArrayType(QName type) {
        return this.usesWsdlArrayType.contains(type);
    }

    public boolean isExtendsArray(QName type) {
        return this.extendsArray.contains(type);
    }

    public void visit(Import im, Object parent, WSDLTraversalContext ctx) {
        if (im.getDefinition() != null) {
            this.processWSDL(im.getDefinition());
        }
    }

    private void processWSDL(Definition def) {
        if (def.getTypes() != null) {
            this.processTypes(def.getTypes(), def.getDocumentBaseURI());
        }
    }

    private void processTypes(Types types, String context) {
        if (types == null) {
            return;
        }
        List exts = types.getExtensibilityElements();
        if (exts != null) {
            for (ExtensibilityElement el : exts) {
                if (!(el instanceof Schema)) continue;
                this.searchForSchema(((Schema)el).getElement(), context);
            }
        }
    }

    private void searchForSchema(Node n, String context) {
        while (n != null) {
            if (1 == n.getNodeType() && XMLUtils.equals(n, ELEM_XSD_SCHEMA)) {
                this.processSchema(n, context, new ArrayList());
            }
            n = n.getNextSibling();
        }
    }

    private void loadSchema(Node importNode, String context, List processedSchemas) {
        Element im = (Element)importNode;
        Attr schemaLocation = XMLUtils.getAttribute(im, ATTR_XSD_SCHEMALOCATION);
        if (schemaLocation != null && schemaLocation.getValue() != null) {
            try {
                String urlString = XMLUtils.createURLString(schemaLocation.getValue(), context);
                if (!this.schemaProcessedList.contains(urlString)) {
                    Document schema = this.baseValidator.parseXMLDocumentURL(schemaLocation.getValue(), context, null);
                    this.schemaProcessedList.add(urlString);
                    if (XMLUtils.equals(schema.getDocumentElement(), ELEM_XSD_SCHEMA)) {
                        this.processSchema(schema.getDocumentElement(), urlString, processedSchemas);
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private void processSchema(Node schema, String context, List processedSchemas) {
        if (schema != null && !processedSchemas.contains(schema)) {
            processedSchemas.add(schema);
            Attr a = XMLUtils.getAttribute((Element)schema, ATTR_XSD_TARGETNAMESPACE);
            String targetNamespace = a != null ? a.getValue() : "";
            for (Node n = schema.getFirstChild(); n != null; n = n.getNextSibling()) {
                Element el;
                if (1 != n.getNodeType()) continue;
                if (XMLUtils.equals(n, ELEM_XSD_ELEMENT)) {
                    el = (Element)n;
                    a = XMLUtils.getAttribute(el, ATTR_XSD_NAME);
                    QName element = new QName(targetNamespace, a != null ? a.getValue() : "");
                    a = XMLUtils.getAttribute(el, ATTR_XSD_TYPE);
                    QName type = null;
                    if (a != null) {
                        String t = a.getValue();
                        int i = t.indexOf(58);
                        if (i != -1) {
                            String prefix = t.substring(0, i);
                            String nsURI = XMLUtils.findNamespaceURI(n, prefix);
                            type = new QName(nsURI, t.substring(i + 1));
                        } else {
                            type = new QName(targetNamespace, t);
                        }
                    } else {
                        type = element;
                        this.checkType(n, type);
                    }
                    this.element2Type.put(element, type);
                    continue;
                }
                if (XMLUtils.equals(n, ELEM_XSD_IMPORT)) {
                    this.loadSchema(n, context, processedSchemas);
                    continue;
                }
                if (XMLUtils.equals(n, ELEM_XSD_INCLUDE)) {
                    this.loadSchema(n, context, processedSchemas);
                    continue;
                }
                if (!XMLUtils.equals(n, ELEM_XSD_COMPLEXTYPE)) continue;
                el = (Element)n;
                a = XMLUtils.getAttribute(el, ATTR_XSD_NAME);
                QName type = new QName(targetNamespace, a != null ? a.getValue() : "");
                this.checkType(n, type);
            }
        }
    }

    private void checkType(Node n, QName name) {
        while (n != null) {
            if (1 == n.getNodeType()) {
                String base;
                int i;
                Attr a;
                if (XMLUtils.equals(n, ELEM_XSD_ATTRIBUTE) && (a = XMLUtils.getAttribute((Element)n, ATTR_WSDL_ARRAYTYPE)) != null) {
                    this.usesWsdlArrayType.add(name);
                }
                if ((a = XMLUtils.getAttribute((Element)n, ATTR_XSD_BASE)) != null && (i = (base = a.getValue()).indexOf(":")) != -1) {
                    String prefix = base.substring(0, i);
                    String local = base.substring(i + 1);
                    String namespace = XMLUtils.findNamespaceURI(n, prefix);
                    if (SOAPENC_ARRAY.equals(new QName(namespace, local))) {
                        this.extendsArray.add(name);
                    }
                }
                this.checkType(n.getFirstChild(), name);
            }
            n = n.getNextSibling();
        }
    }
}

