/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.wsdl.xsd;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class LazyURLInputStream
extends InputStream {
    private static int debugTotalOpenStreamCount = 0;
    protected InputStream inner;
    protected String url;
    protected boolean error;
    boolean hasMarks;
    boolean pretendFileIsStillOpen;

    public LazyURLInputStream(String url) {
        this.url = url;
        this.inner = null;
        this.pretendFileIsStillOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInnerStreamIfRequired() throws IOException {
        if (this.inner == null && !this.error) {
            ++debugTotalOpenStreamCount;
            try {
                this.inner = new URL(this.url).openStream();
                this.pretendFileIsStillOpen = false;
                this.hasMarks = false;
            }
            finally {
                if (this.inner == null) {
                    this.error = true;
                }
            }
        }
    }

    protected void closeStream() throws IOException {
        if (this.inner != null && !this.pretendFileIsStillOpen) {
            this.inner.close();
            this.pretendFileIsStillOpen = true;
        }
    }

    public int available() throws IOException {
        if (this.pretendFileIsStillOpen) {
            return 0;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        return this.inner.available();
    }

    public void close() throws IOException {
        if (this.pretendFileIsStillOpen) {
            this.pretendFileIsStillOpen = false;
        } else if (this.inner != null) {
            --debugTotalOpenStreamCount;
            this.inner.close();
        }
    }

    public void mark(int readlimit) {
        if (this.pretendFileIsStillOpen) {
            return;
        }
        this.hasMarks = true;
        try {
            this.createInnerStreamIfRequired();
            this.inner.mark(readlimit);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean markSupported() {
        if (this.pretendFileIsStillOpen) {
            return false;
        }
        try {
            this.createInnerStreamIfRequired();
            if (this.inner == null) {
                return false;
            }
            return this.inner.markSupported();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int read() throws IOException {
        if (this.pretendFileIsStillOpen) {
            return -1;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        int bytesRead = this.inner.read();
        if (bytesRead == -1 && !this.hasMarks) {
            this.closeStream();
        }
        return bytesRead;
    }

    public int read(byte[] b) throws IOException {
        if (this.pretendFileIsStillOpen) {
            return -1;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        int bytesRead = this.inner.read(b);
        if (bytesRead == -1 && !this.hasMarks) {
            this.closeStream();
        }
        return bytesRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pretendFileIsStillOpen) {
            return -1;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        int bytesRead = this.inner.read(b, off, len);
        if (bytesRead == -1 && !this.hasMarks) {
            this.closeStream();
        }
        return bytesRead;
    }

    public void reset() throws IOException {
        if (this.pretendFileIsStillOpen) {
            return;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        this.inner.reset();
    }

    public long skip(long n) throws IOException {
        if (this.pretendFileIsStillOpen) {
            return 0L;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        return this.inner.skip(n);
    }
}

