/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.cli;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XppStreamConsumer
extends Thread
implements StreamConsumer {
    private Writer writer;
    private XmlPullParser parser = new MXParser();
    private volatile boolean complete = false;
    private ScmLogger logger;
    private int lineCount = 0;
    private Reader reader;

    public ScmLogger getLogger() {
        return this.logger;
    }

    public XppStreamConsumer(ScmLogger logger) {
        this.logger = logger;
        try {
            Pipe p = Pipe.open();
            Pipe.SinkChannel sink = p.sink();
            Pipe.SourceChannel source = p.source();
            this.writer = Channels.newWriter((WritableByteChannel)sink, Charset.defaultCharset().name());
            this.reader = Channels.newReader((ReadableByteChannel)source, Charset.defaultCharset().name());
            this.parser.setInput(this.reader);
        }
        catch (Exception e) {
            logger.error("Exception initialising pipe", e);
        }
    }

    @Override
    public final void consumeLine(String line) {
        try {
            this.writer.append(line);
            if (this.lineCount == 0) {
                this.start();
            }
            ++this.lineCount;
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("error pumping line to pipe", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.parse(this.parser);
        }
        catch (Exception e) {
            this.caughtParseException(e);
        }
        finally {
            XppStreamConsumer xppStreamConsumer = this;
            synchronized (xppStreamConsumer) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    this.getLogger().warn("Error closing pipe reader", e);
                }
                this.complete = true;
                this.notifyAll();
            }
        }
    }

    protected void caughtParseException(Exception e) {
        this.logger.warn("Exception parsing input", e);
    }

    protected void parse(XmlPullParser p) throws XmlPullParserException, IOException {
        ArrayList<String> tagPath = new ArrayList<String>();
        int eventType = p.getEventType();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Event " + eventType);
        }
        while (eventType != 1) {
            int lastIndex = tagPath.size() - 1;
            switch (eventType) {
                case 0: {
                    break;
                }
                case 2: {
                    String tagName = p.getName();
                    if (tagName == null) break;
                    tagPath.add(tagName);
                    int attributeCount = p.getAttributeCount();
                    HashMap<String, String> attributes = new HashMap<String, String>(Math.max(attributeCount, 0));
                    for (int i = 0; i < attributeCount; ++i) {
                        attributes.put(p.getAttributeName(i), p.getAttributeValue(i));
                    }
                    this.startTag(tagPath, attributes);
                    break;
                }
                case 4: {
                    if (p.isWhitespace()) break;
                    String text = p.getText();
                    this.text(tagPath, text);
                    break;
                }
                case 3: {
                    String tagName = p.getName();
                    if (lastIndex < 0 || !tagName.equals(tagPath.get(lastIndex))) {
                        this.logger.warn("Bad tag path: " + Arrays.toString(tagPath.toArray()));
                    }
                    this.endTag(tagPath);
                    tagPath.remove(lastIndex);
                    break;
                }
                default: {
                    this.logger.warn("Unexpected event type " + eventType);
                }
            }
            p.next();
            eventType = p.getEventType();
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Event " + eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitComplete() {
        Thread.yield();
        try {
            this.writer.close();
        }
        catch (IOException e1) {
            this.logger.warn("Exception flushing output", e1);
        }
        while (!this.isComplete()) {
            XppStreamConsumer xppStreamConsumer = this;
            synchronized (xppStreamConsumer) {
                try {
                    if (!this.isComplete()) {
                        this.wait(1000L);
                    }
                }
                catch (Exception e) {
                    this.logger.warn(e);
                }
            }
        }
    }

    private boolean isComplete() {
        return this.complete || this.lineCount == 0;
    }

    protected void startTag(List<String> tagPath, Map<String, String> attributes) {
        if (this.logger.isDebugEnabled()) {
            String tagName = XppStreamConsumer.getTagName(tagPath);
            this.logger.debug("START_TAG: " + tagName + "(" + attributes.size() + ")");
        }
    }

    protected static String getTagName(List<String> tagPath) {
        return tagPath.size() == 0 ? null : tagPath.get(tagPath.size() - 1);
    }

    protected void endTag(List<String> tagPath) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("END_TAG: " + XppStreamConsumer.getTagName(tagPath));
        }
    }

    protected void text(List<String> tagPath, String text) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("TEXT: " + text);
        }
    }
}

