/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command.blame;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.bazaar.command.BazaarConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarBlameConsumer
extends BazaarConsumer {
    private static final String BAZAAR_TIMESTAMP_PATTERN = "yyyyMMdd";
    private List<BlameLine> lines = new ArrayList<BlameLine>();

    public BazaarBlameConsumer(ScmLogger logger) {
        super(logger);
    }

    @Override
    public void doConsume(ScmFileStatus status2, String trimmedLine) {
        String annotation = trimmedLine.substring(0, trimmedLine.indexOf(124)).trim();
        String dateStr = annotation.substring(annotation.lastIndexOf(32) + 1);
        annotation = annotation.substring(0, annotation.lastIndexOf(32));
        String author = annotation.substring(annotation.lastIndexOf(32) + 1);
        annotation = annotation.substring(0, annotation.lastIndexOf(32));
        String revision = annotation.trim();
        Date date = this.parseDate(dateStr, null, BAZAAR_TIMESTAMP_PATTERN);
        this.lines.add(new BlameLine(date, revision, author));
    }

    public List<BlameLine> getLines() {
        return this.lines;
    }
}

