/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command.checkin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.bazaar.BazaarUtils;
import org.apache.maven.scm.provider.bazaar.command.BazaarConsumer;
import org.apache.maven.scm.provider.bazaar.command.status.BazaarStatusCommand;
import org.apache.maven.scm.provider.bazaar.repository.BazaarScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class BazaarCheckInCommand
extends AbstractCheckInCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion version) throws ScmException {
        if (version != null && StringUtils.isNotEmpty(version.getName())) {
            throw new ScmException("This provider can't handle tags.");
        }
        ArrayList<ScmFile> commitedFiles = new ArrayList<ScmFile>();
        List<File> files = fileSet.getFileList();
        if (files.isEmpty()) {
            BazaarStatusCommand statusCmd = new BazaarStatusCommand();
            statusCmd.setLogger(this.getLogger());
            StatusScmResult status2 = statusCmd.executeStatusCommand(repo, fileSet);
            List<ScmFile> statusFiles = status2.getChangedFiles();
            for (ScmFile file : statusFiles) {
                if (file.getStatus() != ScmFileStatus.ADDED && file.getStatus() != ScmFileStatus.DELETED && file.getStatus() != ScmFileStatus.MODIFIED) continue;
                commitedFiles.add(new ScmFile(file.getPath(), ScmFileStatus.CHECKED_IN));
            }
        } else {
            for (File file : files) {
                commitedFiles.add(new ScmFile(file.getPath(), ScmFileStatus.CHECKED_IN));
            }
        }
        String[] commitCmd = new String[]{"commit", "--message", message};
        commitCmd = BazaarUtils.expandCommandLine(commitCmd, fileSet);
        ScmResult result = BazaarUtils.execute(new BazaarConsumer(this.getLogger()), this.getLogger(), fileSet.getBasedir(), commitCmd);
        BazaarScmProviderRepository repository = (BazaarScmProviderRepository)repo;
        if (!repository.getURI().equals(fileSet.getBasedir().getAbsolutePath()) && repo.isPushChanges()) {
            String[] pushCmd = new String[]{"push", "--no-strict", repository.getURI()};
            result = BazaarUtils.execute(new BazaarConsumer(this.getLogger()), this.getLogger(), fileSet.getBasedir(), pushCmd);
        }
        return new CheckInScmResult(commitedFiles, result);
    }
}

