/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.blame;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseBlameConsumer
extends AbstractConsumer {
    private static final String CLEARCASE_TIMESTAMP_PATTERN = "yyyyMMdd.HHmmss";
    private static final String LINE_PATTERN = "VERSION:(.*)@@@USER:(.*)@@@DATE:(.*)@@@(.*)";
    private RE lineRegexp;
    private List<BlameLine> lines = new ArrayList<BlameLine>();

    public ClearCaseBlameConsumer(ScmLogger logger) {
        super(logger);
        this.lineRegexp = new RE(LINE_PATTERN);
    }

    @Override
    public void consumeLine(String line) {
        if (this.lineRegexp.match(line)) {
            String revision = this.lineRegexp.getParen(1);
            String author = this.lineRegexp.getParen(2).toLowerCase();
            String dateTimeStr = this.lineRegexp.getParen(3);
            Date dateTime = this.parseDate(dateTimeStr, null, CLEARCASE_TIMESTAMP_PATTERN);
            this.lines.add(new BlameLine(dateTime, revision, author));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(author + " " + dateTimeStr);
            }
        }
    }

    public List<BlameLine> getLines() {
        return this.lines;
    }
}

