/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.cvsjava.util;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class ExtConnection
extends AbstractConnection {
    private String host;
    private int port;
    private String userName;
    private String password;
    private Connection connection;
    private Session session;
    private BufferedReader stderrReader;

    public ExtConnection(CVSRoot cvsRoot) {
        this(cvsRoot.getHostName(), cvsRoot.getPort(), cvsRoot.getUserName(), cvsRoot.getPassword(), cvsRoot.getRepository());
    }

    public ExtConnection(String host, int port, String username, String password, String repository) {
        this.userName = username;
        if (this.userName == null) {
            this.userName = System.getProperty("user.name");
        }
        this.password = password;
        this.host = host;
        this.setRepository(repository);
        this.port = port;
        if (this.port == 0) {
            this.port = 22;
        }
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        this.connection = new Connection(this.host, this.port);
        try {
            this.connection.connect();
        }
        catch (IOException e) {
            String message = "Cannot connect. Reason: " + e.getMessage();
            throw new AuthenticationException(message, e, message);
        }
        File privateKey = this.getPrivateKey();
        try {
            boolean authenticated = privateKey != null && privateKey.exists() ? this.connection.authenticateWithPublicKey(this.userName, privateKey, this.getPassphrase()) : this.connection.authenticateWithPassword(this.userName, this.password);
            if (!authenticated) {
                String message = "Authentication failed.";
                throw new AuthenticationException(message, message);
            }
        }
        catch (IOException e) {
            this.closeConnection();
            String message = "Cannot authenticate. Reason: " + e.getMessage();
            throw new AuthenticationException(message, e, message);
        }
        try {
            this.session = this.connection.openSession();
        }
        catch (IOException e) {
            String message = "Cannot open session. Reason: " + e.getMessage();
            throw new CommandAbortedException(message, message);
        }
        String command = "cvs server";
        try {
            this.session.execCommand(command);
        }
        catch (IOException e) {
            String message = "Cannot execute remote command: " + command;
            throw new CommandAbortedException(message, message);
        }
        StreamGobbler stdout = new StreamGobbler(this.session.getStdout());
        StreamGobbler stderr = new StreamGobbler(this.session.getStderr());
        this.stderrReader = new BufferedReader(new InputStreamReader(stderr));
        this.setInputStream(new LoggedDataInputStream(stdout));
        this.setOutputStream(new LoggedDataOutputStream(this.session.getStdin()));
    }

    public void verify() throws AuthenticationException {
        try {
            this.open();
            this.verifyProtocol();
            this.close();
        }
        catch (Exception e) {
            String message = "Failed to verify the connection: " + e.getMessage();
            throw new AuthenticationException(message, e, message);
        }
    }

    private void closeConnection() {
        try {
            if (this.stderrReader != null) {
                String line;
                while ((line = this.stderrReader.readLine()) != null) {
                    System.err.println(line);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.session != null) {
            System.out.println("Exit code:" + this.session.getExitStatus());
            this.session.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        this.reset();
    }

    private void reset() {
        this.connection = null;
        this.session = null;
        this.stderrReader = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    public void close() throws IOException {
        this.closeConnection();
    }

    public boolean isOpen() {
        return this.connection != null;
    }

    public int getPort() {
        return this.port;
    }

    public void modifyInputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyOutputStream(this.getOutputStream());
    }

    private File getPrivateKey() {
        File privateKey = null;
        if (this.password == null) {
            String pk = System.getProperty("maven.scm.cvs.java.ssh.privateKey");
            privateKey = pk != null ? new File(pk) : this.findPrivateKey();
        }
        return privateKey;
    }

    private String getPassphrase() {
        String passphrase = System.getProperty("maven.scm.cvs.java.ssh.passphrase");
        if (passphrase == null) {
            passphrase = "";
        }
        return passphrase;
    }

    private File findPrivateKey() {
        File privateKey;
        String privateKeyDirectory = System.getProperty("maven.scm.ssh.privateKeyDirectory");
        if (privateKeyDirectory == null) {
            privateKeyDirectory = System.getProperty("user.home");
        }
        if (!(privateKey = new File(privateKeyDirectory, ".ssh/id_dsa")).exists()) {
            privateKey = new File(privateKeyDirectory, ".ssh/id_rsa");
        }
        return privateKey;
    }
}

