/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.info;

import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.info.GitInfoConsumer;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitInfoCommand
extends AbstractCommand
implements GitCommand {
    public static final int NO_REVISION_LENGTH = -1;

    protected ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        GitInfoConsumer consumer = new GitInfoConsumer(this.getLogger(), fileSet);
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline cli = GitInfoCommand.createCommandLine(repository, fileSet, parameters);
        int exitCode = GitCommandLineUtils.execute(cli, consumer, stderr, this.getLogger());
        if (exitCode != 0) {
            return new InfoScmResult(cli.toString(), "The git rev-parse command failed.", stderr.getOutput(), false);
        }
        return new InfoScmResult(cli.toString(), consumer.getInfoItems());
    }

    public static Commandline createCommandLine(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        Commandline cli = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "rev-parse");
        cli.createArg().setValue("--verify");
        int revLength = GitInfoCommand.getRevisionLength(parameters);
        if (revLength > -1) {
            cli.createArg().setValue("--short=" + revLength);
        }
        cli.createArg().setValue("HEAD");
        return cli;
    }

    private static int getRevisionLength(CommandParameters parameters) throws ScmException {
        if (parameters == null) {
            return -1;
        }
        return parameters.getInt(CommandParameter.SCM_SHORT_REVISION_LENGTH, -1);
    }
}

