/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.tag;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListCommand;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitTagCommand
extends AbstractTagCommand
implements GitCommand {
    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag2, String message) throws ScmException {
        return this.executeTagCommand(repo, fileSet, tag2, new ScmTagParameters(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag2, ScmTagParameters scmTagParameters) throws ScmException {
        if (tag2 == null) throw new ScmException("tag name must be specified");
        if (StringUtils.isEmpty(tag2.trim())) {
            throw new ScmException("tag name must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory");
        }
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        File messageFile = FileUtils.createTempFile("maven-scm-", ".commit", null);
        try {
            FileUtils.fileWrite(messageFile.getAbsolutePath(), scmTagParameters.getMessage());
        }
        catch (IOException ex) {
            return new TagScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        try {
            Commandline clPush;
            CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
            Commandline clTag = GitTagCommand.createCommandLine(repository, fileSet.getBasedir(), tag2, messageFile);
            int exitCode = GitCommandLineUtils.execute(clTag, stdout, stderr, this.getLogger());
            if (exitCode != 0) {
                TagScmResult tagScmResult = new TagScmResult(clTag.toString(), "The git-tag command failed.", stderr.getOutput(), false);
                return tagScmResult;
            }
            if (repo.isPushChanges() && (exitCode = GitCommandLineUtils.execute(clPush = GitTagCommand.createPushCommandLine(repository, fileSet, tag2), stdout, stderr, this.getLogger())) != 0) {
                TagScmResult ex = new TagScmResult(clPush.toString(), "The git-push command failed.", stderr.getOutput(), false);
                return ex;
            }
            GitListConsumer listConsumer = new GitListConsumer(this.getLogger(), fileSet.getBasedir(), ScmFileStatus.TAGGED);
            Commandline clList = GitListCommand.createCommandLine(repository, fileSet.getBasedir());
            exitCode = GitCommandLineUtils.execute(clList, listConsumer, stderr, this.getLogger());
            if (exitCode != 0) {
                CheckOutScmResult checkOutScmResult = new CheckOutScmResult(clList.toString(), "The git-ls-files command failed.", stderr.getOutput(), false);
                return checkOutScmResult;
            }
            TagScmResult tagScmResult = new TagScmResult(clTag.toString(), listConsumer.getListedFiles());
            return tagScmResult;
        }
        finally {
            try {
                FileUtils.forceDelete(messageFile);
            }
            catch (IOException ex) {}
        }
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, String tag2, File messageFile) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "tag");
        cl.createArg().setValue("-F");
        cl.createArg().setValue(messageFile.getAbsolutePath());
        cl.createArg().setValue(tag2);
        return cl;
    }

    public static Commandline createPushCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet, String tag2) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "push");
        cl.createArg().setValue(repository.getPushUrl());
        cl.createArg().setValue(tag2);
        return cl;
    }
}

