/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.status;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.consumer.AbstractRepositoryConsumer;
import org.apache.maven.scm.provider.jazz.repository.JazzScmProviderRepository;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JazzStatusConsumer
extends AbstractRepositoryConsumer {
    private static final String WORKSPACE_PATTERN = "\\((\\d+)\\) \"(.*)\" <-> \\((\\d+)\\) \"(.*)\"";
    private RE workspaceRegExp;
    private static final String COMPONENT_PATTERN1 = "\\((\\d+)\\) \"(.*)\"";
    private RE componentRegExp1;
    private static final String COMPONENT_PATTERN2 = "\\((\\d+)\\) \"(.*)\" <.*>";
    private RE componentRegExp2;
    private static final String BASELINE_PATTERN = "\\((\\d+)\\) (\\d+) \"(.*)\"";
    private RE baselineRegExp;
    public static final String STATUS_CMD_WORKSPACE = "Workspace:";
    public static final String STATUS_CMD_COMPONENT = "Component:";
    public static final String STATUS_CMD_BASELINE = "Baseline:";
    public static final String STATUS_CMD_ADD_FLAG = "a-";
    public static final String STATUS_CMD_CHANGE_FLAG = "-c";
    public static final String STATUS_CMD_DELETE_FLAG = "d-";
    public static final String STATUS_CMD_MOVED_FLAG = "m-";
    private List<ScmFile> fChangedFiles = new ArrayList<ScmFile>();

    public JazzStatusConsumer(ScmProviderRepository repo, ScmLogger logger) {
        super(repo, logger);
        try {
            this.workspaceRegExp = new RE(WORKSPACE_PATTERN);
            this.componentRegExp1 = new RE(COMPONENT_PATTERN1);
            this.componentRegExp2 = new RE(COMPONENT_PATTERN2);
            this.baselineRegExp = new RE(BASELINE_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse jazz scm status output. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    @Override
    public void consumeLine(String line) {
        super.consumeLine(line);
        if (this.containsWorkspace(line)) {
            this.extractWorkspace(line);
        }
        if (this.containsComponent(line)) {
            this.extractComponent(line);
        }
        if (this.containsBaseline(line)) {
            this.extractBaseline(line);
        }
        if (this.containsStatusFlag(line)) {
            this.extractChangedFile(line);
        }
    }

    private boolean containsWorkspace(String line) {
        return line.trim().startsWith(STATUS_CMD_WORKSPACE);
    }

    private void extractWorkspace(String line) {
        if (this.workspaceRegExp.match(line)) {
            JazzScmProviderRepository jazzRepository = (JazzScmProviderRepository)this.getRepository();
            int workspaceAlias = Integer.parseInt(this.workspaceRegExp.getParen(1));
            String workspace = this.workspaceRegExp.getParen(2);
            int streamAlias = Integer.parseInt(this.workspaceRegExp.getParen(3));
            String stream = this.workspaceRegExp.getParen(4);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Successfully parsed \"Workspace:\" line:");
                this.getLogger().debug("  workspaceAlias = " + workspaceAlias);
                this.getLogger().debug("  workspace      = " + workspace);
                this.getLogger().debug("  streamAlias    = " + streamAlias);
                this.getLogger().debug("  stream         = " + stream);
            }
            jazzRepository.setWorkspaceAlias(workspaceAlias);
            jazzRepository.setWorkspace(workspace);
            jazzRepository.setFlowTargetAlias(streamAlias);
            jazzRepository.setFlowTarget(stream);
        }
    }

    private boolean containsComponent(String line) {
        return line.trim().startsWith(STATUS_CMD_COMPONENT);
    }

    private void extractComponent(String line) {
        String component;
        int componentAlias;
        JazzScmProviderRepository jazzRepository;
        if (this.componentRegExp1.match(line)) {
            jazzRepository = (JazzScmProviderRepository)this.getRepository();
            componentAlias = Integer.parseInt(this.componentRegExp1.getParen(1));
            component = this.componentRegExp1.getParen(2);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Successfully parsed \"Component:\" line:");
                this.getLogger().debug("  componentAlias = " + componentAlias);
                this.getLogger().debug("  component      = " + component);
            }
            jazzRepository.setComponent(component);
        }
        if (this.componentRegExp2.match(line)) {
            jazzRepository = (JazzScmProviderRepository)this.getRepository();
            componentAlias = Integer.parseInt(this.componentRegExp2.getParen(1));
            component = this.componentRegExp2.getParen(2);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Successfully parsed \"Component:\" line:");
                this.getLogger().debug("  componentAlias = " + componentAlias);
                this.getLogger().debug("  component      = " + component);
            }
            jazzRepository.setComponent(component);
        }
    }

    private boolean containsBaseline(String line) {
        return line.trim().startsWith(STATUS_CMD_BASELINE);
    }

    private void extractBaseline(String line) {
        if (this.baselineRegExp.match(line)) {
            JazzScmProviderRepository jazzRepository = (JazzScmProviderRepository)this.getRepository();
            int baselineAlias = Integer.parseInt(this.baselineRegExp.getParen(1));
            int baselineId = Integer.parseInt(this.baselineRegExp.getParen(2));
            String baseline = this.baselineRegExp.getParen(3);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Successfully parsed \"Baseline:\" line:");
                this.getLogger().debug("  baselineAlias = " + baselineAlias);
                this.getLogger().debug("  baselineId    = " + baselineId);
                this.getLogger().debug("  baseline      = " + baseline);
            }
            jazzRepository.setBaseline(baseline);
        }
    }

    private boolean containsStatusFlag(String line) {
        String flag;
        boolean containsStatusFlag = false;
        if (line.trim().length() > 2 && (STATUS_CMD_ADD_FLAG.equals(flag = line.trim().substring(0, 2)) || STATUS_CMD_CHANGE_FLAG.equals(flag) || STATUS_CMD_DELETE_FLAG.equals(flag))) {
            containsStatusFlag = true;
        }
        return containsStatusFlag;
    }

    private void extractChangedFile(String line) {
        String flag = line.trim().substring(0, 2);
        String filePath = line.trim().substring(3).trim();
        ScmFileStatus status2 = ScmFileStatus.UNKNOWN;
        if (STATUS_CMD_ADD_FLAG.equals(flag)) {
            status2 = ScmFileStatus.ADDED;
        }
        if (STATUS_CMD_CHANGE_FLAG.equals(flag)) {
            status2 = ScmFileStatus.MODIFIED;
        }
        if (STATUS_CMD_DELETE_FLAG.equals(flag)) {
            status2 = ScmFileStatus.DELETED;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(" Line               : '" + line + "'");
            this.getLogger().debug(" Extracted filePath : '" + filePath + "'");
            this.getLogger().debug(" Extracted     flag : '" + flag + "'");
            this.getLogger().debug(" Extracted   status : '" + status2 + "'");
        }
        this.fChangedFiles.add(new ScmFile(filePath, status2));
    }

    public List<ScmFile> getChangedFiles() {
        return this.fChangedFiles;
    }
}

