/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.status;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarteamStatusConsumer
implements StreamConsumer {
    private ScmLogger logger;
    private String workingDirectory;
    private List<ScmFile> changedFiles = new ArrayList<ScmFile>();
    private static final String DIR_MARKER = "(working dir: ";
    private static final String FILE_MARKER = "History for: ";
    private static final String STATUS_MARKER = "Status: ";
    private static final String OUTDATE_MARKER = "Out of Date";
    private static final String MISSING_MARKER = "Missing";
    private static final String CURRENT_MARKER = "Current";
    private static final String MERGE_MARKER = "Merge";
    private static final String MODIFIED_MARKER = "Modified";
    private String currentDir = "";
    private String currentFile = "";

    public StarteamStatusConsumer(ScmLogger logger, File basedir) {
        this.logger = logger;
        this.workingDirectory = basedir.getPath().replace('\\', '/');
    }

    @Override
    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        int pos = 0;
        pos = line.indexOf(DIR_MARKER);
        if (pos != -1) {
            this.processGetDir(line, pos);
        } else {
            pos = line.indexOf(FILE_MARKER);
            if (pos != -1) {
                this.processGetFile(line, pos);
            } else {
                pos = line.indexOf(STATUS_MARKER);
                if (pos != -1) {
                    this.processStatus(line, pos);
                }
            }
        }
    }

    private void processGetDir(String line, int pos) {
        String dirPath = line.substring(pos + DIR_MARKER.length(), line.length() - 1).replace('\\', '/');
        this.currentDir = "." + dirPath.substring(this.workingDirectory.length());
    }

    private void processGetFile(String line, int pos) {
        String checkedOutFilePath;
        String fileName = line.substring(pos + FILE_MARKER.length(), line.length());
        this.currentFile = checkedOutFilePath = this.currentDir + "/" + fileName;
    }

    private void processStatus(String line, int pos) {
        String status2 = line.substring(pos + STATUS_MARKER.length(), line.length());
        if (status2.equals(OUTDATE_MARKER)) {
            this.changedFiles.add(new ScmFile(this.currentFile, ScmFileStatus.MODIFIED));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Out of Date file: " + this.currentFile);
            }
        } else if (status2.equals(MODIFIED_MARKER)) {
            this.changedFiles.add(new ScmFile(this.currentFile, ScmFileStatus.MODIFIED));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Modified file: " + this.currentFile);
            }
        } else if (status2.equals(MISSING_MARKER)) {
            this.changedFiles.add(new ScmFile(this.currentFile, ScmFileStatus.ADDED));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Missing file: " + this.currentFile);
            }
        } else if (status2.equals(MERGE_MARKER)) {
            this.changedFiles.add(new ScmFile(this.currentFile, ScmFileStatus.CONFLICT));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Conflict file: " + this.currentFile);
            }
        } else if (!status2.equals(CURRENT_MARKER) && this.logger.isWarnEnabled()) {
            this.logger.warn("status unknown (" + status2 + "): " + this.currentFile);
        }
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }
}

