/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.svn.SvnChangeSet;
import org.apache.maven.scm.provider.svn.svnexe.command.changelog.IllegalOutputException;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnChangeLogConsumer
extends AbstractConsumer {
    private static final String SVN_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss zzzzzzzzz";
    private static final int GET_HEADER = 1;
    private static final int GET_FILE = 2;
    private static final int GET_COMMENT = 3;
    private static final RE FILE_PATTERN = new RE("^\\s\\s\\s([:upper:])\\s(.+)$");
    private static final RE ORIG_FILE_PATTERN = new RE("\\([:alpha:]+ (.+):(\\d+)\\)");
    private static final String FILE_END_TOKEN = "";
    private static final String COMMENT_END_TOKEN = "------------------------------------------------------------------------";
    private int status = 1;
    private List<ChangeSet> entries = new ArrayList<ChangeSet>();
    private SvnChangeSet currentChange;
    private String currentRevision;
    private StringBuilder currentComment;
    private static final RE HEADER_REG_EXP = new RE("^(.+) \\| (.+) \\| (.+) \\|.*$");
    private static final int REVISION_GROUP = 1;
    private static final int AUTHOR_GROUP = 2;
    private static final int DATE_GROUP = 3;
    private static final RE REVISION_REG_EXP1 = new RE("rev (\\d+):");
    private static final RE REVISION_REG_EXP2 = new RE("r(\\d+)");
    private static final RE DATE_REG_EXP = new RE("(\\d+-\\d+-\\d+ \\d+:\\d+:\\d+) ([\\-+])(\\d\\d)(\\d\\d)");
    private final String userDateFormat;

    public SvnChangeLogConsumer(ScmLogger logger, String userDateFormat) {
        super(logger);
        this.userDateFormat = userDateFormat;
    }

    public List<ChangeSet> getModifications() {
        return this.entries;
    }

    @Override
    public void consumeLine(String line) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(line);
        }
        switch (this.status) {
            case 1: {
                this.processGetHeader(line);
                break;
            }
            case 2: {
                this.processGetFile(line);
                break;
            }
            case 3: {
                this.processGetComment(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + this.status);
            }
        }
    }

    private void processGetHeader(String line) {
        if (!HEADER_REG_EXP.match(line)) {
            return;
        }
        this.currentRevision = this.getRevision(HEADER_REG_EXP.getParen(1));
        this.currentChange = new SvnChangeSet();
        this.currentChange.setAuthor(HEADER_REG_EXP.getParen(2));
        this.currentChange.setDate(this.getDate(HEADER_REG_EXP.getParen(3)));
        this.currentChange.setRevision(this.currentRevision);
        this.status = 2;
    }

    private String getRevision(String revisionOutput) {
        if (REVISION_REG_EXP1.match(revisionOutput)) {
            return REVISION_REG_EXP1.getParen(1);
        }
        if (REVISION_REG_EXP2.match(revisionOutput)) {
            return REVISION_REG_EXP2.getParen(1);
        }
        throw new IllegalOutputException(revisionOutput);
    }

    private void processGetFile(String line) {
        if (FILE_PATTERN.match(line)) {
            String actionStr;
            String origFileInfo;
            String fileinfo;
            String name = fileinfo = FILE_PATTERN.getParen(2);
            String originalName = null;
            String originalRev = null;
            int n = fileinfo.indexOf(" (");
            if (n > 1 && fileinfo.endsWith(")") && ORIG_FILE_PATTERN.match(origFileInfo = fileinfo.substring(n))) {
                name = fileinfo.substring(0, n);
                originalName = ORIG_FILE_PATTERN.getParen(1);
                originalRev = ORIG_FILE_PATTERN.getParen(2);
            }
            ScmFileStatus action = "A".equals(actionStr = FILE_PATTERN.getParen(1)) ? (originalRev == null ? ScmFileStatus.ADDED : ScmFileStatus.COPIED) : ("D".equals(actionStr) ? ScmFileStatus.DELETED : ("M".equals(actionStr) ? ScmFileStatus.MODIFIED : ("R".equals(actionStr) ? ScmFileStatus.UPDATED : ScmFileStatus.UNKNOWN)));
            System.out.println(actionStr + " : " + name);
            ChangeFile changeFile = new ChangeFile(name, this.currentRevision);
            changeFile.setAction(action);
            changeFile.setOriginalName(originalName);
            changeFile.setOriginalRevision(originalRev);
            this.currentChange.addFile(changeFile);
            this.status = 2;
        } else if (line.equals(FILE_END_TOKEN)) {
            this.currentComment = new StringBuilder();
            this.status = 3;
        }
    }

    private void processGetComment(String line) {
        if (line.equals(COMMENT_END_TOKEN)) {
            this.currentChange.setComment(this.currentComment.toString());
            this.entries.add(this.currentChange);
            this.status = 1;
        } else {
            this.currentComment.append(line).append('\n');
        }
    }

    private Date getDate(String dateOutput) {
        if (!DATE_REG_EXP.match(dateOutput)) {
            throw new IllegalOutputException(dateOutput);
        }
        StringBuilder date = new StringBuilder();
        date.append(DATE_REG_EXP.getParen(1));
        date.append(" GMT");
        date.append(DATE_REG_EXP.getParen(2));
        date.append(DATE_REG_EXP.getParen(3));
        date.append(':');
        date.append(DATE_REG_EXP.getParen(4));
        return this.parseDate(date.toString(), this.userDateFormat, SVN_TIMESTAMP_PATTERN);
    }
}

