/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.command.checkout;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.synergy.command.SynergyCommand;
import org.apache.maven.scm.provider.synergy.repository.SynergyScmProviderRepository;
import org.apache.maven.scm.provider.synergy.util.SynergyUtil;
import org.codehaus.plexus.util.FileUtils;

public class SynergyCheckOutCommand
extends AbstractCheckOutCommand
implements SynergyCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version, boolean recursive) throws ScmException {
        File waPath;
        if (fileSet.getFileList().size() != 0) {
            throw new ScmException("This provider doesn't support checking out subsets of a project");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing checkout command...");
        }
        SynergyScmProviderRepository repo = (SynergyScmProviderRepository)repository;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(fileSet.toString());
        }
        String ccmAddr = SynergyUtil.start(this.getLogger(), repo.getUser(), repo.getPassword(), null);
        try {
            String projectSpec = SynergyUtil.getWorkingProject(this.getLogger(), repo.getProjectSpec(), repo.getUser(), ccmAddr);
            if (projectSpec != null) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("A working project already exists [" + projectSpec + "].");
                }
                SynergyUtil.synchronize(this.getLogger(), projectSpec, ccmAddr);
            } else {
                SynergyUtil.checkoutProject(this.getLogger(), null, repo.getProjectSpec(), version, repo.getProjectPurpose(), repo.getProjectRelease(), ccmAddr);
                projectSpec = SynergyUtil.getWorkingProject(this.getLogger(), repo.getProjectSpec(), repo.getUser(), ccmAddr);
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("A new working project [" + projectSpec + "] was created.");
                }
            }
            SynergyUtil.reconfigure(this.getLogger(), projectSpec, ccmAddr);
            waPath = SynergyUtil.getWorkArea(this.getLogger(), projectSpec, ccmAddr);
        }
        finally {
            SynergyUtil.stop(this.getLogger(), ccmAddr);
        }
        File source = new File(waPath, repo.getProjectName());
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("We will now copy files from Synergy Work Area [" + source + "] to expected folder [" + fileSet.getBasedir() + "]");
        }
        try {
            FileUtils.copyDirectoryStructure(source, fileSet.getBasedir());
        }
        catch (IOException e1) {
            throw new ScmException("Unable to copy directory structure", e1);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("We will list content of checkout directory.");
        }
        ArrayList<ScmFile> files = new ArrayList<ScmFile>();
        try {
            List realFiles = FileUtils.getFiles(fileSet.getBasedir(), null, "_ccmwaid.inf");
            for (File f : realFiles) {
                files.add(new ScmFile(f.getPath(), ScmFileStatus.CHECKED_OUT));
            }
        }
        catch (IOException e) {
            throw new ScmException("Unable to list files in checkout directory", e);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("checkout command end successfully ...");
        }
        return new CheckOutScmResult(files, new ScmResult("multiple commandline", "OK", "OK", true));
    }
}

