/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.discoveryagents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.generic.dataobjects.DetachedGenericArtifact;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.AbstractDiscoveryAgent;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.DiscoveryAgent;

public abstract class AbstractCompositDiscoveryAgent
extends AbstractDiscoveryAgent {
    private static final Log log = LogFactory.getLog(AbstractCompositDiscoveryAgent.class);
    private List<DiscoveryAgent> discoveryAgents;

    @Override
    public void init(Map properties) {
        super.init(properties);
        if (this.discoveryAgents == null) {
            this.initializeDiscoveryAgents();
        }
    }

    private void initializeDiscoveryAgents() {
        this.discoveryAgents = new ArrayList<DiscoveryAgent>();
        for (Class<DiscoveryAgent> agentClass : this.getDiscoveryAgentClasses()) {
            DiscoveryAgent agent = this.loadDiscoveryAgent(agentClass);
            this.discoveryAgents.add(agent);
        }
    }

    @Override
    public void close(Map properties) {
        super.close(properties);
    }

    @Override
    public Map<String, List<DetachedGenericArtifact>> discoverArtifacts(GenericArtifact server) {
        HashMap genericArtifact = new HashMap();
        return this.merge();
    }

    private Map<String, List<DetachedGenericArtifact>> merge() {
        return null;
    }

    abstract List<Class<DiscoveryAgent>> getDiscoveryAgentClasses();

    private DiscoveryAgent loadDiscoveryAgent(Class<DiscoveryAgent> agentClass) {
        try {
            return agentClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error((Object)("Can't Instantiate DiscoveryAgent class " + agentClass.getName()));
            return null;
        }
    }
}

