/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.indexers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrException;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifactImpl;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.indexer.XMLIndexer;
import org.wso2.carbon.registry.indexing.solr.IndexDocument;

public class RXTIndexer
extends XMLIndexer
implements Indexer {
    public static final Log log = LogFactory.getLog(RXTIndexer.class);

    public IndexDocument getIndexedDocument(AsyncIndexer.File2Index fileData) throws SolrException, RegistryException {
        IndexDocument indexedDocument = super.getIndexedDocument(fileData);
        try {
            Registry registry = GovernanceUtils.getGovernanceSystemRegistry((Registry)IndexingManager.getInstance().getRegistry(fileData.tenantId));
            GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfigurationByMediaType((String)fileData.mediaType, (Registry)registry);
            if (configuration == null) {
                return indexedDocument;
            }
            GenericArtifactManager manager = new GenericArtifactManager(registry, configuration.getKey());
            String xmlAsStr = RegistryUtils.decodeBytes((byte[])fileData.data);
            IndexableGovernanceArtifact artifact = new IndexableGovernanceArtifact((GovernanceArtifactImpl)manager.newGovernanceArtifact(AXIOMUtil.stringToOM((String)xmlAsStr)));
            Map fields = indexedDocument.getFields();
            this.setAttributesToLowerCase(fields);
            Map<String, List<String>> attributes = artifact.getAttributes();
            if (fileData.mediaType.matches("application/vnd.(.)+\\+xml") && attributes.size() > 0) {
                this.setAttributesToLowerCase(attributes);
                fields.putAll(attributes);
                CommonUtil.updateTenantsUnboundedFieldMap(configuration.getContentDefinition().getParent().toString());
                if (configuration.getArtifactNameAttribute() != null) {
                    fields.put("overview_name", attributes.get(configuration.getArtifactNameAttribute()));
                }
            } else {
                fields.put("overview_name", Arrays.asList(RegistryUtils.getResourceName((String)fileData.path).toLowerCase()));
            }
            indexedDocument.setFields(fields);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Registry RXT Indexer is running");
            }
        }
        catch (XMLStreamException e) {
            log.error((Object)"Unable to parse XML", (Throwable)e);
        }
        return indexedDocument;
    }

    private void setAttributesToLowerCase(Map<String, List<String>> attributes) {
        for (Map.Entry<String, List<String>> entry : attributes.entrySet()) {
            List<String> list = entry.getValue();
            if (list == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, list.get(i) != null ? list.get(i).toLowerCase() : list.get(i));
            }
        }
    }

    private class IndexableGovernanceArtifact
    extends GovernanceArtifactImpl {
        private IndexableGovernanceArtifact(GovernanceArtifactImpl artifact) {
            super(artifact);
        }

        public QName getQName() {
            throw new UnsupportedOperationException();
        }

        public void setQName(QName qName) throws GovernanceException {
            throw new UnsupportedOperationException();
        }

        public Map<String, List<String>> getAttributes() {
            return this.attributes;
        }
    }
}

