/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.utils;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.registry.extensions.utils.ResponseAPIM;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public final class APIUtils {
    public static void authenticateAPIM(HttpContext httpContext, String apimEndpoint, String apimUsername, String apimPassword) throws GovernanceException {
        String loginEP = apimEndpoint + "publisher/site/blocks/user/login/ajax/login.jag";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(loginEP);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
            params.add(new BasicNameValuePair("action", "login"));
            params.add(new BasicNameValuePair("username", apimUsername));
            params.add(new BasicNameValuePair("password", apimPassword));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, httpContext);
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RegistryException(" Authentication with APIM failed: HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            Gson gson = new Gson();
            ResponseAPIM responseAPIM = (ResponseAPIM)gson.fromJson(responseString, ResponseAPIM.class);
            if (responseAPIM.getError().equalsIgnoreCase("true")) {
                throw new GovernanceException("Error occurred in validating the user. Please check the credentials");
            }
        }
        catch (Exception e) {
            throw new GovernanceException("Authentication failed with API Manager. Please check the credentials", (Throwable)e);
        }
    }

    public static String authenticateAPIM_2(HttpContext httpContext, String apimEndpoint, String apimUsername, String apimPassword) throws GovernanceException {
        String loginEP = apimEndpoint + "/publisher/apis/authenticate";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(loginEP);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("username", apimUsername));
            params.add(new BasicNameValuePair("password", apimPassword));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, httpContext);
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RegistryException(" Authentication with APIM failed: HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            JSONObject obj = new JSONObject(responseString);
            return obj.getJSONObject("data").getString("sessionId");
        }
        catch (Exception e) {
            throw new GovernanceException("Authentication failed with API Manager. Please check the credentials", (Throwable)e);
        }
    }

    public static ResponseAPIM callAPIMToPublishAPI(HttpClient httpclient, HttpPost httppost, List<NameValuePair> params, HttpContext httpContext) throws GovernanceException {
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RegistryException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            Gson gson = new Gson();
            return (ResponseAPIM)gson.fromJson(responseString, ResponseAPIM.class);
        }
        catch (SocketTimeoutException e) {
            throw new GovernanceException("Connection timed out, Please check the network availability", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GovernanceException("Unsupported encode exception.", (Throwable)e);
        }
        catch (IOException e) {
            throw new GovernanceException("IO Exception occurred.", (Throwable)e);
        }
        catch (Exception e) {
            throw new GovernanceException(e.getMessage(), (Throwable)e);
        }
    }

    public static ResponseAPIM callAPIMToPublishAPI2(HttpClient httpclient, HttpPost httppost, List<NameValuePair> params, HttpContext httpContext) throws GovernanceException {
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, httpContext);
            if (response.getStatusLine().getStatusCode() != 201) {
                throw new RegistryException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return null;
        }
        catch (SocketTimeoutException e) {
            throw new GovernanceException("Connection timed out, Please check the network availability", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GovernanceException("Unsupported encode exception.", (Throwable)e);
        }
        catch (IOException e) {
            throw new GovernanceException("IO Exception occurred.", (Throwable)e);
        }
        catch (Exception e) {
            throw new GovernanceException(e.getMessage(), (Throwable)e);
        }
    }
}

