/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.Reader;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.extensions.handlers.utils.ConflictResolutionReader;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ConflictResolutionHandler
extends Handler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isRestoringLockAvailable()) {
            return;
        }
        CommonUtil.acquireRestoringLock();
        try {
            Registry registry = requestContext.getRegistry();
            Reader reader = requestContext.getDumpingReader();
            String path = requestContext.getResourcePath().getPath();
            ConflictResolutionReader conflictResolutionReader = new ConflictResolutionReader(reader, path, registry);
            registry.restore(path, (Reader)conflictResolutionReader);
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseRestoringLock();
        }
    }
}

