/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class DeleteSubscriptionHandler
extends Handler {
    private static final String TOPIC_INDEX_PATH = "/_system/governance/event/topicIndex";
    private static final String SUBSCRIPTION_PATH_PREFIX = "/_system/governance/event/topics/registry/notifications";
    private static final String NOTIFICATION_PREFIX = "/registry/notifications";
    private static final String WS_SUBSCRIPTION = "ws.subscriptions";
    private static ThreadLocal<Boolean> deleteInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RequestContext requestContext) throws RegistryException {
        if (!DeleteSubscriptionHandler.isDeleteLockAvailable()) {
            return;
        }
        DeleteSubscriptionHandler.acquireDeleteLock();
        try {
            String deletedResourcePath = requestContext.getResourcePath().getPath();
            Registry registry = requestContext.getRegistry();
            Resource resource = registry.getMetaData(deletedResourcePath);
            boolean isCollection = false;
            if (resource.getMediaType() == null) {
                isCollection = true;
            }
            if (!registry.resourceExists(TOPIC_INDEX_PATH)) {
                return;
            }
            Resource topicIndexResource = registry.get(TOPIC_INDEX_PATH);
            Properties properties = topicIndexResource.getProperties();
            ArrayList<String> propertiesToDelete = new ArrayList<String>();
            ArrayList<String> pathsToDelete = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String propertyPath;
                String absPropPath;
                if (((List)entry.getValue()).size() > 1) {
                    throw new RegistryException("Multiple properties available for same UUID.");
                }
                String pathArry = (String)((List)entry.getValue()).get(0);
                if (!pathArry.startsWith(NOTIFICATION_PREFIX) || !deletedResourcePath.equalsIgnoreCase(absPropPath = (propertyPath = pathArry.substring(NOTIFICATION_PREFIX.length())).substring(1).substring(propertyPath.substring(1).indexOf("/")))) continue;
                String key = (String)entry.getKey();
                if (!propertiesToDelete.contains(key)) {
                    propertiesToDelete.add(key);
                }
                if (!isCollection) {
                    String firstPath = propertyPath.substring(0, propertyPath.lastIndexOf("/"));
                    String lastPath = propertyPath.substring(propertyPath.lastIndexOf("/") + 1);
                    if (lastPath.lastIndexOf(".") != -1) {
                        String fileName = lastPath.substring(0, lastPath.lastIndexOf("."));
                        String extension = lastPath.substring(lastPath.lastIndexOf(".") + 1);
                        StringBuffer sb = new StringBuffer();
                        sb.append(firstPath).append("/").append(fileName).append("/").append(extension);
                        propertyPath = sb.toString();
                    }
                }
                String pathToDelete = SUBSCRIPTION_PATH_PREFIX + propertyPath.replaceAll("\\.", "/");
                StringBuffer sb = new StringBuffer();
                sb.append(pathToDelete).append("/").append(WS_SUBSCRIPTION).append("/").append(key);
                pathToDelete = sb.toString();
                if (pathsToDelete.contains(pathToDelete)) continue;
                pathsToDelete.add(pathToDelete);
            }
            for (String property : propertiesToDelete) {
                topicIndexResource.removeProperty(property);
                registry.put(TOPIC_INDEX_PATH, topicIndexResource);
            }
            for (String path : pathsToDelete) {
                if (!registry.resourceExists(path)) continue;
                registry.delete(path);
            }
        }
        finally {
            DeleteSubscriptionHandler.releaseDeleteLock();
        }
    }

    public static boolean isDeleteLockAvailable() {
        return deleteInProgress.get() == false;
    }

    public static void acquireDeleteLock() {
        deleteInProgress.set(true);
    }

    public static void releaseDeleteLock() {
        deleteInProgress.set(false);
    }
}

