/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class SLAMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(SLAMediaTypeHandler.class);
    private List<String> smartLifecycleLinks = new LinkedList<String>();

    public void setSmartLifecycleLinks(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName("key"))) continue;
            this.smartLifecycleLinks.add(confElement.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            OMElement slaInfoElement;
            Registry registry = requestContext.getRegistry();
            Resource resource = requestContext.getResource();
            if (resource == null) {
                throw new RegistryException("The resource is not available.");
            }
            String originalSLAPath = requestContext.getResourcePath().getPath();
            String resourceName = RegistryUtils.getResourceName((String)originalSLAPath);
            Object resourceContent = resource.getContent();
            String slaInfo = resourceContent instanceof String ? (String)resourceContent : RegistryUtils.decodeBytes((byte[])((byte[])resourceContent));
            try {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(slaInfo));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                slaInfoElement = builder.getDocumentElement();
            }
            catch (Exception e) {
                String msg = "Error in parsing the sla content of the sla. The requested path to store the sla: " + originalSLAPath + ".";
                log.error((Object)msg);
                throw new RegistryException(msg, (Throwable)e);
            }
            String slaName = CommonUtil.getServiceName(slaInfoElement);
            String slaPath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance/sla/" + slaName));
            String slaVersion = org.wso2.carbon.registry.common.utils.CommonUtil.getServiceVersion((OMElement)slaInfoElement);
            if (slaVersion.length() == 0) {
                slaVersion = "1.0.0";
                CommonUtil.setServiceVersion(slaInfoElement, slaVersion);
                resource.setContent((Object)slaInfoElement.toString());
            }
            String slaVersionPath = CommonUtil.computeSLAPathWithVersion(slaPath, slaVersion);
            String slaId = resource.getUUID();
            if (slaId == null) {
                slaId = UUID.randomUUID().toString();
                resource.setUUID(slaId);
            }
            if (registry.resourceExists(slaVersionPath)) {
                Resource oldResource = registry.get(slaVersionPath);
                String oldContent = RegistryUtils.decodeBytes((byte[])((byte[])oldResource.getContent()));
                Object oldSLAInfoElement = null;
                if (slaInfo.equals(oldContent)) {
                    return;
                }
            }
            boolean alreadyAdded = false;
            String workflowURL = CommonUtil.getWorkflowURL(slaInfoElement);
            if (workflowURL != null && workflowURL.startsWith("/")) {
                String workflowPath = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)workflowURL);
                boolean addItHere = false;
                if (!registry.resourceExists(workflowPath)) {
                    String msg = "Associating sla to a non-existing workflow. workflow url: " + workflowPath + ", sla path: " + slaVersionPath + ".";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                if (!registry.resourceExists(slaVersionPath)) {
                    addItHere = true;
                } else {
                    Association[] dependencies = registry.getAssociations(slaVersionPath, "depends");
                    boolean dependencyFound = false;
                    if (dependencies != null) {
                        for (Association dependency : dependencies) {
                            if (!workflowPath.equals(dependency.getDestinationPath())) continue;
                            dependencyFound = true;
                        }
                    }
                    if (!dependencyFound) {
                        addItHere = true;
                    }
                }
                if (addItHere) {
                    ((ResourceImpl)resource).prepareContentForPut();
                    this.persistSLAResource(registry, resource, slaVersionPath);
                    alreadyAdded = true;
                    registry.addAssociation(slaVersionPath, workflowPath, "depends");
                    registry.addAssociation(workflowPath, slaVersionPath, "usedBy");
                }
            }
            if (!alreadyAdded) {
                ((ResourceImpl)resource).prepareContentForPut();
                this.persistSLAResource(registry, resource, slaVersionPath);
            }
            String symlinkLocation = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)requestContext.getResource().getProperty("SymlinkPropertyName"));
            if (!slaPath.equals(originalSLAPath)) {
                Resource slaResource = requestContext.getRegistry().get(RegistryUtils.getParentPath((String)originalSLAPath));
                String isLink = slaResource.getProperty("registry.link");
                String mountPoint = slaResource.getProperty("registry.mountpoint");
                String targetPoint = slaResource.getProperty("registry.targetpoint");
                String actualPath = slaResource.getProperty("registry.actualpath");
                if (isLink != null && mountPoint != null && targetPoint != null) {
                    symlinkLocation = actualPath + "/";
                }
                if (symlinkLocation != null) {
                    registry.createLink(symlinkLocation + resourceName, slaPath);
                }
            }
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    private void persistSLAResource(Registry registry, Resource resource, String slaVersionPath) throws RegistryException {
        String patchVersionPath = RegistryUtils.getParentPath((String)slaVersionPath);
        if (!registry.resourceExists(patchVersionPath)) {
            String minorVersionPath = RegistryUtils.getParentPath((String)patchVersionPath);
            if (!registry.resourceExists(minorVersionPath)) {
                String majorVersionPath = RegistryUtils.getParentPath((String)minorVersionPath);
                if (!registry.resourceExists(majorVersionPath)) {
                    Collection collection;
                    String versionCollectionPath = RegistryUtils.getParentPath((String)majorVersionPath);
                    if (!registry.resourceExists(versionCollectionPath)) {
                        collection = registry.newCollection();
                        collection.setMediaType("application/vnd.wso2-sla-version.collection");
                        registry.put(versionCollectionPath, (Resource)collection);
                        for (String key : this.smartLifecycleLinks) {
                            Resource linkResource = registry.newResource();
                            linkResource.setMediaType("application/vnd.wso2-smart-link");
                            registry.put(versionCollectionPath + "/" + key, linkResource);
                        }
                    }
                    collection = registry.newCollection();
                    collection.setMediaType("application/vnd.wso2-sla-version.major");
                    registry.put(majorVersionPath, (Resource)collection);
                }
                Collection collection = registry.newCollection();
                collection.setMediaType("application/vnd.wso2-sla-version.minor");
                registry.put(minorVersionPath, (Resource)collection);
            }
            Collection collection = registry.newCollection();
            collection.setMediaType("application/vnd.wso2-sla-version.patch");
            registry.put(patchVersionPath, (Resource)collection);
        }
        registry.put(slaVersionPath, resource);
    }
}

