/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.RESTServiceUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.SwaggerProcessor;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class SwaggerMediaTypeHandler
extends Handler {
    private String swaggerLocation;
    private String restServiceLocation;
    private String endpointLocation;
    private boolean createService = true;

    public void setSwaggerLocationConfiguration(OMElement locationConfiguration) {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!"location".equals(confElement.getLocalName())) continue;
            this.swaggerLocation = confElement.getText();
            if (!this.swaggerLocation.startsWith("/")) {
                this.swaggerLocation = "/" + this.swaggerLocation;
            }
            if (this.swaggerLocation.endsWith("/")) continue;
            this.swaggerLocation = this.swaggerLocation + "/";
        }
    }

    public void setRestServiceLocationConfiguration(OMElement locationConfiguration) {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!"location".equals(confElement.getLocalName())) continue;
            this.restServiceLocation = confElement.getText();
            if (!this.restServiceLocation.startsWith("/")) {
                this.restServiceLocation = "/" + this.restServiceLocation;
            }
            if (this.restServiceLocation.endsWith("/")) continue;
            this.restServiceLocation = this.restServiceLocation + "/";
        }
        RESTServiceUtils.setCommonRestServiceLocation(this.restServiceLocation);
    }

    public void setEndpointLocationConfiguration(OMElement locationConfiguration) {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!"location".equals(confElement.getLocalName())) continue;
            this.endpointLocation = confElement.getText();
            if (!this.endpointLocation.startsWith("/")) {
                this.endpointLocation = "/" + this.endpointLocation;
            }
            if (this.endpointLocation.endsWith("/")) continue;
            this.endpointLocation = this.endpointLocation + "/";
        }
        RESTServiceUtils.setCommonEndpointLocation(this.endpointLocation);
    }

    public boolean isCreateService() {
        return this.createService;
    }

    public void setCreateService(String createService) {
        this.createService = Boolean.valueOf(createService);
    }

    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        InputStream inputStream = null;
        try {
            String swaggerPath;
            Resource resource = requestContext.getResource();
            if (resource == null) {
                throw new RegistryException("Resource does not exist.");
            }
            Object resourceContentObj = resource.getContent();
            if (resourceContentObj == null || !(resourceContentObj instanceof byte[])) {
                throw new RegistryException("Resource content is not valid.");
            }
            requestContext.setSourceURL(requestContext.getResource().getProperty("sourceURL"));
            String sourceURL = requestContext.getSourceURL();
            if (StringUtils.isBlank((String)sourceURL)) {
                inputStream = new ByteArrayInputStream((byte[])resourceContentObj);
                SwaggerProcessor processor = new SwaggerProcessor(requestContext, this.isCreateService());
                swaggerPath = processor.processSwagger(inputStream, this.getChrootedLocation(requestContext.getRegistryContext()), null);
            } else {
                inputStream = new URL(sourceURL).openStream();
                SwaggerProcessor processor = new SwaggerProcessor(requestContext, this.isCreateService());
                swaggerPath = processor.processSwagger(inputStream, this.getChrootedLocation(requestContext.getRegistryContext()), sourceURL);
            }
            if (swaggerPath != null) {
                requestContext.setProcessingComplete(true);
            }
        }
        catch (IOException e) {
            try {
                throw new RegistryException("The URL " + requestContext.getSourceURL() + " is incorrect.", (Throwable)e);
            }
            catch (Throwable throwable) {
                CommonUtil.closeInputStream(inputStream);
                CommonUtil.releaseUpdateLock();
                throw throwable;
            }
        }
        CommonUtil.closeInputStream(inputStream);
        CommonUtil.releaseUpdateLock();
    }

    public void importResource(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        String sourceURL = null;
        InputStream inputStream = null;
        try {
            sourceURL = requestContext.getSourceURL();
            if (sourceURL == null || sourceURL.isEmpty()) {
                throw new RegistryException("Source url is empty. Cannot read content.");
            }
            if (sourceURL.toLowerCase().startsWith("file:")) {
                throw new RegistryException("The source URL must not be point to a file in the server's local file system. ");
            }
            inputStream = new URL(sourceURL).openStream();
            SwaggerProcessor processor = new SwaggerProcessor(requestContext, this.isCreateService());
            if (processor.processSwagger(inputStream, this.getChrootedLocation(requestContext.getRegistryContext()), sourceURL) != null) {
                requestContext.setProcessingComplete(true);
            }
        }
        catch (IOException e) {
            try {
                throw new RegistryException("The URL " + sourceURL + " is incorrect.", (Throwable)e);
            }
            catch (Throwable throwable) {
                CommonUtil.closeInputStream(inputStream);
                CommonUtil.releaseUpdateLock();
                throw throwable;
            }
        }
        CommonUtil.closeInputStream(inputStream);
        CommonUtil.releaseUpdateLock();
    }

    private String getChrootedLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + this.swaggerLocation));
    }
}

