/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.WADLProcessor;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class WADLMediaTypeHandler
extends Handler {
    private String locationTag = "location";
    private OMElement schemaLocationConfiguration;
    private String schemaLocation;
    private OMElement wadlLocationConfiguration;
    private String wadlLocation;
    private boolean disableWADLValidation = false;
    private boolean createService = true;

    public OMElement getWADLLocationConfiguration() {
        return this.wadlLocationConfiguration;
    }

    public void setWadlLocationConfiguration(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName(this.locationTag))) continue;
            this.wadlLocation = confElement.getText();
            if (!this.wadlLocation.startsWith("/")) {
                this.wadlLocation = "/" + this.wadlLocation;
            }
            if (!this.wadlLocation.endsWith("/")) continue;
            this.wadlLocation = this.wadlLocation.substring(0, this.wadlLocation.length() - 1);
        }
        WADLProcessor.setCommonWADLLocation(this.wadlLocation);
        this.wadlLocationConfiguration = locationConfiguration;
    }

    public OMElement getSchemaLocationConfiguration() {
        return this.schemaLocationConfiguration;
    }

    public void setSchemaLocationConfiguration(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName(this.locationTag))) continue;
            this.schemaLocation = confElement.getText();
            if (!this.schemaLocation.startsWith("/")) {
                this.schemaLocation = "/" + this.schemaLocation;
            }
            if (this.schemaLocation.endsWith("/")) continue;
            this.schemaLocation = this.schemaLocation + "/";
        }
        WADLProcessor.setCommonSchemaLocation(this.schemaLocation);
        this.schemaLocationConfiguration = locationConfiguration;
    }

    public void setDisableWADLValidation(String disableWADLValidation) {
        this.disableWADLValidation = Boolean.getBoolean(disableWADLValidation);
    }

    public boolean isCreateService() {
        return this.createService;
    }

    public void setCreateService(String createService) {
        this.createService = Boolean.valueOf(createService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        try {
            if (!CommonUtil.isUpdateLockAvailable()) {
                return;
            }
            CommonUtil.acquireUpdateLock();
            Resource resource = requestContext.getResource();
            String resourcePath = requestContext.getResourcePath().getPath();
            requestContext.setSourceURL(requestContext.getResource().getProperty("sourceURL"));
            WADLProcessor wadlProcessor = new WADLProcessor(requestContext);
            wadlProcessor.setCreateService(this.isCreateService());
            wadlProcessor.addWadlToRegistry(requestContext, resource, resourcePath, this.disableWADLValidation);
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    public void importResource(RequestContext requestContext) throws RegistryException {
        try {
            if (!CommonUtil.isUpdateLockAvailable()) {
                return;
            }
            CommonUtil.acquireUpdateLock();
            WADLProcessor wadlProcessor = new WADLProcessor(requestContext);
            wadlProcessor.setCreateService(this.isCreateService());
            wadlProcessor.importWADLToRegistry(requestContext, this.disableWADLValidation);
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    private String getChrootedWADLLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + this.wadlLocation));
    }
}

