/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.uddi.api_v3.AuthToken;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.beans.BusinessServiceInfo;
import org.wso2.carbon.registry.extensions.handlers.WSDLMediaTypeHandler;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaProcessor;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaValidator;
import org.wso2.carbon.registry.extensions.handlers.utils.SwaggerProcessor;
import org.wso2.carbon.registry.extensions.handlers.utils.UDDIPublisher;
import org.wso2.carbon.registry.extensions.handlers.utils.WADLProcessor;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLProcessor;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;
import org.wso2.carbon.registry.uddi.utils.UDDIUtil;
import org.wso2.carbon.user.core.UserRealm;

public class ZipWSDLMediaTypeHandler
extends WSDLMediaTypeHandler {
    private String wsdlMediaType = "application/wsdl+xml";
    private String wsdlExtension = ".wsdl";
    private String xsdMediaType = "application/xsd+xml";
    private String xsdExtension = ".xsd";
    private String swaggerMediaType = "application/swagger+json";
    private String swaggerExtension = ".json";
    private String swaggerLocation = "/swagger/";
    private String wadlMediaType = "application/wadl+xml";
    private String wadlExtension = ".wadl";
    private String wadlLocation = "/wadl/";
    private OMElement wadlLocationConfiguration;
    private String archiveExtension = ".gar";
    private String tempFilePrefix = "wsdl";
    private boolean disableWSDLValidation = false;
    private boolean disableSchemaValidation = false;
    private boolean useOriginalSchema = false;
    private boolean createService = true;
    private boolean disableSymlinkCreation = true;
    private static int numberOfRetry = 5;
    private boolean disableWADLValidation = false;
    private static List<String> skipFileExtensions = new ArrayList<String>();
    private String extensionsSeparator = ",";
    private int threadPoolSize = 50;
    private static final Log log = LogFactory.getLog(ZipWSDLMediaTypeHandler.class);

    public void setNumberOfRetry(String numberOfRetry) {
        ZipWSDLMediaTypeHandler.numberOfRetry = Integer.parseInt(numberOfRetry);
    }

    @Override
    public boolean isDisableSymlinkCreation() {
        return this.disableSymlinkCreation;
    }

    @Override
    public void setDisableSymlinkCreation(String disableSymlinkCreation) {
        this.disableSymlinkCreation = Boolean.toString(true).equals(disableSymlinkCreation);
    }

    public void setThreadPoolSize(String threadPoolSize) {
        this.threadPoolSize = Integer.parseInt(threadPoolSize);
    }

    public OMElement getWADLLocationConfiguration() {
        return this.wadlLocationConfiguration;
    }

    public void setWadlLocationConfiguration(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName(this.locationTag))) continue;
            this.wadlLocation = confElement.getText();
            if (!this.wadlLocation.startsWith("/")) {
                this.wadlLocation = "/" + this.wadlLocation;
            }
            if (!this.wadlLocation.endsWith("/")) continue;
            this.wadlLocation = this.wadlLocation.substring(0, this.wadlLocation.length() - 1);
        }
        this.wadlLocationConfiguration = locationConfiguration;
    }

    public boolean isCreateService() {
        return this.createService;
    }

    @Override
    public void setCreateService(String createService) {
        this.createService = Boolean.valueOf(createService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        boolean pathMapSet = this.setSessionLocalPathMap(requestContext);
        try {
            block59: {
                Resource resource = requestContext.getResource();
                String path = requestContext.getResourcePath().getPath();
                try {
                    if (requestContext.getRegistry().resourceExists(path)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (resource == null) break block59;
                    Object resourceContent = resource.getContent();
                    ByteArrayInputStream in = new ByteArrayInputStream((byte[])resourceContent);
                    Stack<File> fileList = new Stack<File>();
                    LinkedList<String> uriList = new LinkedList<String>();
                    LinkedList<UploadTask> tasks = new LinkedList<UploadTask>();
                    int threadPoolSize = this.threadPoolSize;
                    File tempFile = File.createTempFile(this.tempFilePrefix, this.archiveExtension);
                    File tempDir = new File(tempFile.getAbsolutePath().substring(0, tempFile.getAbsolutePath().length() - this.archiveExtension.length()));
                    try {
                        int n;
                        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));){
                            int byteCount;
                            byte[] contentChunk = new byte[1024];
                            while ((byteCount = in.read(contentChunk)) != -1) {
                                out.write(contentChunk, 0, byteCount);
                            }
                            out.flush();
                        }
                        this.makeDir(tempDir);
                        LinkedList<String> wsdlUriList = new LinkedList<String>();
                        LinkedList<String> xsdUriList = new LinkedList<String>();
                        LinkedList<String> wadlUriList = new LinkedList<String>();
                        LinkedList<String> swaggerUriList = new LinkedList<String>();
                        try (ZipInputStream zs = new ZipInputStream(new FileInputStream(tempFile));){
                            ZipEntry entry = zs.getNextEntry();
                            while (entry != null) {
                                String uri;
                                String canonicalDestPath;
                                String entryName = entry.getName();
                                String destPath = tempFile.getAbsolutePath().substring(0, tempFile.getAbsolutePath().length() - this.archiveExtension.length());
                                String string = new File(destPath + File.separator + entryName).getCanonicalPath();
                                if (!string.startsWith(canonicalDestPath = new File(destPath).getCanonicalPath())) {
                                    String errorMessage = "Attempt to upload invalid zip archive with file at " + entryName + ". File path is outside target directory";
                                    log.error((Object)errorMessage);
                                    throw new RegistryException(errorMessage);
                                }
                                File file = new File(tempFile.getAbsolutePath().substring(0, tempFile.getAbsolutePath().length() - this.archiveExtension.length()) + File.separator + entryName);
                                if (entry.isDirectory()) {
                                    if (!file.exists()) {
                                        this.makeDirs(file);
                                        fileList.push(file);
                                    }
                                    entry = zs.getNextEntry();
                                    continue;
                                }
                                File parentFile = file.getParentFile();
                                if (!parentFile.exists()) {
                                    this.makeDirs(parentFile);
                                }
                                try (FileOutputStream os = new FileOutputStream(file);){
                                    int byteCount;
                                    fileList.push(file);
                                    byte[] contentChunk = new byte[1024];
                                    while ((byteCount = zs.read(contentChunk)) != -1) {
                                        os.write(contentChunk, 0, byteCount);
                                    }
                                }
                                zs.closeEntry();
                                entry = zs.getNextEntry();
                                if (entryName != null && entryName.toLowerCase().endsWith(this.wsdlExtension)) {
                                    uri = tempFile.toURI().toString();
                                    if ((uri = uri.substring(0, uri.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                        uri = uri.substring(5);
                                    }
                                    while (uri.startsWith("/")) {
                                        uri = uri.substring(1);
                                    }
                                    uri = "file:///" + uri;
                                    if (uri.endsWith("/")) {
                                        uri = uri.substring(0, uri.length() - 1);
                                    }
                                    wsdlUriList.add(uri);
                                    continue;
                                }
                                if (entryName != null && entryName.toLowerCase().endsWith(this.xsdExtension)) {
                                    uri = tempFile.toURI().toString();
                                    if ((uri = uri.substring(0, uri.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                        uri = uri.substring(5);
                                    }
                                    while (uri.startsWith("/")) {
                                        uri = uri.substring(1);
                                    }
                                    uri = "file:///" + uri;
                                    if (uri.endsWith("/")) {
                                        uri = uri.substring(0, uri.length() - 1);
                                    }
                                    xsdUriList.add(uri);
                                    continue;
                                }
                                if (entryName != null && entryName.toLowerCase().endsWith(this.wadlExtension)) {
                                    uri = tempFile.toURI().toString();
                                    if ((uri = uri.substring(0, uri.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                        uri = uri.substring(5);
                                    }
                                    while (uri.startsWith("/")) {
                                        uri = uri.substring(1);
                                    }
                                    uri = "file:///" + uri;
                                    if (uri.endsWith("/")) {
                                        uri = uri.substring(0, uri.length() - 1);
                                    }
                                    wadlUriList.add(uri);
                                    continue;
                                }
                                if (entryName != null && entryName.toLowerCase().endsWith(this.swaggerExtension)) {
                                    uri = tempFile.toURI().toString();
                                    if ((uri = uri.substring(0, uri.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                        uri = uri.substring(5);
                                    }
                                    while (uri.startsWith("/")) {
                                        uri = uri.substring(1);
                                    }
                                    uri = "file:///" + uri;
                                    if (uri.endsWith("/")) {
                                        uri = uri.substring(0, uri.length() - 1);
                                    }
                                    swaggerUriList.add(uri);
                                    continue;
                                }
                                if (entryName == null) continue;
                                boolean isSkipFileExtension = false;
                                for (String extension : skipFileExtensions) {
                                    if (!entryName.toLowerCase().endsWith(extension.toLowerCase())) continue;
                                    isSkipFileExtension = true;
                                    break;
                                }
                                if (isSkipFileExtension) continue;
                                String uri2 = tempFile.toURI().toString();
                                if ((uri2 = uri2.substring(0, uri2.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                    uri2 = uri2.substring(5);
                                }
                                while (uri2.startsWith("/")) {
                                    uri2 = uri2.substring(1);
                                }
                                uri2 = "file:///" + uri2;
                                if (uri2.endsWith("/")) {
                                    uri2 = uri2.substring(0, uri2.length() - 1);
                                }
                                uriList.add(uri2);
                            }
                        }
                        Map<String, String> localPathMap = null;
                        if (CurrentSession.getLocalPathMap() != null) {
                            localPathMap = Collections.unmodifiableMap(CurrentSession.getLocalPathMap());
                        }
                        if (wsdlUriList.isEmpty() && xsdUriList.isEmpty() && wadlUriList.isEmpty() && uriList.isEmpty() && swaggerUriList.isEmpty()) {
                            throw new RegistryException("No Files found in the given archive");
                        }
                        for (String string : wsdlUriList) {
                            tasks.add(new UploadWSDLTask(requestContext, string, CurrentSession.getTenantId(), CurrentSession.getUserRegistry(), CurrentSession.getUserRealm(), CurrentSession.getUser(), CurrentSession.getCallerTenantId(), localPathMap));
                        }
                        for (String string : xsdUriList) {
                            tasks.add(new UploadXSDTask(requestContext, string, CurrentSession.getTenantId(), CurrentSession.getUserRegistry(), CurrentSession.getUserRealm(), CurrentSession.getUser(), CurrentSession.getCallerTenantId(), localPathMap));
                        }
                        for (String string : wadlUriList) {
                            tasks.add(new UploadWadlTask(requestContext, string, CurrentSession.getTenantId(), CurrentSession.getUserRegistry(), CurrentSession.getUserRealm(), CurrentSession.getUser(), CurrentSession.getCallerTenantId(), localPathMap));
                        }
                        for (String string : swaggerUriList) {
                            tasks.add(new UploadSwaggerTask(requestContext, string, CurrentSession.getTenantId(), CurrentSession.getUserRegistry(), CurrentSession.getUserRealm(), CurrentSession.getUser(), CurrentSession.getCallerTenantId(), localPathMap));
                        }
                        String mediaType = resource.getProperty("registry.mediaType");
                        if (mediaType != null) {
                            for (String uri : uriList) {
                                tasks.add(new UploadFileTask(requestContext, uri, CurrentSession.getTenantId(), CurrentSession.getUserRegistry(), CurrentSession.getUserRealm(), CurrentSession.getUser(), CurrentSession.getCallerTenantId(), localPathMap, mediaType));
                            }
                            uriList.clear();
                        }
                        if ((n = wsdlUriList.size() + xsdUriList.size()) < threadPoolSize) {
                            threadPoolSize = n < threadPoolSize / 8 ? 0 : (n < threadPoolSize / 2 ? (threadPoolSize /= 8) : (threadPoolSize /= 4));
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                        resourceContent = null;
                        resource.setContent(null);
                    }
                    this.uploadFiles(tasks, tempFile, fileList, tempDir, threadPoolSize, path, uriList, requestContext);
                }
                catch (IOException e) {
                    throw new RegistryException("Error occurred while unpacking Governance Archive", (Throwable)e);
                }
            }
            if (Transaction.isRollbacked()) {
                throw new RegistryException("A nested transaction was rollbacked and therefore cannot proceed with this action.");
            }
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
            this.removeSessionLocalPathMap(pathMapSet);
        }
    }

    private void removeSessionLocalPathMap(boolean pathMapSet) {
        if (pathMapSet) {
            CurrentSession.removeLocalPathMap();
        }
    }

    private boolean setSessionLocalPathMap(RequestContext requestContext) {
        boolean pathMapSet = false;
        if (CurrentSession.getLocalPathMap() == null) {
            RegistryContext registryContext = requestContext.getRegistry().getRegistryContext();
            if (registryContext != null && registryContext.getMounts() != null && !registryContext.getMounts().isEmpty()) {
                HashMap localPathMap = new HashMap();
                CurrentSession.setLocalPathMap(localPathMap);
                CurrentSession.getLocalPathMap().put("archieve-upload", "true");
                pathMapSet = true;
            }
        } else {
            CurrentSession.getLocalPathMap().put("archieve-upload", "true");
        }
        return pathMapSet;
    }

    protected String addWSDLFromZip(RequestContext requestContext, String uri) throws RegistryException {
        if (uri != null) {
            AuthToken authToken;
            Resource local = requestContext.getRegistry().newResource();
            String version = requestContext.getResource().getProperty("version");
            local.setMediaType(this.wsdlMediaType);
            local.setProperty("version", version);
            local.setProperties(requestContext.getResource().getProperties());
            requestContext.setSourceURL(uri);
            requestContext.setResource(local);
            String path = requestContext.getResourcePath().getPath();
            path = path.lastIndexOf("/") != -1 ? path.substring(0, path.lastIndexOf("/")) : "";
            String wsdlName = uri;
            wsdlName = wsdlName.lastIndexOf("/") != -1 ? wsdlName.substring(wsdlName.lastIndexOf("/")) : "/" + wsdlName;
            path = path + wsdlName;
            requestContext.setResourcePath(new ResourcePath(path));
            WSDLProcessor wsdlProcessor = this.buildWSDLProcessor(requestContext, this.useOriginalSchema);
            String addedPath = wsdlProcessor.addWSDLToRegistry(requestContext, uri, local, false, true, this.disableWSDLValidation, this.disableSymlinkCreation);
            if ("enable".equals(System.getProperty("uddi")) && (authToken = UDDIUtil.getPublisherAuthToken()) != null) {
                BusinessServiceInfo businessServiceInfo = new BusinessServiceInfo();
                WSDLInfo wsdlInfo = wsdlProcessor.getMasterWSDLInfo();
                businessServiceInfo.setServiceWSDLInfo(wsdlInfo);
                UDDIPublisher publisher = new UDDIPublisher();
                publisher.publishBusinessService(authToken, businessServiceInfo);
            }
            log.debug((Object)("WSDL : " + addedPath));
            return addedPath;
        }
        return null;
    }

    protected String addWADLFromZip(RequestContext requestContext, String uri) throws RegistryException {
        if (uri != null) {
            Resource local = requestContext.getRegistry().newResource();
            String version = requestContext.getResource().getProperty("version");
            local.setMediaType(this.wadlMediaType);
            local.setProperty("version", version);
            requestContext.setSourceURL(uri);
            requestContext.setResource(local);
            String path = requestContext.getResourcePath().getPath();
            path = path.lastIndexOf("/") != -1 ? path.substring(0, path.lastIndexOf("/")) : "";
            String wadlName = uri;
            wadlName = wadlName.lastIndexOf("/") != -1 ? wadlName.substring(wadlName.lastIndexOf("/")) : "/" + wadlName;
            path = path + wadlName;
            requestContext.setResourcePath(new ResourcePath(path));
            WADLProcessor wadlProcessor = new WADLProcessor(requestContext);
            wadlProcessor.setCreateService(this.isCreateService());
            return wadlProcessor.importWADLToRegistry(requestContext, this.disableWADLValidation);
        }
        return null;
    }

    protected String addSwaggerFromZip(RequestContext requestContext, String uri) throws RegistryException {
        if (uri != null) {
            Resource local = requestContext.getRegistry().newResource();
            String version = requestContext.getResource().getProperty("version");
            local.setMediaType(this.swaggerMediaType);
            local.setProperty("version", version);
            requestContext.setSourceURL(uri);
            requestContext.setResource(local);
            String path = requestContext.getResourcePath().getPath();
            path = path.lastIndexOf("/") != -1 ? path.substring(0, path.lastIndexOf("/")) : "";
            String swaggerName = uri;
            swaggerName = swaggerName.lastIndexOf("/") != -1 ? swaggerName.substring(swaggerName.lastIndexOf("/")) : "/" + swaggerName;
            path = path + swaggerName;
            requestContext.setResourcePath(new ResourcePath(path));
            SwaggerProcessor swaggerProcessor = new SwaggerProcessor(requestContext, this.isCreateService());
            InputStream inputStream = null;
            try {
                inputStream = new URL(uri).openStream();
                String string = swaggerProcessor.processSwagger(inputStream, this.getChrootedSwaggerLocation(requestContext.getRegistryContext()), uri);
                return string;
            }
            catch (IOException e) {
                throw new RegistryException("Swagger URI is invalid", (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Error while deleting Swagger temp files");
                    }
                }
            }
        }
        return null;
    }

    protected String addSchemaFromZip(RequestContext requestContext, String uri) throws RegistryException {
        if (uri != null) {
            Resource local = requestContext.getRegistry().newResource();
            String version = requestContext.getResource().getProperty("version");
            local.setMediaType(this.xsdMediaType);
            local.setProperty("version", version);
            local.setProperties(requestContext.getResource().getProperties());
            requestContext.setSourceURL(uri);
            requestContext.setResource(local);
            String path = requestContext.getResourcePath().getPath();
            path = path.lastIndexOf("/") != -1 ? path.substring(0, path.lastIndexOf("/")) : "";
            String xsdName = uri;
            xsdName = xsdName.lastIndexOf("/") != -1 ? xsdName.substring(xsdName.lastIndexOf("/")) : "/" + xsdName;
            path = path + xsdName;
            requestContext.setResourcePath(new ResourcePath(path));
            WSDLValidationInfo validationInfo = null;
            try {
                if (!this.disableSchemaValidation) {
                    validationInfo = SchemaValidator.validate(new XMLInputSource(null, uri, null));
                }
            }
            catch (Exception e) {
                throw new RegistryException("Exception occured while validating the schema", (Throwable)e);
            }
            SchemaProcessor schemaProcessor = this.buildSchemaProcessor(requestContext, validationInfo, this.useOriginalSchema);
            String addedPath = schemaProcessor.importSchemaToRegistry(requestContext, path, this.getChrootedSchemaLocation(requestContext.getRegistryContext()), true, this.disableSymlinkCreation);
            requestContext.setActualPath(addedPath);
            log.debug((Object)("XSD : " + addedPath));
            return addedPath;
        }
        return null;
    }

    private String getChrootedSchemaLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + this.schemaLocation));
    }

    private String getChrootedWADLLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + this.wadlLocation));
    }

    private String getChrootedSwaggerLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + this.swaggerLocation));
    }

    @Override
    public void importResource(RequestContext context) {
        log.warn((Object)"The imported Governance Web Archive will not be extracted. To extract the content upload the archive from the file system.");
    }

    public void setWsdlMediaType(String wsdlMediaType) {
        this.wsdlMediaType = wsdlMediaType;
    }

    public void setWsdlExtension(String wsdlExtension) {
        this.wsdlExtension = wsdlExtension;
    }

    public void setSchemaMediaType(String xsdMediaType) {
        this.xsdMediaType = xsdMediaType;
    }

    public void setSchemaExtension(String xsdExtension) {
        this.xsdExtension = xsdExtension;
    }

    public void setArchiveExtension(String archiveExtension) {
        this.archiveExtension = archiveExtension;
    }

    public void setTempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
    }

    @Override
    public void setDisableWSDLValidation(String disableWSDLValidation) {
        this.disableWSDLValidation = Boolean.toString(true).equals(disableWSDLValidation);
    }

    public void setDisableSchemaValidation(String disableSchemaValidation) {
        this.disableSchemaValidation = Boolean.toString(true).equals(disableSchemaValidation);
    }

    public void setDisableWADLValidation(String disableWADLValidation) {
        this.disableWADLValidation = Boolean.getBoolean(disableWADLValidation);
    }

    public void setUseOriginalSchema(String useOriginalSchema) {
        this.useOriginalSchema = Boolean.toString(true).equals(useOriginalSchema);
    }

    public void setSkipFileExtensions(String skipFileExtensions) {
        if (skipFileExtensions != null) {
            String[] extensions = skipFileExtensions.split(this.extensionsSeparator);
            ZipWSDLMediaTypeHandler.skipFileExtensions = Arrays.asList(extensions);
        }
    }

    @Override
    protected void onPutCompleted(String path, Map<String, String> addedResources, List<String> otherResources, RequestContext requestContext) throws RegistryException {
        String pathMappingResourcePath;
        boolean garMappingExists;
        UserRegistry configRegistry = RegistryCoreServiceComponent.getRegistryService().getConfigSystemRegistry();
        String resourceName = RegistryUtils.getResourceName((String)requestContext.getResourcePath().getPath());
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement garElement = factory.createOMElement(new QName("gar"));
        garElement.addAttribute(factory.createOMAttribute("path", null, requestContext.getResourcePath().getPath()));
        log.info((Object)("Total Number of Files Uploaded: " + addedResources.size()));
        LinkedList<String> failures = new LinkedList<String>();
        for (Map.Entry<String, String> e : addedResources.entrySet()) {
            if (e.getValue() == null) {
                failures.add(e.getKey());
                log.info((Object)("Failure " + failures.size() + ": " + e.getKey()));
                continue;
            }
            OMElement targetElement = factory.createOMElement(new QName("target"));
            targetElement.setText(e.getValue());
            garElement.addChild((OMNode)targetElement);
        }
        String pathMappingResourceName = resourceName;
        if (resourceName.contains(".")) {
            pathMappingResourceName = resourceName.substring(0, resourceName.lastIndexOf("."));
        }
        if (garMappingExists = configRegistry.resourceExists(pathMappingResourcePath = "/repository/carbonapps/gar_mapping/" + pathMappingResourceName)) {
            Resource pathMappingResource = configRegistry.get(pathMappingResourcePath);
            try {
                OMElement garMappingElement = AXIOMUtil.stringToOM((String)new String((byte[])pathMappingResource.getContent()));
                garMappingElement.addChild((OMNode)garElement);
                pathMappingResource.setContent((Object)garMappingElement.toString());
                configRegistry.put(pathMappingResourcePath, pathMappingResource);
            }
            catch (XMLStreamException e) {
                log.warn((Object)"Error occurred while retrieving the content of GAR mapping file ", (Throwable)e);
            }
        }
        log.info((Object)("Total Number of Files Failed to Upload: " + failures.size()));
        if (otherResources.size() > 0) {
            log.info((Object)("Total Number of Files Not-Uploaded: " + otherResources.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadFiles(List<UploadTask> tasks, File tempFile, Stack<File> fileList, File tempDir, int poolSize, String path, List<String> uriList, RequestContext requestContext) throws RegistryException {
        block30: {
            block29: {
                CommonUtil.loadImportedArtifactMap();
                try {
                    if (poolSize <= 0) {
                        boolean updateLockAvailable = CommonUtil.isUpdateLockAvailable();
                        if (!updateLockAvailable) {
                            CommonUtil.releaseUpdateLock();
                        }
                        try {
                            for (UploadTask uploadTask : tasks) {
                                uploadTask.run();
                            }
                            break block29;
                        }
                        finally {
                            if (!updateLockAvailable) {
                                CommonUtil.acquireUpdateLock();
                            }
                        }
                    }
                    ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
                    if (!CommonUtil.isArtifactIndexMapExisting()) {
                        CommonUtil.createArtifactIndexMap();
                    }
                    if (!CommonUtil.isSymbolicLinkMapExisting()) {
                        CommonUtil.createSymbolicLinkMap();
                    }
                    for (UploadTask uploadTask : tasks) {
                        executorService.submit(uploadTask);
                    }
                    executorService.shutdown();
                    while (!executorService.isTerminated()) {
                    }
                }
                finally {
                    CommonUtil.clearImportedArtifactMap();
                }
            }
            try {
                if (CommonUtil.isArtifactIndexMapExisting()) {
                    Map<String, String> artifactIndexMap = CommonUtil.getAndRemoveArtifactIndexMap();
                    if (log.isDebugEnabled()) {
                        for (Map.Entry entry : artifactIndexMap.entrySet()) {
                            log.debug((Object)("Added Artifact Entry: " + (String)entry.getKey()));
                        }
                    }
                }
                Registry registry = requestContext.getRegistry();
                if (this.isDisableSymlinkCreation() || !CommonUtil.isSymbolicLinkMapExisting()) break block30;
                Map<String, String> symbolicLinkMap = CommonUtil.getAndRemoveSymbolicLinkMap();
                for (Map.Entry<String, String> entry : symbolicLinkMap.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added Symbolic Link: " + entry.getKey()));
                    }
                    try {
                        if (registry.resourceExists(entry.getKey())) {
                            registry.removeLink(entry.getKey());
                        }
                    }
                    catch (RegistryException registryException) {
                        // empty catch block
                    }
                    requestContext.getSystemRegistry().createLink(entry.getKey(), entry.getValue());
                }
            }
            catch (RegistryException e) {
                log.error((Object)"Unable to build artifact index.", (Throwable)e);
            }
        }
        LinkedHashMap<String, String> taskResults = new LinkedHashMap<String, String>();
        for (UploadTask uploadTask : tasks) {
            if (uploadTask.getFailed()) {
                taskResults.put(uploadTask.getUri(), null);
                continue;
            }
            taskResults.put(uploadTask.getUri(), uploadTask.getResult());
        }
        this.onPutCompleted(path, taskResults, uriList, requestContext);
        try {
            this.delete(tempFile);
            while (!fileList.isEmpty()) {
                this.delete(fileList.pop());
            }
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException e) {
            log.error((Object)"Unable to cleanup temporary files", (Throwable)e);
        }
        log.info((Object)"Completed uploading files from archive file");
    }

    protected class UploadSwaggerTask
    extends UploadTask {
        public UploadSwaggerTask(RequestContext requestContext, String uri, int tenantId, UserRegistry userRegistry, UserRealm userRealm, String userId, int callerTenantId, Map<String, String> localPathMap) {
            super(requestContext, uri, tenantId, userRegistry, userRealm, userId, callerTenantId, localPathMap);
        }

        @Override
        protected void doProcessing(RequestContext requestContext, String uri) throws RegistryException {
            this.result = ZipWSDLMediaTypeHandler.this.addSwaggerFromZip(requestContext, uri);
        }
    }

    protected class UploadWadlTask
    extends UploadTask {
        public UploadWadlTask(RequestContext requestContext, String uri, int tenantId, UserRegistry userRegistry, UserRealm userRealm, String userId, int callerTenantId, Map<String, String> localPathMap) {
            super(requestContext, uri, tenantId, userRegistry, userRealm, userId, callerTenantId, localPathMap);
        }

        @Override
        protected void doProcessing(RequestContext requestContext, String uri) throws RegistryException {
            this.result = ZipWSDLMediaTypeHandler.this.addWADLFromZip(requestContext, uri);
        }
    }

    protected class UploadWSDLTask
    extends UploadTask {
        public UploadWSDLTask(RequestContext requestContext, String uri, int tenantId, UserRegistry userRegistry, UserRealm userRealm, String userId, int callerTenantId, Map<String, String> localPathMap) {
            super(requestContext, uri, tenantId, userRegistry, userRealm, userId, callerTenantId, localPathMap);
        }

        @Override
        protected void doProcessing(RequestContext requestContext, String uri) throws RegistryException {
            this.result = ZipWSDLMediaTypeHandler.this.addWSDLFromZip(requestContext, uri);
        }
    }

    protected class UploadXSDTask
    extends UploadTask {
        public UploadXSDTask(RequestContext requestContext, String uri, int tenantId, UserRegistry userRegistry, UserRealm userRealm, String userId, int callerTenantId, Map<String, String> localPathMap) {
            super(requestContext, uri, tenantId, userRegistry, userRealm, userId, callerTenantId, localPathMap);
        }

        @Override
        protected void doProcessing(RequestContext requestContext, String uri) throws RegistryException {
            this.result = ZipWSDLMediaTypeHandler.this.addSchemaFromZip(requestContext, uri);
        }
    }

    protected class UploadFileTask
    extends UploadTask {
        String mediaType;

        public UploadFileTask(RequestContext requestContext, String uri, int tenantId, UserRegistry userRegistry, UserRealm userRealm, String userId, int callerTenantId, Map<String, String> localPathMap, String mediaType) {
            super(requestContext, uri, tenantId, userRegistry, userRealm, userId, callerTenantId, localPathMap);
            this.mediaType = mediaType;
        }

        @Override
        protected void doProcessing(RequestContext requestContext, String uri) throws RegistryException {
            InputStream inputStream;
            Registry registry = requestContext.getRegistry();
            Resource resource = registry.newResource();
            String version = requestContext.getResource().getProperty("version");
            if (resource.getUUID() == null) {
                resource.setUUID(UUID.randomUUID().toString());
            }
            if (version != null) {
                resource.setProperty("version", version);
            }
            resource.setMediaType(this.mediaType);
            try {
                inputStream = new URL(uri).openStream();
            }
            catch (IOException e) {
                throw new RegistryException("The URL " + uri + " is incorrect.", (Throwable)e);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int nextChar;
                while ((nextChar = inputStream.read()) != -1) {
                    outputStream.write(nextChar);
                }
                outputStream.flush();
            }
            catch (IOException e) {
                throw new RegistryException("Failed to read content from URL " + uri, (Throwable)e);
            }
            resource.setContent((Object)outputStream.toByteArray());
            String path = RegistryUtils.getParentPath((String)requestContext.getResourcePath().getPath()) + "/" + RegistryUtils.getResourceName((String)uri);
            this.result = registry.put(path, resource);
        }
    }

    protected static abstract class UploadTask
    implements Runnable {
        private String uri;
        private RequestContext requestContext;
        private int tenantId = -1;
        private UserRegistry userRegistry;
        private UserRealm userRealm;
        private String userId;
        private int callerTenantId;
        private Map<String, String> localPathMap;
        private Random random = new Random(10L);
        protected String result = null;
        protected boolean failed = false;
        protected int retries = 0;

        public UploadTask(RequestContext requestContext, String uri, int tenantId, UserRegistry userRegistry, UserRealm userRealm, String userId, int callerTenantId, Map<String, String> localPathMap) {
            this.userRegistry = userRegistry;
            this.userRealm = userRealm;
            this.tenantId = tenantId;
            this.requestContext = requestContext;
            this.uri = uri;
            this.userId = userId;
            this.callerTenantId = callerTenantId;
            this.localPathMap = localPathMap;
        }

        @Override
        public void run() {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId, true);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(this.userId);
                if (CommonUtil.isImportedArtifactExisting(new File(this.uri).toString())) {
                    this.failed = false;
                    this.result = "added from import";
                    return;
                }
                this.doWork();
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }

        protected void retry() {
            if (this.retries < numberOfRetry) {
                ++this.retries;
                log.info((Object)("Retrying to upload resource: " + this.uri));
                int i = this.random.nextInt(10);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Waiting for " + i + " seconds"));
                }
                try {
                    Thread.sleep(1000 * i);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.doWork();
            } else {
                this.failed = true;
            }
        }

        private void doWork() {
            block12: {
                CurrentSession.setTenantId((int)this.tenantId);
                CurrentSession.setUserRegistry((UserRegistry)this.userRegistry);
                CurrentSession.setUserRealm((UserRealm)this.userRealm);
                CurrentSession.setUser((String)this.userId);
                CurrentSession.setCallerTenantId((int)this.callerTenantId);
                if (this.localPathMap != null) {
                    CurrentSession.setLocalPathMap(this.localPathMap);
                }
                try {
                    if (!CommonUtil.isUpdateLockAvailable()) break block12;
                    CommonUtil.acquireUpdateLock();
                    try {
                        RequestContext requestContext = new RequestContext(this.requestContext.getRegistry(), this.requestContext.getRepository(), this.requestContext.getVersionRepository());
                        requestContext.setResourcePath(this.requestContext.getResourcePath());
                        requestContext.setResource(this.requestContext.getResource());
                        requestContext.setOldResource(this.requestContext.getOldResource());
                        this.doProcessing(requestContext, this.uri);
                    }
                    finally {
                        CommonUtil.releaseUpdateLock();
                    }
                }
                catch (RegistryException e) {
                    log.error((Object)("An error occurred while  uploading " + this.uri), (Throwable)e);
                    this.retry();
                }
                catch (RuntimeException e) {
                    log.error((Object)("An unhandled exception occurred while  uploading " + this.uri), (Throwable)e);
                    this.retry();
                }
                finally {
                    CurrentSession.removeUser();
                    CurrentSession.removeUserRealm();
                    CurrentSession.removeUserRegistry();
                    CurrentSession.removeTenantId();
                    CurrentSession.removeCallerTenantId();
                    if (this.localPathMap != null) {
                        CurrentSession.removeLocalPathMap();
                    }
                    this.requestContext = null;
                }
            }
        }

        protected abstract void doProcessing(RequestContext var1, String var2) throws RegistryException;

        public String getUri() {
            return this.uri;
        }

        public String getResult() {
            return this.result;
        }

        public boolean getFailed() {
            return this.failed;
        }
    }
}

