/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.scm;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.scm.FilesystemManager;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ExternalContentHandler
extends Handler {
    private static final Log log = LogFactory.getLog(ExternalContentHandler.class);
    private FilesystemManager filesystemManager;
    private String mountPath;
    private volatile boolean busy;

    public void setFilePath(String filePath) {
        this.filesystemManager = new FilesystemManager(filePath);
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    private void validateUpdateInProgress() throws RegistryException {
        if (this.busy) {
            throw new RegistryException("An update is currently in progress. Please try again later.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource get(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isSCMLockAvailable()) {
            return null;
        }
        CommonUtil.acquireSCMLock();
        try {
            String[] children;
            CollectionImpl collection;
            Registry registry = requestContext.getRegistry();
            Resource resource = registry.get(requestContext.getResourcePath().getPath());
            String path = RegistryUtils.getRelativePathToOriginal((String)requestContext.getResourcePath().getPath(), (String)this.mountPath);
            if (resource instanceof Collection) {
                collection = (CollectionImpl)resource;
                children = this.filesystemManager.getDirectoryContent(path);
                LinkedList<String> temp = new LinkedList<String>();
                for (String child : children) {
                    if (path.equals("/")) {
                        temp.add(this.mountPath + "/" + child);
                        continue;
                    }
                    temp.add(this.mountPath + path + "/" + child);
                }
                children = temp.toArray(new String[temp.size()]);
                if (collection.getChildCount() != children.length) {
                    if (collection.getChildCount() > 0) {
                        ArrayList<String> pathsToDelete = new ArrayList<String>(Arrays.asList(collection.getChildren()));
                        pathsToDelete.removeAll(Arrays.asList(children));
                        for (String pathToDelete : pathsToDelete) {
                            registry.delete(pathToDelete);
                            this.filesystemManager.delete(RegistryUtils.getRelativePathToOriginal((String)pathToDelete, (String)this.mountPath));
                        }
                    }
                    this.loadRegistryResources(registry, new File(this.filesystemManager.getBaseDir(), RegistryUtils.getRelativePathToOriginal((String)path, (String)this.mountPath)), this.filesystemManager.getBaseDir().getAbsolutePath(), this.mountPath);
                }
            } else {
                OnDemandResourceImpl onDemandResourceImpl = new OnDemandResourceImpl(this.filesystemManager, path, (ResourceImpl)resource);
                return onDemandResourceImpl;
            }
            collection.setChildren(children);
            requestContext.setProcessingComplete(true);
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            CommonUtil.releaseSCMLock();
        }
    }

    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isSCMLockAvailable()) {
            return;
        }
        this.validateUpdateInProgress();
        String path = RegistryUtils.getRelativePathToOriginal((String)requestContext.getResourcePath().getPath(), (String)this.mountPath);
        this.preparePut(path, requestContext);
    }

    private void preparePut(String path, RequestContext requestContext) throws RegistryException {
        Resource resource = requestContext.getResource();
        if (resource instanceof Collection) {
            this.filesystemManager.createDirectory(path);
        } else {
            Object content = resource.getContent();
            if (content instanceof String) {
                this.filesystemManager.createOrUpdateFile(path, RegistryUtils.encodeString((String)((String)content)));
            } else {
                this.filesystemManager.createOrUpdateFile(path, (byte[])content);
            }
        }
    }

    public void delete(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isSCMLockAvailable()) {
            return;
        }
        this.validateUpdateInProgress();
        String path = RegistryUtils.getRelativePathToOriginal((String)requestContext.getResourcePath().getPath(), (String)this.mountPath);
        this.filesystemManager.delete(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource(RequestContext requestContext) throws RegistryException {
        this.validateUpdateInProgress();
        try {
            URL sourceURL = new URL(requestContext.getSourceURL());
            try (InputStream inputStream = sourceURL.openStream();){
                requestContext.getResource().setContent((Object)IOUtils.toByteArray((InputStream)inputStream));
            }
        }
        catch (MalformedURLException e) {
            throw new RegistryException("Unable to connect to URL", (Throwable)e);
        }
        catch (IOException e) {
            throw new RegistryException("Unable to download URL content", (Throwable)e);
        }
        this.put(requestContext);
    }

    public String move(RequestContext requestContext) throws RegistryException {
        this.validateUpdateInProgress();
        String sourcePath = requestContext.getSourcePath();
        String targetPath = requestContext.getTargetPath();
        if (sourcePath.startsWith(this.mountPath) && targetPath.startsWith(this.mountPath)) {
            String source = RegistryUtils.getRelativePathToOriginal((String)sourcePath, (String)this.mountPath);
            this.filesystemManager.copy(source, RegistryUtils.getRelativePathToOriginal((String)targetPath, (String)this.mountPath));
            this.filesystemManager.delete(source);
        } else if (targetPath.startsWith(this.mountPath)) {
            this.preparePut(RegistryUtils.getRelativePathToOriginal((String)targetPath, (String)this.mountPath), requestContext);
        } else if (sourcePath.startsWith(this.mountPath)) {
            this.filesystemManager.delete(RegistryUtils.getRelativePathToOriginal((String)sourcePath, (String)this.mountPath));
        }
        return null;
    }

    public String copy(RequestContext requestContext) throws RegistryException {
        this.validateUpdateInProgress();
        String sourcePath = requestContext.getSourcePath();
        String targetPath = requestContext.getTargetPath();
        if (sourcePath.startsWith(this.mountPath) && targetPath.startsWith(this.mountPath)) {
            this.filesystemManager.copy(RegistryUtils.getRelativePathToOriginal((String)sourcePath, (String)this.mountPath), RegistryUtils.getRelativePathToOriginal((String)targetPath, (String)this.mountPath));
        } else if (targetPath.startsWith(this.mountPath)) {
            this.preparePut(RegistryUtils.getRelativePathToOriginal((String)targetPath, (String)this.mountPath), requestContext);
        }
        return null;
    }

    public String rename(RequestContext requestContext) throws RegistryException {
        this.validateUpdateInProgress();
        String sourcePath = requestContext.getSourcePath();
        String targetPath = requestContext.getTargetPath();
        String source = RegistryUtils.getRelativePathToOriginal((String)sourcePath, (String)this.mountPath);
        this.filesystemManager.copy(source, RegistryUtils.getRelativePathToOriginal((String)targetPath, (String)this.mountPath));
        this.filesystemManager.delete(source);
        return null;
    }

    public void restore(RequestContext requestContext) throws RegistryException {
        log.warn((Object)("Skipping restoration to path: " + requestContext.getResourcePath().getPath()));
    }

    private void loadRegistryResources(Registry registry, File directory, String workingDir, String mountPoint) throws RegistryException {
        File[] files = directory.listFiles((FileFilter)new AndFileFilter(HiddenFileFilter.VISIBLE, (IOFileFilter)new OrFileFilter(DirectoryFileFilter.INSTANCE, FileFileFilter.FILE)));
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.loadRegistryResources(registry, file, workingDir, mountPoint);
                continue;
            }
            String path = mountPoint + file.getAbsolutePath().substring(workingDir.length()).replace("\\", "/");
            if (registry.resourceExists(path)) continue;
            registry.put(path, registry.newResource());
        }
    }

    private static class OnDemandResourceImpl
    extends ResourceImpl {
        private String filePath;
        private FilesystemManager filesystemManager;

        public OnDemandResourceImpl(FilesystemManager filesystemManager, String filePath, ResourceImpl resource) {
            this.filePath = filePath;
            this.filesystemManager = filesystemManager;
            if (resource.getDescription() != null) {
                this.setDescription(resource.getDescription());
            }
            if (resource.getMediaType() != null) {
                this.setMediaType(resource.getMediaType());
            }
            if (resource.getProperties() != null) {
                this.setProperties(new Properties(resource.getProperties()));
            }
            this.setAuthorUserName(resource.getAuthorUserName());
            this.setCreatedTime(new Date(resource.getCreatedTime().getTime()));
            this.setId(resource.getId());
            this.setLastModified(new Date(resource.getLastModified().getTime()));
            this.setLastUpdaterUserName(resource.getLastUpdaterUserName());
            this.setParentPath(resource.getParentPath());
            this.setPath(resource.getPath());
            this.setMatchingSnapshotID(resource.getMatchingSnapshotID());
        }

        public Object getContent() throws RegistryException {
            try {
                if (this.content == null) {
                    this.content = this.filesystemManager.getFileContent(this.filePath);
                }
                return this.content;
            }
            catch (Exception e) {
                throw new RegistryException("Failed to get resource content", (Throwable)e);
            }
        }
    }
}

