/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.services.Utils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class EndpointUtils {
    private static final Log log = LogFactory.getLog(EndpointUtils.class);
    private static final String SOAP11_ENDPOINT_EXPR = "/wsdl:definitions/wsdl:service/wsdl:port/soap:address";
    private static final String SOAP12_ENDPOINT_EXPR = "/wsdl:definitions/wsdl:service/wsdl:port/soap12:address";
    private static final String HTTP_ENDPOINT_EXPR = "/wsdl:definitions/wsdl:service/wsdl:port/http:address";
    private static final String SERVICE_ENDPOINT_ENTRY_EXPR = "/s:metadata/s:endpoints/s:entry";
    private static final String SERVICE_ENDPOINT_EXPR = "/s:metadata/s:endpoints";
    private static final String SERVICE_ENDPOINTS_ELEMENT = "endpoints";
    private static final String SERVICE_ENDPOINTS_ENTRY_ELEMENT = "entry";
    private static final String LOCATION_ATTR = "location";
    private static final String SYNAPSE_ENDPOINT = "endpoint";
    private static final String SYNAPSE_ENDPOINT_NAME_ATTRIBUTE = "name";
    private static final String SYNAPSE_ENDPOINT_ADDRESS = "address";
    private static final String SYNAPSE_ENDPOINT_ADDRESS_URI_ATTRIBUTE = "uri";
    private static final String SYNAPSE_ENDPOINT_OVERVIEW = "overview";
    private static final String SYNAPSE_ENDPOINT_VERSION = "version";
    private static final String SYNAPSE_ENDPOINT_NAME = "name";
    private static final String ENDPOINT_RESOURCE_PREFIX = "ep-";
    private static final String ENDPOINT_NAMESPACE_ATTRIBUTE = "xmlns";
    private static final String ENDPOINT_ELEMENT_NAMESPACE = "http://www.wso2.org/governance/metadata";
    private static String endpointVersion = "1.0.0";
    private static final String ENDPOINT_DEFAULT_LOCATION = "/trunk/endpoints/";
    private static String endpointLocation = "/trunk/endpoints/";
    private static String endpointMediaType = "application/vnd.wso2-endpoint+xml";
    private static boolean includeNamespaceInName = false;
    private static String[] wsdlPrefixes = new String[]{"wsdl", "http://schemas.xmlsoap.org/wsdl/", "wsdl2", "http://www.w3.org/ns/wsdl", "xsd", "http://www.w3.org/2001/XMLSchema", "soap", "http://schemas.xmlsoap.org/wsdl/soap/", "soap12", "http://schemas.xmlsoap.org/wsdl/soap12/", "http", "http://schemas.xmlsoap.org/wsdl/http/", "s", "http://www.wso2.org/governance/metadata"};

    public static boolean isIncludeNamespaceInName() {
        return includeNamespaceInName;
    }

    public static void setIncludeNamespaceInName(boolean includeNamespaceInName) {
        EndpointUtils.includeNamespaceInName = includeNamespaceInName;
    }

    public static void setEndpointLocation(String endpointLocation) {
        EndpointUtils.endpointLocation = endpointLocation;
    }

    public static String getEndpointLocation() {
        return endpointLocation;
    }

    public static void setEndpointMediaType(String mediaType) {
        endpointMediaType = mediaType;
    }

    public static String getEndpointMediaType() {
        return endpointMediaType;
    }

    public static void removeEndpointEntry(String oldWSDL, String servicePath, OMElement serviceElement, Registry registry) throws RegistryException {
        List<OMElement> serviceEndpointEntryElements = EndpointUtils.getOmElements(serviceElement);
        if (serviceEndpointEntryElements == null || serviceEndpointEntryElements.size() == 0) {
            return;
        }
        String endpointURL = null;
        if (registry.resourceExists(oldWSDL)) {
            Association[] associations;
            for (Association association : associations = registry.getAssociations(oldWSDL, "depends")) {
                byte[] sourceContent;
                Resource targetResource;
                String targetPath = association.getDestinationPath();
                if (!registry.resourceExists(targetPath) || !"application/vnd.wso2-endpoint+xml".equals((targetResource = registry.get(targetPath)).getMediaType()) || (sourceContent = (byte[])targetResource.getContent()) == null) continue;
                endpointURL = EndpointUtils.deriveEndpointFromContent(RegistryUtils.decodeBytes((byte[])sourceContent));
            }
        }
        for (OMElement endpointOmElement : serviceEndpointEntryElements) {
            if (endpointOmElement == null) continue;
            String entryText = endpointOmElement.getText();
            if (endpointURL == null || !entryText.contains(endpointURL)) continue;
            endpointOmElement.detach();
        }
    }

    private static List<OMElement> getOmElements(OMElement serviceElement) throws RegistryException {
        List<OMElement> serviceEndpointEntryElements;
        try {
            serviceEndpointEntryElements = EndpointUtils.evaluateXPathToElements(SERVICE_ENDPOINT_ENTRY_EXPR, serviceElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return serviceEndpointEntryElements;
    }

    public static void removeEndpointEntry(RequestContext requestContext, OMElement serviceElement, String servicePath, Registry registry) throws RegistryException {
        String serviceVersion;
        Association[] associations;
        for (Association association : associations = registry.getAssociations(servicePath, "depends")) {
            Resource targetResource;
            String targetPath = association.getDestinationPath();
            if (!registry.resourceExists(targetPath) || !"application/vnd.wso2-endpoint+xml".equals((targetResource = registry.get(targetPath)).getMediaType())) continue;
            registry.removeAssociation(servicePath, targetResource.getPath(), "depends");
            registry.removeAssociation(targetResource.getPath(), servicePath, "usedBy");
        }
        List<OMElement> serviceEndpointEntryElements = EndpointUtils.getOmElements(serviceElement);
        endpointVersion = serviceVersion = CommonUtil.getServiceVersion(serviceElement);
        for (OMElement endpointElement : serviceEndpointEntryElements) {
            HashMap<String, String> properties = new HashMap<String, String>();
            String entryText = endpointElement.getText();
            String entryKey = null;
            int colonIndex = entryText.indexOf(":");
            if (colonIndex < entryText.length() - 1) {
                entryKey = entryText.substring(0, colonIndex);
                entryText = entryText.substring(colonIndex + 1);
            }
            String entryVal = entryText;
            if (!"".equals(entryKey)) {
                String endpointPath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + endpointLocation)) + EndpointUtils.deriveEndpointFromUrl(entryVal);
                String existingEnv = null;
                if (registry.resourceExists(endpointPath)) {
                    registry.get(endpointPath).removeProperty("environment");
                }
                existingEnv = entryKey;
                properties.put("environment", existingEnv);
            }
            EndpointUtils.saveEndpoint(requestContext, registry, entryVal, servicePath, properties, CommonUtil.getUnchrootedSystemRegistry(requestContext));
        }
    }

    public static void saveEndpointsFromWSDL(RequestContext context, String wsdlPath, Resource wsdlResource, Registry registry, Registry systemRegistry) throws RegistryException {
        List<OMElement> httpElements;
        List<OMElement> soap12Elements;
        List<OMElement> soap11Elements;
        OMElement wsdlElement;
        byte[] wsdlContentBytes = (byte[])wsdlResource.getContent();
        if (wsdlContentBytes == null) {
            return;
        }
        try {
            wsdlElement = EndpointUtils.buildOMElement(RegistryUtils.decodeBytes((byte[])wsdlContentBytes));
        }
        catch (Exception e) {
            String msg = "Error in building the wsdl element for path: " + wsdlPath + ".";
            throw new RegistryException(msg, (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)wsdlResource.getProperty(SYNAPSE_ENDPOINT_VERSION))) {
            endpointVersion = wsdlResource.getProperty(SYNAPSE_ENDPOINT_VERSION);
        }
        try {
            soap11Elements = EndpointUtils.evaluateXPathToElements(SOAP11_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement soap11Element : soap11Elements) {
            String locationUrl = soap11Element.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("soap11", "true");
            properties.put("resource.source", "Auto");
            EndpointUtils.saveEndpoint(context, registry, locationUrl, wsdlPath, properties, systemRegistry);
        }
        try {
            soap12Elements = EndpointUtils.evaluateXPathToElements(SOAP12_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement soap12Element : soap12Elements) {
            String locationUrl = soap12Element.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("soap12", "true");
            properties.put("resource.source", "Auto");
            EndpointUtils.saveEndpoint(context, registry, locationUrl, wsdlPath, properties, systemRegistry);
        }
        try {
            httpElements = EndpointUtils.evaluateXPathToElements(HTTP_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement httpElement : httpElements) {
            String locationUrl = httpElement.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("http", "true");
            properties.put("resource.source", "Auto");
            EndpointUtils.saveEndpoint(context, registry, locationUrl, wsdlPath, properties, systemRegistry);
        }
    }

    public static void saveEndpointsFromWSDL(RequestContext context, String wsdlPath, Resource wsdlResource, Registry registry, Registry systemRegistry, String environment, List<String> dependencies, String version) throws RegistryException {
        List<OMElement> httpElements;
        List<OMElement> soap12Elements;
        List<OMElement> soap11Elements;
        OMElement wsdlElement;
        byte[] wsdlContentBytes = (byte[])wsdlResource.getContent();
        if (wsdlContentBytes == null) {
            return;
        }
        try {
            wsdlElement = EndpointUtils.buildOMElement(RegistryUtils.decodeBytes((byte[])wsdlContentBytes));
        }
        catch (Exception e) {
            String msg = "Error in building the wsdl element for path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        try {
            soap11Elements = EndpointUtils.evaluateXPathToElements(SOAP11_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement soap11Element : soap11Elements) {
            String locationUrl = soap11Element.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("soap11", "true");
            properties.put("resource.source", "Auto");
            EndpointUtils.saveEndpoint(context, registry, locationUrl, wsdlPath, properties, systemRegistry, environment, dependencies, version);
        }
        try {
            soap12Elements = EndpointUtils.evaluateXPathToElements(SOAP12_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement soap12Element : soap12Elements) {
            String locationUrl = soap12Element.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("soap12", "true");
            properties.put("resource.source", "Auto");
            EndpointUtils.saveEndpoint(context, registry, locationUrl, wsdlPath, properties, systemRegistry, environment, dependencies, version);
        }
        try {
            httpElements = EndpointUtils.evaluateXPathToElements(HTTP_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement httpElement : httpElements) {
            String locationUrl = httpElement.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("http", "true");
            properties.put("resource.source", "Auto");
            EndpointUtils.saveEndpoint(context, registry, locationUrl, wsdlPath, properties, systemRegistry, environment, dependencies, version);
        }
    }

    public static void saveEndpointsFromServices(RequestContext context, String servicePath, OMElement serviceElement, Registry registry, Registry systemRegistry) throws RegistryException {
        String serviceVersion;
        List<OMElement> serviceEndpointEntryElements = EndpointUtils.getOmElements(serviceElement);
        endpointVersion = serviceVersion = CommonUtil.getServiceVersion(serviceElement);
        EndpointUtils.removeEndpointDependencies(servicePath, registry);
        for (OMElement endpointElement : serviceEndpointEntryElements) {
            HashMap<String, String> properties = new HashMap<String, String>();
            String entryText = endpointElement.getText();
            String entryKey = null;
            int colonIndex = entryText.indexOf(":");
            if (colonIndex < entryText.length() - 1) {
                entryKey = entryText.substring(0, colonIndex);
                entryText = entryText.substring(colonIndex + 1);
            }
            String entryVal = entryText;
            if (!"".equals(entryKey)) {
                String endpointPath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + endpointLocation)) + EndpointUtils.deriveEndpointFromUrl(entryVal);
                String existingEnv = null;
                if (registry.resourceExists(endpointPath)) {
                    registry.get(endpointPath).removeProperty("environment");
                }
                existingEnv = entryKey;
                properties.put("environment", existingEnv);
            }
            EndpointUtils.saveEndpoint(context, registry, entryVal, servicePath, properties, systemRegistry);
        }
        EndpointUtils.addAssociations(servicePath, registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveEndpointsFromServices(RequestContext context, String servicePath, OMElement serviceElement, Registry registry, Registry systemRegistry, String environment) throws RegistryException {
        if (!CommonUtil.isAddingAssociationLockAvailable()) {
            return;
        }
        CommonUtil.acquireAddingAssociationLock();
        try {
            List<OMElement> serviceEndpointEntryElements = EndpointUtils.getOmElements(serviceElement);
            EndpointUtils.removeEndpointDependencies(servicePath, registry);
            for (OMElement endpointElement : serviceEndpointEntryElements) {
                HashMap<String, String> properties = new HashMap<String, String>();
                String entryText = endpointElement.getText();
                String entryKey = null;
                int colonIndex = entryText.indexOf(":");
                if (colonIndex < entryText.length() - 1) {
                    entryKey = entryText.substring(0, colonIndex);
                    entryText = entryText.substring(colonIndex + 1);
                }
                String entryVal = entryText;
                if (!"".equals(entryKey)) {
                    String endpointPath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + environment)) + EndpointUtils.deriveEndpointFromUrl(entryVal);
                    String existingEnv = null;
                    if (registry.resourceExists(endpointPath)) {
                        registry.get(endpointPath).removeProperty("environment");
                    }
                    existingEnv = entryKey;
                    properties.put("environment", existingEnv);
                }
                EndpointUtils.saveEndpoint(context, registry, entryVal, servicePath, properties, systemRegistry, environment);
            }
        }
        finally {
            CommonUtil.releaseAddingAssociationLock();
        }
        EndpointUtils.addAssociations(servicePath, registry);
    }

    private static void addAssociations(String servicePath, Registry registry) throws RegistryException {
        Association[] associations;
        for (Association association : associations = registry.getAssociations(servicePath, "depends")) {
            Association[] wsdlAssociations;
            Resource targetResource;
            String targetPath = association.getDestinationPath();
            if (!registry.resourceExists(targetPath) || !"application/wsdl+xml".equals((targetResource = registry.get(targetPath)).getMediaType())) continue;
            for (Association wsdlAssociation : wsdlAssociations = registry.getAssociations(targetPath, "depends")) {
                Resource wsdlTargetResource;
                String wsdlTargetPath = wsdlAssociation.getDestinationPath();
                if (!registry.resourceExists(wsdlTargetPath) || !"application/vnd.wso2-endpoint+xml".equals((wsdlTargetResource = registry.get(wsdlTargetPath)).getMediaType())) continue;
                registry.addAssociation(servicePath, wsdlTargetPath, "depends");
                registry.addAssociation(wsdlTargetPath, servicePath, "usedBy");
            }
        }
    }

    private static void removeEndpointDependencies(String servicePath, Registry registry) throws RegistryException {
        Association[] associations;
        for (Association association : associations = registry.getAllAssociations(servicePath)) {
            Resource endpointResource;
            String path = association.getDestinationPath();
            if (!registry.resourceExists(path) || !"application/vnd.wso2-endpoint+xml".equals((endpointResource = registry.get(path)).getMediaType())) continue;
            registry.removeAssociation(servicePath, path, "depends");
            registry.removeAssociation(path, servicePath, "usedBy");
        }
    }

    private static List<OMElement> evaluateXPathToElements(String expression, OMElement root) throws Exception {
        String[] nsPrefixes = wsdlPrefixes;
        AXIOMXPath xpathExpression = new AXIOMXPath(expression);
        for (int j = 0; j < nsPrefixes.length; ++j) {
            xpathExpression.addNamespace(nsPrefixes[j++], nsPrefixes[j]);
        }
        return xpathExpression.selectNodes((Object)root);
    }

    private static OMElement buildOMElement(String content) throws Exception {
        XMLStreamReader parser;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(content));
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser to build the OMElement.";
            throw new Exception(msg, e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    private static void saveEndpoint(RequestContext context, Registry registry, String url, String associatedPath, Map<String, String> properties, Registry systemRegistry, String environment) throws RegistryException {
        String pathExpression = EndpointUtils.getEndpointLocation(context, url, systemRegistry, environment);
        String urlToPath = EndpointUtils.deriveEndpointFromUrl(url);
        String endpointAbsoluteBasePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + environment));
        if (!systemRegistry.resourceExists(endpointAbsoluteBasePath)) {
            systemRegistry.put(endpointAbsoluteBasePath, (Resource)systemRegistry.newCollection());
        }
        String relativePath = environment + urlToPath;
        String endpointAbsolutePath = pathExpression;
        EndpointUtils.saveEndpointValues(context, registry, url, associatedPath, properties, systemRegistry, relativePath, endpointAbsolutePath);
    }

    private static void saveEndpoint(RequestContext context, Registry registry, String url, String associatedPath, Map<String, String> properties, Registry systemRegistry, String environment, List<String> dependencies, String version) throws RegistryException {
        String urlToPath = EndpointUtils.deriveEndpointFromUrl(url);
        String pathExpression = EndpointUtils.getEndpointLocation(context, url, systemRegistry, environment);
        String endpointAbsoluteBasePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)environment);
        if (!systemRegistry.resourceExists(endpointAbsoluteBasePath)) {
            systemRegistry.put(endpointAbsoluteBasePath, (Resource)systemRegistry.newCollection());
        }
        String prefix = urlToPath.substring(0, urlToPath.lastIndexOf("/") + 1);
        String name = urlToPath.replace(prefix, "");
        String regex = endpointAbsoluteBasePath + prefix + "[\\d].[\\d].[\\d]" + "/" + name;
        for (String dependency : dependencies) {
            if (!dependency.matches(regex)) continue;
            String newRelativePath = RegistryUtils.getRelativePathToOriginal((String)dependency, (String)"/_system/governance");
            EndpointUtils.saveEndpointValues(context, registry, url, associatedPath, properties, systemRegistry, newRelativePath, dependency);
            return;
        }
        String endpointAbsolutePath = environment + prefix + version + "/" + name;
        String relativePath = environment.substring(0, "/_system/governance".length()) + prefix + version + "/" + name;
        EndpointUtils.saveEndpointValues(context, registry, url, associatedPath, properties, systemRegistry, relativePath, endpointAbsolutePath);
    }

    private static void saveEndpoint(RequestContext context, Registry registry, String url, String associatedPath, Map<String, String> properties, Registry systemRegistry) throws RegistryException {
        String urlToPath = EndpointUtils.deriveEndpointFromUrl(url);
        String pathExpression = EndpointUtils.getEndpointLocation(context, url, systemRegistry, endpointLocation);
        String endpointAbsoluteBasePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + endpointLocation));
        if (!systemRegistry.resourceExists(endpointAbsoluteBasePath)) {
            systemRegistry.put(endpointAbsoluteBasePath, (Resource)systemRegistry.newCollection());
        }
        if (endpointLocation.endsWith("/")) {
            if (urlToPath.startsWith("/")) {
                urlToPath = urlToPath.replaceFirst("/", "");
            }
        } else if (!urlToPath.startsWith("/")) {
            urlToPath = "/" + urlToPath;
        }
        String relativePath = endpointLocation + urlToPath;
        String endpointAbsolutePath = pathExpression;
        EndpointUtils.saveEndpointValues(context, registry, url, associatedPath, properties, systemRegistry, relativePath, endpointAbsolutePath);
    }

    private static String getEndpointLocation(RequestContext context, String url, Registry systemRegistry, String environment) throws RegistryException {
        if (Utils.getRxtService() != null) {
            String pathExpression = Utils.getRxtService().getStoragePath("application/vnd.wso2-endpoint+xml");
            pathExpression = CommonUtil.replaceExpressionOfPath(pathExpression, "name", EndpointUtils.deriveEndpointNameWithNamespaceFromUrl(url));
            pathExpression = CommonUtil.replaceExpressionOfPath(pathExpression, SYNAPSE_ENDPOINT_VERSION, endpointVersion);
            pathExpression = CommonUtil.getPathFromPathExpression(pathExpression, context.getResource().getProperties(), null);
            String namespace = EndpointUtils.deriveEndpointNamespaceFromUrl(url).replace("//", "/");
            pathExpression = CommonUtil.replaceExpressionOfPath(pathExpression, "namespace", namespace);
            pathExpression = pathExpression.replace("//", "/");
            String endPointPath = pathExpression = RegistryUtils.getAbsolutePath((RegistryContext)context.getRegistryContext(), (String)pathExpression.replace("//", "/"));
            if (CurrentSession.getLocalPathMap() != null && !Boolean.valueOf((String)CurrentSession.getLocalPathMap().get("archieve-upload")).booleanValue()) {
                endPointPath = CommonUtil.getRegistryPath(context.getRegistry().getRegistryContext(), pathExpression);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saving current session local paths, key: " + endPointPath + " | value: " + pathExpression));
                }
                CurrentSession.getLocalPathMap().put(endPointPath, pathExpression);
            }
            return endPointPath;
        }
        String urlToPath = EndpointUtils.deriveEndpointFromUrl(url);
        String endpointAbsoluteBasePath = RegistryUtils.getAbsolutePath((RegistryContext)context.getRegistryContext(), (String)("/_system/governance" + environment));
        if (!systemRegistry.resourceExists(endpointAbsoluteBasePath)) {
            systemRegistry.put(endpointAbsoluteBasePath, (Resource)systemRegistry.newCollection());
        }
        String endpointAbsolutePath = endpointAbsoluteBasePath + urlToPath;
        return endpointAbsolutePath;
    }

    private static String updateEndpointContent(RequestContext context, String content) {
        try {
            OMElement serviceElement = EndpointUtils.buildOMElement(content);
            String pathExpression = Utils.getRxtService().getStoragePath("application/vnd.wso2-endpoint+xml");
            CommonUtil.getPathFromPathExpression(pathExpression, context.getResource().getProperties(), serviceElement);
            return serviceElement.toString();
        }
        catch (Exception exception) {
            return content;
        }
    }

    private static void saveEndpointValues(RequestContext context, Registry registry, String url, String associatedPath, Map<String, String> properties, Registry systemRegistry, String relativePath, String endpointAbsolutePath) throws RegistryException {
        Resource resource;
        String endpointId = null;
        if (registry.resourceExists(endpointAbsolutePath)) {
            resource = registry.get(endpointAbsolutePath);
            endpointId = resource.getUUID();
            String newContent = EndpointUtils.updateEndpointContent(context, EndpointUtils.getEndpointContentWithOverview(url, endpointAbsolutePath, ((ResourceImpl)resource).getName(), endpointVersion));
            if (resource.getContent() != null) {
                String existingContent = new String((byte[])resource.getContent());
                if (!existingContent.equals(newContent)) {
                    resource.setContent((Object)RegistryUtils.encodeString((String)newContent));
                }
            } else {
                resource.setContent((Object)RegistryUtils.encodeString((String)newContent));
            }
        } else {
            resource = registry.newResource();
            resource.setContent((Object)RegistryUtils.encodeString((String)EndpointUtils.updateEndpointContent(context, EndpointUtils.getEndpointContentWithOverview(url, endpointAbsolutePath, EndpointUtils.deriveEndpointNameWithNamespaceFromUrl(url), endpointVersion))));
        }
        boolean endpointIdCreated = false;
        if (endpointId == null) {
            endpointIdCreated = true;
            endpointId = UUID.randomUUID().toString();
            resource.setUUID(endpointId);
        }
        boolean propertiesChanged = false;
        if (properties != null) {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                propertiesChanged = true;
                resource.setProperty(e.getKey(), e.getValue());
            }
        }
        if (endpointIdCreated || propertiesChanged) {
            resource.setMediaType(endpointMediaType);
            registry.put(endpointAbsolutePath, resource);
        }
        String defaultLifeCycle = CommonUtil.getDefaultLifecycle(registry, SYNAPSE_ENDPOINT);
        CommonUtil.applyDefaultLifeCycle(registry, resource, endpointAbsolutePath, defaultLifeCycle);
        registry.addAssociation(associatedPath, endpointAbsolutePath, "depends");
        registry.addAssociation(endpointAbsolutePath, associatedPath, "usedBy");
    }

    public static void addEndpointToService(Registry registry, String servicePath, String endpointUrl, String endpointEnv) throws RegistryException {
        OMElement serviceEndpointElement;
        OMElement serviceElement;
        Resource serviceResource = registry.get(servicePath);
        byte[] serviceBytes = (byte[])serviceResource.getContent();
        String serviceContent = RegistryUtils.decodeBytes((byte[])serviceBytes);
        try {
            serviceElement = EndpointUtils.buildOMElement(serviceContent);
        }
        catch (Exception e) {
            String msg = "Failed building the service element. " + servicePath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        OMNamespace namespace = OMAbstractFactory.getOMFactory().createOMNamespace(ENDPOINT_ELEMENT_NAMESPACE, null);
        try {
            List<OMElement> endpointElements = EndpointUtils.evaluateXPathToElements(SERVICE_ENDPOINT_EXPR, serviceElement);
            if (endpointElements.size() == 0) {
                serviceEndpointElement = OMAbstractFactory.getOMFactory().createOMElement(SERVICE_ENDPOINTS_ELEMENT, namespace);
                serviceElement.addChild((OMNode)serviceEndpointElement);
            } else {
                serviceEndpointElement = endpointElements.get(0);
            }
        }
        catch (Exception e) {
            String msg = "Error in getting the endpoint element of the service. service path: " + servicePath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        Iterator it = serviceEndpointElement.getChildElements();
        ArrayList<String> currentEndpoints = new ArrayList<String>();
        while (it.hasNext()) {
            currentEndpoints.add(((OMElement)it.next()).getText());
        }
        if (!currentEndpoints.contains(endpointEnv + ":" + endpointUrl)) {
            OMElement entryElement = OMAbstractFactory.getOMFactory().createOMElement(SERVICE_ENDPOINTS_ENTRY_ELEMENT, namespace);
            entryElement.setText(endpointEnv + ":" + endpointUrl);
            serviceEndpointElement.addChild((OMNode)entryElement);
            String serviceElementStr = serviceElement.toString();
            serviceResource.setContent((Object)RegistryUtils.encodeString((String)serviceElementStr));
            registry.put(servicePath, serviceResource);
        }
    }

    public static OMElement addEndpointToService(OMElement serviceElement, String endpointUrl, String endpointEnv) throws RegistryException {
        OMElement serviceEndpointElement;
        OMNamespace namespace = OMAbstractFactory.getOMFactory().createOMNamespace(ENDPOINT_ELEMENT_NAMESPACE, null);
        try {
            List<OMElement> endpointElements = EndpointUtils.evaluateXPathToElements(SERVICE_ENDPOINT_EXPR, serviceElement);
            if (endpointElements.size() == 0) {
                serviceEndpointElement = OMAbstractFactory.getOMFactory().createOMElement(SERVICE_ENDPOINTS_ELEMENT, namespace);
                serviceElement.addChild((OMNode)serviceEndpointElement);
            } else {
                serviceEndpointElement = endpointElements.get(0);
            }
        }
        catch (Exception e) {
            String msg = "Error in getting the endpoint element of the service.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        Iterator it = serviceEndpointElement.getChildElements();
        ArrayList<String> currentEndpoints = new ArrayList<String>();
        while (it.hasNext()) {
            currentEndpoints.add(((OMElement)it.next()).getText());
        }
        if (!currentEndpoints.contains(endpointEnv + ":" + endpointUrl)) {
            OMElement entryElement = OMAbstractFactory.getOMFactory().createOMElement(SERVICE_ENDPOINTS_ENTRY_ELEMENT, namespace);
            entryElement.setText(endpointEnv + ":" + endpointUrl);
            serviceEndpointElement.addChild((OMNode)entryElement);
            return serviceElement;
        }
        return serviceElement;
    }

    public static void removeEndpointFromService(Registry registry, String servicePath, String endpointUrl, String endpointEnv) throws RegistryException {
        OMElement serviceEndpointElement;
        OMElement serviceElement;
        Resource serviceResource = registry.get(servicePath);
        byte[] serviceBytes = (byte[])serviceResource.getContent();
        String serviceContent = RegistryUtils.decodeBytes((byte[])serviceBytes);
        try {
            serviceElement = EndpointUtils.buildOMElement(serviceContent);
        }
        catch (Exception e) {
            String msg = "Failed building the service element. " + servicePath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        OMNamespace namespace = OMAbstractFactory.getOMFactory().createOMNamespace(ENDPOINT_ELEMENT_NAMESPACE, null);
        try {
            List<OMElement> endpointElements = EndpointUtils.evaluateXPathToElements(SERVICE_ENDPOINT_EXPR, serviceElement);
            if (endpointElements.size() == 0) {
                serviceEndpointElement = OMAbstractFactory.getOMFactory().createOMElement(SERVICE_ENDPOINTS_ELEMENT, namespace);
                serviceElement.addChild((OMNode)serviceEndpointElement);
            } else {
                serviceEndpointElement = endpointElements.get(0);
            }
        }
        catch (Exception e) {
            String msg = "Error in getting the endpoint element of the service. service path: " + servicePath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        Iterator it = serviceEndpointElement.getChildElements();
        while (it.hasNext()) {
            OMElement next = (OMElement)it.next();
            if (!next.getText().equals(endpointEnv + ":" + endpointUrl)) continue;
            next.detach();
            String serviceElementStr = serviceElement.toString();
            serviceResource.setContent((Object)RegistryUtils.encodeString((String)serviceElementStr));
            registry.put(servicePath, serviceResource);
            break;
        }
    }

    public static String deriveEndpointFromUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            throw new IllegalArgumentException("Invalid arguments supplied for derive endpoint name from url.");
        }
        String[] temp = url.split("[?]")[0].split("/");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < temp.length - 1; ++i) {
            sb.append(temp[i]).append("/");
        }
        String urlToPath = CommonUtil.derivePathFragmentFromNamespace(sb.toString());
        if (urlToPath.length() > 1) {
            urlToPath = urlToPath.substring(1, urlToPath.length() - 1);
        }
        urlToPath = urlToPath + "/" + EndpointUtils.deriveEndpointNameFromUrl(url);
        return urlToPath;
    }

    public static String deriveEndpointNamespaceFromUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            throw new IllegalArgumentException("Invalid arguments supplied for derive endpoint name from url.");
        }
        String[] temp = url.split("[?]")[0].split("/");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < temp.length - 1; ++i) {
            sb.append(temp[i]).append("/");
        }
        String urlToPath = CommonUtil.derivePathFragmentFromNamespace(sb.toString());
        if (urlToPath.length() > 1) {
            urlToPath = urlToPath.substring(1, urlToPath.length() - 1);
        }
        return urlToPath;
    }

    public static String deriveEndpointNameFromUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            throw new IllegalArgumentException("Invalid arguments supplied for derive endpoint name from url.");
        }
        String tempURL = url;
        if (tempURL.startsWith("jms:/")) {
            tempURL = tempURL.split("[?]")[0];
        }
        String name = tempURL.split("/")[tempURL.split("/").length - 1].replace(".", "-").replace("=", "-").replace("@", "-").replace("#", "-").replace("~", "-");
        return ENDPOINT_RESOURCE_PREFIX + name;
    }

    public static String deriveEndpointNameWithNamespaceFromUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            throw new IllegalArgumentException("Invalid arguments supplied for derive endpoint name from url.");
        }
        String tempURL = url;
        if (tempURL.startsWith("jms:/")) {
            tempURL = tempURL.split("[?]")[0];
        }
        String name = tempURL.split("/")[tempURL.split("/").length - 1].replace(".", "-").replace("=", "-").replace("@", "-").replace("#", "-").replace("~", "-");
        String namespace = EndpointUtils.deriveEndpointNamespaceFromUrl(url).replace("//", "/");
        namespace = namespace.replace("/", ".");
        namespace = namespace + "-";
        if (EndpointUtils.isIncludeNamespaceInName()) {
            return ENDPOINT_RESOURCE_PREFIX + namespace + name;
        }
        return ENDPOINT_RESOURCE_PREFIX + name;
    }

    @Deprecated
    public static String getEndpointContent(String endpoint, String path) throws RegistryException {
        if (StringUtils.isBlank((String)endpoint) || StringUtils.isBlank((String)path)) {
            throw new IllegalArgumentException("Invalid arguments supplied for derive endpoint name from url.");
        }
        path = EndpointUtils.setFullPath(path);
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = factory.createOMElement(new QName(ENDPOINT_ELEMENT_NAMESPACE, SYNAPSE_ENDPOINT, null));
        endpointElement.addAttribute("name", path, null);
        OMElement address = factory.createOMElement(new QName(SYNAPSE_ENDPOINT_ADDRESS));
        address.addAttribute(SYNAPSE_ENDPOINT_ADDRESS_URI_ATTRIBUTE, endpoint, null);
        endpointElement.addChild((OMNode)address);
        return endpointElement.toString();
    }

    public static String getEndpointContentWithOverview(String endpoint, String path, String name, String version) throws RegistryException {
        if (EndpointUtils.isArgumentsNull(endpoint, path, name, version)) {
            throw new IllegalArgumentException("Invalid arguments supplied for content creation.");
        }
        path = EndpointUtils.setFullPath(path);
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = factory.createOMElement(new QName(SYNAPSE_ENDPOINT));
        endpointElement.addAttribute(ENDPOINT_NAMESPACE_ATTRIBUTE, ENDPOINT_ELEMENT_NAMESPACE, null);
        OMElement endpointElementOverview = factory.createOMElement(new QName(SYNAPSE_ENDPOINT_OVERVIEW));
        OMElement overviewName = factory.createOMElement(new QName("name"));
        overviewName.setText(name);
        OMElement overviewVersion = factory.createOMElement(new QName(SYNAPSE_ENDPOINT_VERSION));
        overviewVersion.setText(version);
        OMElement overviewAddress = factory.createOMElement(new QName(SYNAPSE_ENDPOINT_ADDRESS));
        overviewAddress.setText(endpoint);
        endpointElementOverview.addChild((OMNode)overviewName);
        endpointElementOverview.addChild((OMNode)overviewVersion);
        endpointElementOverview.addChild((OMNode)overviewAddress);
        endpointElement.addChild((OMNode)endpointElementOverview);
        return endpointElement.toString();
    }

    private static String setFullPath(String path) {
        path = path.startsWith("/_system/governance") ? "gov/" + path.substring("/_system/governance/trunk/endpoints/".length()) : "gov/" + path;
        return path;
    }

    public static String deriveEndpointFromContent(String endpointContent) throws RegistryException {
        if (StringUtils.isBlank((String)endpointContent)) {
            throw new IllegalArgumentException("Invalid arguments supplied for derive endpoint from content.");
        }
        try {
            OMElement endpointElement = AXIOMUtil.stringToOM((String)endpointContent);
            OMElement overviewElement = endpointElement.getFirstChildWithName(new QName(ENDPOINT_ELEMENT_NAMESPACE, SYNAPSE_ENDPOINT_OVERVIEW));
            OMElement addressElement = overviewElement.getFirstChildWithName(new QName(ENDPOINT_ELEMENT_NAMESPACE, SYNAPSE_ENDPOINT_ADDRESS));
            return addressElement.getText();
        }
        catch (XMLStreamException e) {
            throw new RegistryException("Invalid endpoint content", (Throwable)e);
        }
    }

    public static String deriveVersionFromContent(String endpointContent) throws RegistryException {
        if (StringUtils.isBlank((String)endpointContent)) {
            throw new IllegalArgumentException("Invalid arguments supplied for derive endpoint version from content.");
        }
        try {
            OMElement endpointElement = AXIOMUtil.stringToOM((String)endpointContent);
            OMElement overviewElement = endpointElement.getFirstChildWithName(new QName(ENDPOINT_ELEMENT_NAMESPACE, SYNAPSE_ENDPOINT_OVERVIEW));
            OMElement addressElement = overviewElement.getFirstChildWithName(new QName(ENDPOINT_ELEMENT_NAMESPACE, SYNAPSE_ENDPOINT_VERSION));
            return addressElement.getText();
        }
        catch (XMLStreamException e) {
            throw new RegistryException("Invalid endpoint content", (Throwable)e);
        }
    }

    public static String deriveNameFromContent(String endpointContent) throws RegistryException {
        if (StringUtils.isBlank((String)endpointContent)) {
            throw new IllegalArgumentException("Invalid arguments supplied for derive endpoint name from content.");
        }
        try {
            OMElement endpointElement = AXIOMUtil.stringToOM((String)endpointContent);
            OMElement overviewElement = endpointElement.getFirstChildWithName(new QName(ENDPOINT_ELEMENT_NAMESPACE, SYNAPSE_ENDPOINT_OVERVIEW));
            OMElement addressElement = overviewElement.getFirstChildWithName(new QName(ENDPOINT_ELEMENT_NAMESPACE, "name"));
            return addressElement.getText();
        }
        catch (XMLStreamException e) {
            throw new RegistryException("Invalid endpoint content", (Throwable)e);
        }
    }

    private static boolean isArgumentsNull(String value1, String value2, String value3, String value4) {
        return StringUtils.isBlank((String)value1) || StringUtils.isBlank((String)value2) || StringUtils.isBlank((String)value3) || StringUtils.isBlank((String)value4);
    }

    public static OMElement deriveOMElementContent(String endpointContent) throws RegistryException {
        if (StringUtils.isBlank((String)endpointContent)) {
            throw new IllegalArgumentException("Invalid arguments supplied for derive endpoint name from content.");
        }
        try {
            OMElement endpointElement = AXIOMUtil.stringToOM((String)endpointContent);
            return endpointElement;
        }
        catch (XMLStreamException e) {
            throw new RegistryException("Invalid endpoint content", (Throwable)e);
        }
    }
}

