/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.RESTServiceUtils;
import org.wso2.carbon.registry.extensions.services.Utils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class SwaggerProcessor {
    private static final Log log = LogFactory.getLog(SwaggerProcessor.class);
    private static final String DEFAULT_TRANSPORT = "http://";
    private static final String DEFAULT_BASE_PATH = "/";
    private RequestContext requestContext;
    private Registry registry;
    private JsonParser parser = new JsonParser();
    private String swaggerResourcesPath;
    private String documentVersion;
    private String endpointUrl;
    private OMElement restServiceElement = null;
    private OMElement endpointElement = null;
    private String endpointLocation;
    private boolean createRestServiceArtifact;

    public SwaggerProcessor(RequestContext requestContext, boolean createRestServiceArtifact) {
        this.requestContext = requestContext;
        this.registry = requestContext.getRegistry();
        this.createRestServiceArtifact = createRestServiceArtifact;
    }

    public boolean isCreateRestServiceArtifact() {
        return this.createRestServiceArtifact;
    }

    public void setCreateRestServiceArtifact(boolean createRestServiceArtifact) {
        this.createRestServiceArtifact = createRestServiceArtifact;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String processSwagger(InputStream inputStream, String commonLocation, String sourceUrl) throws RegistryException {
        this.createCollection(commonLocation);
        ByteArrayOutputStream swaggerContentStream = CommonUtil.readSourceContent(inputStream);
        JsonObject swaggerDocObject = this.getSwaggerObject(swaggerContentStream.toString());
        String swaggerVersion = this.getSwaggerVersion(swaggerDocObject);
        this.documentVersion = this.requestContext.getResource().getProperty("version");
        if (this.documentVersion == null) {
            this.documentVersion = "1.0.0";
            this.requestContext.getResource().setProperty("version", this.documentVersion);
        }
        String swaggerResourcePath = this.getSwaggerDocumentPath(commonLocation, swaggerDocObject);
        if ("1.2".equals(swaggerVersion)) {
            if (!this.addSwaggerDocumentToRegistry(swaggerContentStream, swaggerResourcePath, this.documentVersion)) return null;
            List<JsonObject> resourceObjects = this.addResourceDocsToRegistry(swaggerDocObject, sourceUrl, swaggerResourcePath);
            if (this.isCreateRestServiceArtifact()) {
                this.restServiceElement = resourceObjects != null ? RESTServiceUtils.createRestServiceArtifact(swaggerDocObject, swaggerVersion, this.endpointUrl, resourceObjects, swaggerResourcePath, this.documentVersion) : null;
            }
        } else if ("2.0".equals(swaggerVersion)) {
            if (!this.addSwaggerDocumentToRegistry(swaggerContentStream, swaggerResourcePath, this.documentVersion)) return null;
            this.createEndpointElement(swaggerDocObject, swaggerVersion);
            if (this.isCreateRestServiceArtifact()) {
                this.restServiceElement = RESTServiceUtils.createRestServiceArtifact(swaggerDocObject, swaggerVersion, this.endpointUrl, null, swaggerResourcePath, this.documentVersion);
            }
        }
        if (this.isCreateRestServiceArtifact()) {
            if (this.restServiceElement != null) {
                String servicePath = RESTServiceUtils.addServiceToRegistry(this.requestContext, this.restServiceElement);
                this.registry.addAssociation(servicePath, swaggerResourcePath, "depends");
                this.registry.addAssociation(swaggerResourcePath, servicePath, "usedBy");
                this.saveEndpointElement(servicePath);
            } else {
                log.warn((Object)"Service content is null. Cannot create the REST Service artifact.");
            }
        }
        CommonUtil.closeOutputStream(swaggerContentStream);
        return swaggerResourcePath;
    }

    public void saveEndpointElement(String servicePath) throws RegistryException {
        if (StringUtils.isNotBlank((String)this.endpointUrl)) {
            EndpointUtils.addEndpointToService(this.requestContext.getRegistry(), servicePath, this.endpointUrl, "");
            String endpointPath = RESTServiceUtils.addEndpointToRegistry(this.requestContext, this.endpointElement, this.endpointLocation);
            CommonUtil.addDependency(this.registry, servicePath, endpointPath);
        }
    }

    private boolean addSwaggerDocumentToRegistry(ByteArrayOutputStream contentStream, String path, String documentVersion) throws RegistryException {
        ResourceImpl resource;
        if (this.registry.resourceExists(path)) {
            String resourceContent;
            resource = this.registry.get(path);
            Object resourceContentObj = resource.getContent();
            if (resourceContentObj instanceof String) {
                resourceContent = (String)resourceContentObj;
                resource.setContent((Object)RegistryUtils.encodeString((String)resourceContent));
            } else if (resourceContentObj instanceof byte[]) {
                resourceContent = RegistryUtils.decodeBytes((byte[])((byte[])resourceContentObj));
            } else {
                throw new RegistryException("Resource content is not valid.");
            }
            if (resourceContent.equals(contentStream.toString())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Old content is same as the new content. Skipping the put action.");
                }
                return true;
            }
        } else {
            resource = new ResourceImpl();
        }
        String resourceId = resource.getUUID() == null ? UUID.randomUUID().toString() : resource.getUUID();
        resource.setUUID(resourceId);
        resource.setMediaType("application/swagger+json");
        resource.setContent((Object)contentStream.toByteArray());
        resource.addProperty("version", documentVersion);
        CommonUtil.copyProperties(this.requestContext.getResource(), (Resource)resource);
        this.registry.put(path, (Resource)resource);
        return true;
    }

    private void createCollection(String commonLocation) throws RegistryException {
        Registry systemRegistry = CommonUtil.getUnchrootedSystemRegistry(this.requestContext);
        if (!systemRegistry.resourceExists(commonLocation)) {
            systemRegistry.put(commonLocation, (Resource)systemRegistry.newCollection());
        }
    }

    private List<JsonObject> addResourceDocsToRegistry(JsonObject swaggerDocObject, String sourceUrl, String swaggerDocPath) throws RegistryException {
        if (sourceUrl == null) {
            log.debug((Object)"Source url is empty. Cannot read content.");
            log.warn((Object)"Resource paths cannot be read. Creating the REST service might fail.");
            return null;
        }
        if (sourceUrl.startsWith("file")) {
            sourceUrl = sourceUrl.substring(0, sourceUrl.lastIndexOf(DEFAULT_BASE_PATH));
        }
        ArrayList<JsonObject> resourceObjects = new ArrayList<JsonObject>();
        JsonArray pathResources = swaggerDocObject.get("apis").getAsJsonArray();
        ByteArrayOutputStream resourceContentStream = null;
        InputStream resourceInputStream = null;
        for (JsonElement pathResource : pathResources) {
            JsonObject resourceObj = pathResource.getAsJsonObject();
            String path = resourceObj.get("path").getAsString();
            try {
                resourceInputStream = new URL(sourceUrl + path).openStream();
            }
            catch (IOException e) {
                throw new RegistryException("The URL " + sourceUrl + path + " is incorrect.", (Throwable)e);
            }
            resourceContentStream = CommonUtil.readSourceContent(resourceInputStream);
            JsonObject resourceObject = this.parser.parse(resourceContentStream.toString()).getAsJsonObject();
            resourceObjects.add(resourceObject);
            if (this.endpointElement == null) {
                this.createEndpointElement(resourceObject, "1.2");
            }
            path = path.replace(DEFAULT_BASE_PATH, "");
            path = CommonUtil.replaceExpressionOfPath(this.swaggerResourcesPath, "name", path);
            path = RegistryUtils.getAbsolutePath((RegistryContext)this.registry.getRegistryContext(), (String)path);
            if (!this.addSwaggerDocumentToRegistry(resourceContentStream, path, this.documentVersion)) continue;
            this.registry.addAssociation(swaggerDocPath, path, "depends");
        }
        CommonUtil.closeOutputStream(resourceContentStream);
        CommonUtil.closeInputStream(resourceInputStream);
        return resourceObjects;
    }

    private void createEndpointElement(JsonObject swaggerObject, String swaggerVersion) throws RegistryException {
        if ("1.2".equals(swaggerVersion)) {
            JsonElement endpointUrlElement = swaggerObject.get("basePath");
            if (endpointUrlElement == null) {
                log.warn((Object)"Endpoint url is not specified in the swagger document. Endpoint creation might fail. ");
                return;
            }
            this.endpointUrl = endpointUrlElement.getAsString();
        } else if ("2.0".equals(swaggerVersion)) {
            String host;
            JsonElement transportsElement = swaggerObject.get("schemes");
            JsonArray transports = transportsElement != null ? transportsElement.getAsJsonArray() : null;
            String transport = transports != null ? transports.get(0).getAsString() + "://" : DEFAULT_TRANSPORT;
            JsonElement hostElement = swaggerObject.get("host");
            String string = host = hostElement != null ? hostElement.getAsString() : null;
            if (host == null) {
                log.warn((Object)"Endpoint(host) url is not specified in the swagger document. The host serving the documentation is to be used(including the port) as endpoint host");
                if (this.requestContext.getSourceURL() != null) {
                    URL sourceURL = null;
                    try {
                        sourceURL = new URL(this.requestContext.getSourceURL());
                    }
                    catch (MalformedURLException e) {
                        throw new RegistryException("Error in parsing the source URL. ", (Throwable)e);
                    }
                    host = sourceURL.getAuthority();
                }
            }
            if (host == null) {
                log.warn((Object)"Can't derive the endpoint(host) url when uploading swagger from file. Endpoint creation might fail. ");
                return;
            }
            JsonElement basePathElement = swaggerObject.get("basePath");
            String basePath = basePathElement != null ? basePathElement.getAsString() : DEFAULT_BASE_PATH;
            this.endpointUrl = transport + host + basePath;
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        this.endpointLocation = EndpointUtils.deriveEndpointFromUrl(this.endpointUrl);
        String endpointName = EndpointUtils.deriveEndpointNameWithNamespaceFromUrl(this.endpointUrl);
        String endpointContent = EndpointUtils.getEndpointContentWithOverview(this.endpointUrl, this.endpointLocation, endpointName, this.documentVersion);
        try {
            this.endpointElement = AXIOMUtil.stringToOM((OMFactory)factory, (String)endpointContent);
        }
        catch (XMLStreamException e) {
            throw new RegistryException("Error in creating the endpoint element. ", (Throwable)e);
        }
    }

    private String getSwaggerDocumentPath(String rootLocation, JsonObject content) throws RegistryException {
        JsonObject infoObject;
        String swaggerDocPath = this.requestContext.getResourcePath().getPath();
        String swaggerDocName = swaggerDocPath.substring(swaggerDocPath.lastIndexOf(DEFAULT_BASE_PATH) + 1);
        JsonElement infoElement = content.get("info");
        JsonObject jsonObject = infoObject = infoElement != null ? infoElement.getAsJsonObject() : null;
        if (infoObject == null || infoElement.isJsonNull()) {
            throw new RegistryException("Invalid swagger document.");
        }
        String serviceName = infoObject.get("title").getAsString().replaceAll("\\s", "");
        String serviceProvider = CarbonContext.getThreadLocalCarbonContext().getUsername();
        this.swaggerResourcesPath = rootLocation + serviceProvider + DEFAULT_BASE_PATH + serviceName + DEFAULT_BASE_PATH + this.documentVersion;
        String pathExpression = this.getSwaggerRegistryPath(swaggerDocName, serviceProvider);
        return RegistryUtils.getAbsolutePath((RegistryContext)this.registry.getRegistryContext(), (String)pathExpression);
    }

    private String getSwaggerRegistryPath(String swaggerDocName, String serviceProvider) {
        String pathExpression = Utils.getRxtService().getStoragePath("application/swagger+json");
        pathExpression = CommonUtil.getPathFromPathExpression(pathExpression, this.requestContext.getResource().getProperties(), null);
        this.swaggerResourcesPath = pathExpression = CommonUtil.replaceExpressionOfPath(pathExpression, "provider", serviceProvider);
        String swaggerPath = pathExpression = CommonUtil.replaceExpressionOfPath(pathExpression, "name", swaggerDocName);
        if (CurrentSession.getLocalPathMap() != null && !Boolean.valueOf((String)CurrentSession.getLocalPathMap().get("archieve-upload")).booleanValue()) {
            swaggerPath = CommonUtil.getRegistryPath(this.requestContext.getRegistry().getRegistryContext(), pathExpression);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving current session local paths, key: " + swaggerPath + " | value: " + pathExpression));
            }
            CurrentSession.getLocalPathMap().put(swaggerPath, pathExpression);
        }
        return swaggerPath;
    }

    private JsonObject getSwaggerObject(String swaggerContent) throws RegistryException {
        JsonElement swaggerElement = this.parser.parse(swaggerContent);
        if (swaggerElement == null || swaggerElement.isJsonNull()) {
            throw new RegistryException("Unexpected error occurred when parsing the swagger content.");
        }
        return swaggerElement.getAsJsonObject();
    }

    private String getSwaggerVersion(JsonObject swaggerDocObject) throws RegistryException {
        JsonElement swaggerVersionElement = swaggerDocObject.get("swaggerVersion");
        JsonElement jsonElement = swaggerVersionElement = swaggerVersionElement == null ? swaggerDocObject.get("swagger") : swaggerVersionElement;
        if (swaggerVersionElement == null) {
            throw new RegistryException("Unsupported swagger version.");
        }
        return swaggerVersionElement.getAsString();
    }
}

