/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.utils.CarbonUtils;

@Component(name="org.wso2.carbon.registry.resource.permissions", immediate=true)
public class RegistryResourcePermissionsServiceComponent {
    private static Log log = LogFactory.getLog(RegistryResourcePermissionsServiceComponent.class);
    public static final String EXECUTE_ACTION = "ui.execute";
    private Stack<ServiceRegistration> serviceRegistrations = new Stack();
    private RegistryService registryService;

    @Activate
    protected void activate(ComponentContext context) {
        this.loadMappings();
        log.debug((Object)"Registry Resource Permissions component is activated");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
    }

    private void loadMappings() {
        File mappingsXML;
        String configPath = CarbonUtils.getEtcCarbonConfigDirPath();
        if (configPath != null && (mappingsXML = new File(configPath = configPath + File.separator + "permission-mappings.xml")).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(mappingsXML);
                StAXOMBuilder builder = new StAXOMBuilder((InputStream)fileInputStream);
                OMElement configElement = builder.getDocumentElement();
                int counter = 100;
                Iterator mappings = configElement.getChildrenWithName(new QName("mapping"));
                while (mappings.hasNext()) {
                    String[] resourcePaths;
                    OMElement mapping = (OMElement)mappings.next();
                    String managementPermission = mapping.getAttributeValue(new QName("managementPermission"));
                    String resourcePermission = mapping.getAttributeValue(new QName("resourcePermission"));
                    for (String resourcePath : resourcePaths = mapping.getAttributeValue(new QName("resourcePaths")).split(",")) {
                        AuthorizationUtils.addAuthorizeRoleListener((int)counter++, (String)resourcePath.trim(), (String)managementPermission, (String)EXECUTE_ACTION, (String[])new String[]{resourcePermission});
                    }
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Unable to parse permission-mappings.xml", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Unable to read permission-mappings.xml", (Throwable)e);
            }
        }
    }
}

