/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.jmx;

import java.util.Date;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.extensions.jmx.ActivitiesMBean;
import org.wso2.carbon.registry.extensions.jmx.Utils;

public class Activities
implements ActivitiesMBean {
    private static final Log log = LogFactory.getLog(Activities.class);
    private Registry registry;

    public Activities(Registry registry) {
        this.registry = registry;
    }

    public String[] getActivitiesForUser(String username) {
        return this.getActivities(null, username);
    }

    public String[] getActivitiesForPath(String path) {
        return this.getActivities(path, null);
    }

    public String[] getList() {
        return this.getActivities(null, null);
    }

    private String[] getActivities(String path, String username) {
        LinkedList<String> activities = new LinkedList<String>();
        try {
            LogEntry[] logs;
            block19: for (LogEntry log : logs = this.registry.getLogs(path, -1, username, null, null, true)) {
                switch (log.getAction()) {
                    case 0: {
                        activities.add(log.getUserName() + " has added the resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 1: {
                        activities.add(log.getUserName() + " has updated the resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 7: {
                        activities.add(log.getUserName() + " has deleted the resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 2: {
                        activities.add(log.getUserName() + " has commented on the resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 3: {
                        activities.add(log.getUserName() + " has deleted a comment on the resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 4: {
                        activities.add(log.getUserName() + " has tagged the resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 5: {
                        activities.add(log.getUserName() + " has removed tag on the resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 6: {
                        activities.add(log.getUserName() + " has rated the resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 8: {
                        activities.add(log.getUserName() + " has restored the resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 15: {
                        activities.add(log.getUserName() + " has created an association to resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 16: {
                        activities.add(log.getUserName() + " has removed an association to resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 12: {
                        activities.add(log.getUserName() + " has created a remote link to resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 13: {
                        activities.add(log.getUserName() + " has created a symbolic link to resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 14: {
                        activities.add(log.getUserName() + " has removed a link to resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                        continue block19;
                    }
                    case 17: {
                        activities.add(log.getUserName() + " has associated an aspect to resource " + log.getResourcePath() + " at " + CommonUtil.formatDate((Date)log.getDate()) + ".");
                    }
                }
            }
        }
        catch (RegistryException e) {
            String msg = "An error occurred while reading audit logs.";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(Utils.buildMessageForRuntimeException((Exception)((Object)e), msg));
        }
        return activities.toArray(new String[activities.size()]);
    }
}

