/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.utils;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.wso2.carbon.registry.core.Registry;

public class WSDLUtil {
    private static Log log = LogFactory.getLog(WSDLUtil.class);
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    public static String getUniqueNameAfterURLNameMangling(String commonSchemaLocation, String targetNamespace) {
        targetNamespace = targetNamespace.replace("://", "/");
        targetNamespace = targetNamespace.replace(".", "/");
        targetNamespace = targetNamespace.replace("#", "/");
        while (targetNamespace.indexOf("//") > 0) {
            targetNamespace = targetNamespace.replace("//", "/");
        }
        String resourcePath = commonSchemaLocation.endsWith("/") ? commonSchemaLocation + targetNamespace : commonSchemaLocation + "/" + targetNamespace;
        if (!targetNamespace.endsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        return resourcePath;
    }

    public static String getLocationPrefix(String registryPath) {
        String[] parts = registryPath.split("/");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parts.length - 2; ++i) {
            sb.append("../");
        }
        String prefix = sb.toString();
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public static String computeRelativePathWithVersion(String basePath, String targetPath, Registry registry) {
        String relativePath = WSDLUtil.computeRelativePath(basePath, targetPath);
        return relativePath;
    }

    public static String computeRelativePath(String basePath, String targetPath) {
        int i;
        String[] basePathParts = basePath.split("/");
        String[] targetPathParts = targetPath.split("/");
        for (i = 1; i < basePathParts.length - 1 && i < targetPathParts.length - 1 && basePathParts[i].equals(targetPathParts[i]); ++i) {
        }
        StringBuffer prefix = new StringBuffer();
        int j = i;
        while (i < basePathParts.length - 1) {
            prefix.append("../");
            ++i;
        }
        if (prefix.length() == 0) {
            prefix.append("./");
        }
        while (j < targetPathParts.length - 1) {
            prefix.append(targetPathParts[j]).append("/");
            ++j;
        }
        return prefix.toString() + targetPathParts[targetPathParts.length - 1];
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilder() {
        Object Constants2 = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/" + "external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/" + "external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/" + "nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Failed to load XML Processor Feature " + "external-general-entities" + " or " + "external-parameter-entities" + " or " + "nonvalidating/load-external-dtd"));
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/" + "security-manager", securityManager);
        return dbf;
    }
}

