/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jvnet.ws.wadl.Application;
import org.jvnet.ws.wadl.ast.AbstractNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.xml.sax.Locator;

public class ApplicationNode
extends AbstractNode {
    private Application application;
    private List<ResourceNode> resources;

    public ApplicationNode(Application application, List<ResourceNode> resources) {
        this.application = application;
        this.resources = Collections.unmodifiableList(new ArrayList<ResourceNode>(resources));
    }

    public List<ResourceNode> getResources() {
        return this.resources;
    }

    @Override
    public Locator getLocation() {
        return this.application.sourceLocation();
    }

    @Override
    public void visit(AbstractNode.NodeVisitor visitor) {
        super.visit(visitor);
        for (ResourceNode node : this.getResources()) {
            node.visit(visitor);
        }
    }
}

