/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.governance.common.GovernanceConfiguration;
import org.wso2.carbon.governance.common.GovernanceConfigurationException;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.SAXException;

public class GovernanceUtils {
    public static final String DISCOVERY_AGENTS = "DiscoveryAgents";
    public static final String DISCOVERY_AGENT = "DiscoveryAgent";
    public static final String SERVER_TYPE_ID = "ServerTypeId";
    public static final String AGENT_CLASS = "AgentClass";
    public static final String PROPERTY = "property";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String GOVERNANCE_CONFIG_FILE = "governance.xml";
    public static final String COMPARATORS = "Comparators";
    public static final String COMPARATOR = "Comparator";
    public static final String CLASS_ATTR = "class";
    public static final String ENDPOINT_STATE_MANAGEMENT = "EndpointStateManagement";
    public static final String ENDPOINT_STATE_MANAGEMENT_ENABLED = "enabled";
    public static final String DEFAULT_ENDPOINT_ACTIVE_DURATION = "DefaultEndpointActiveDuration";
    public static final String ENABLE_LIFECYCLE_CHECKLIST_ITEMS = "enableLifecycleChecklistItems";
    public static final String LIFECYCLE_CHECKLIST_ITEMS_ENABLED = "true";
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static Log log = LogFactory.getLog(GovernanceUtils.class);
    private static boolean isConfigInitialized = false;

    public static GovernanceConfiguration getGovernanceConfiguration() throws GovernanceConfigurationException {
        GovernanceConfiguration govConfig = GovernanceConfiguration.getInstance();
        if (!isConfigInitialized) {
            String governanceXML = GovernanceUtils.getGovernanceXML();
            File governanceXMLFile = new File(governanceXML);
            FileInputStream in = null;
            try {
                in = new FileInputStream(governanceXMLFile);
                GovernanceUtils.initGovernanceConfiguration(in, govConfig);
                isConfigInitialized = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)govConfig);
                }
            }
            catch (IOException e) {
                throw new GovernanceConfigurationException("Cannot read file " + governanceXML, e);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        log.warn((Object)("Cannot close file " + governanceXML), (Throwable)e);
                    }
                }
            }
        }
        return govConfig;
    }

    private static void initGovernanceConfiguration(InputStream in, GovernanceConfiguration govConfig) throws GovernanceConfigurationException {
        try {
            DocumentBuilderFactory factory = GovernanceUtils.getSecuredDocumentBuilder();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            GovernanceUtils.readChildElements(document.getDocumentElement(), govConfig);
            isConfigInitialized = true;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.fatal((Object)"Problem in parsing governance configuration file ", (Throwable)e);
            throw new GovernanceConfigurationException(e);
        }
    }

    private static String getGovernanceXML() {
        return GovernanceUtils.getCarbonConfigDirPath() + File.separator + GOVERNANCE_CONFIG_FILE;
    }

    private static void readChildElements(Element config, GovernanceConfiguration govConfig) {
        GovernanceUtils.readDiscoveryAgents(config, govConfig);
        GovernanceUtils.readComparators(config, govConfig);
        GovernanceUtils.readEndpointStateManagement(config, govConfig);
        GovernanceUtils.readLifecycleChecklistItems(config, govConfig);
    }

    private static void readDiscoveryAgents(Element config, GovernanceConfiguration govConfig) {
        Element agentsElement = GovernanceUtils.getFirstElement(config, DISCOVERY_AGENTS);
        if (agentsElement != null) {
            NodeList agents = agentsElement.getElementsByTagName(DISCOVERY_AGENT);
            for (int i = 0; i < agents.getLength(); ++i) {
                Element agent = (Element)agents.item(i);
                String serverType = GovernanceUtils.getFirstElementContent(agent, SERVER_TYPE_ID);
                String agentClass = GovernanceUtils.getFirstElementContent(agent, AGENT_CLASS);
                Map<String, String> properties = GovernanceUtils.getProperties(agent);
                properties.put(AGENT_CLASS, agentClass);
                govConfig.addDiscoveryAgentConfig(serverType, properties);
            }
        }
    }

    private static void readComparators(Element config, GovernanceConfiguration govConfig) {
        Element comparatorsEle = GovernanceUtils.getFirstElement(config, COMPARATORS);
        if (comparatorsEle != null) {
            NodeList comparatorsElements = comparatorsEle.getElementsByTagName(COMPARATOR);
            for (int i = 0; i < comparatorsElements.getLength(); ++i) {
                Element comparatorEle = (Element)comparatorsElements.item(i);
                String comparatorClass = comparatorEle.getAttribute(CLASS_ATTR);
                if (comparatorClass == null || comparatorClass.isEmpty()) continue;
                govConfig.addComparator(comparatorClass);
            }
        }
    }

    private static void readEndpointStateManagement(Element config, GovernanceConfiguration govConfig) {
        String durationStr;
        Element DefaultEndpointActiveEle;
        String enabled;
        Element endpointStateManagementEle = GovernanceUtils.getFirstElement(config, ENDPOINT_STATE_MANAGEMENT);
        if (endpointStateManagementEle != null && (enabled = endpointStateManagementEle.getTextContent()) != null && ENDPOINT_STATE_MANAGEMENT_ENABLED.equals(enabled.toLowerCase())) {
            govConfig.setEndpointStateManagementEnabled(true);
        }
        if ((DefaultEndpointActiveEle = GovernanceUtils.getFirstElement(config, DEFAULT_ENDPOINT_ACTIVE_DURATION)) != null && (durationStr = DefaultEndpointActiveEle.getTextContent()) != null) {
            long duration = Long.valueOf(durationStr);
            govConfig.setDefaultEndpointActiveDuration(duration);
        }
    }

    private static void readLifecycleChecklistItems(Element config, GovernanceConfiguration govConfig) {
        String lifecycleEnabled;
        Element enableLifecycleChecklistItemsElement = GovernanceUtils.getFirstElement(config, ENABLE_LIFECYCLE_CHECKLIST_ITEMS);
        if (enableLifecycleChecklistItemsElement != null && (lifecycleEnabled = enableLifecycleChecklistItemsElement.getTextContent()) != null && LIFECYCLE_CHECKLIST_ITEMS_ENABLED.equals(lifecycleEnabled.toLowerCase())) {
            govConfig.setLifecycleChecklistItemsEnabled(true);
        }
    }

    private static Map<String, String> getProperties(Element agentEle) {
        NodeList propertyNodes = agentEle.getElementsByTagName(PROPERTY);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            Element propertyELe = (Element)propertyNodes.item(i);
            String propertyKey = propertyELe.getAttribute(NAME);
            String propertyValue = propertyELe.getAttribute(VALUE);
            if (propertyKey == null || propertyValue == null || propertyKey.isEmpty() || propertyValue.isEmpty()) continue;
            properties.put(propertyKey, propertyValue);
        }
        return properties;
    }

    private static Element getFirstElement(Element element, String childName) {
        if (element.getElementsByTagName(childName) != null) {
            return (Element)element.getElementsByTagName(childName).item(0);
        }
        return null;
    }

    private static String getFirstElementContent(Element element, String childName) {
        return element.getElementsByTagName(childName).item(0).getTextContent();
    }

    public static String getCarbonConfigDirPath() {
        String carbonConfigDir = System.getProperty("carbon.config.dir.path");
        if (carbonConfigDir == null) {
            carbonConfigDir = CarbonUtils.getCarbonConfigDirPath();
        }
        return carbonConfigDir;
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilder() {
        Object Constants = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/" + "external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/" + "external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/" + "nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Failed to load XML Processor Feature " + "external-general-entities" + " or " + "external-parameter-entities" + " or " + "nonvalidating/load-external-dtd"));
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/" + "security-manager", securityManager);
        return dbf;
    }
}

