/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.aspects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class Lifecycle
extends Aspect {
    public static final String PROMOTE = "promote";
    public static final String DEMOTE = "demote";
    private List<String> states = new ArrayList<String>();
    private Map<String, List<Condition>> transitions = new HashMap<String, List<Condition>>();
    private String stateProperty = "registry.lifecycle.Lifecycle.state";
    private String lifecyleProperty = "registry.LC.name";
    private String aspectName = "Lifecycle";

    public Lifecycle() {
        this.states.add("Created");
        this.states.add("Tested");
        this.states.add("Deployed");
        this.states.add("Deprecated");
    }

    public Lifecycle(OMElement config) throws RegistryException {
        String myName;
        this.aspectName = myName = config.getAttributeValue(new QName("name"));
        myName = myName.replaceAll("\\s", "");
        this.stateProperty = "registry.lifecycle." + myName + ".state";
        Iterator stateElements = config.getChildElements();
        while (stateElements.hasNext()) {
            OMElement stateEl = (OMElement)stateElements.next();
            String name = stateEl.getAttributeValue(new QName("name"));
            if (name == null) {
                throw new IllegalArgumentException("Must have a name attribute for each state");
            }
            this.states.add(name);
            ArrayList<Condition> conditions = null;
            Iterator conditionIterator = stateEl.getChildElements();
            while (conditionIterator.hasNext()) {
                OMElement conditionEl = (OMElement)conditionIterator.next();
                if (!conditionEl.getQName().equals(new QName("condition"))) continue;
                String property = conditionEl.getAttributeValue(new QName("property"));
                String condition = conditionEl.getAttributeValue(new QName("condition"));
                String value = conditionEl.getAttributeValue(new QName("value"));
                Condition c = new Condition(property, condition, value);
                if (conditions == null) {
                    conditions = new ArrayList<Condition>();
                }
                conditions.add(c);
            }
            if (conditions == null) continue;
            this.transitions.put(name, conditions);
        }
    }

    public void associate(Resource resource, Registry registry) throws RegistryException {
        resource.setProperty(this.stateProperty, this.states.get(0));
        resource.setProperty(this.lifecyleProperty, this.aspectName);
    }

    public void invoke(RequestContext context, String action) throws RegistryException {
        String newState;
        Resource resource = context.getResource();
        String currentState = resource.getProperty(this.stateProperty);
        int stateIndex = this.states.indexOf(currentState);
        if (stateIndex == -1) {
            throw new RegistryException("State '" + currentState + "' is not valid!");
        }
        if (PROMOTE.equals(action)) {
            if (stateIndex == this.states.size() - 1) {
                throw new RegistryException("Can't promote beyond end of configured lifecycle!");
            }
            List<Condition> conditions = this.transitions.get(currentState);
            if (conditions != null) {
                for (Condition condition : conditions) {
                    if (condition.isTrue(resource)) continue;
                    throw new RegistryException("Condition failed - " + condition.getDescription());
                }
            }
            newState = this.states.get(stateIndex + 1);
        } else if (DEMOTE.equals(action)) {
            if (stateIndex == 0) {
                throw new RegistryException("Can't demote beyond start of configured lifecycle!");
            }
            newState = this.states.get(stateIndex - 1);
        } else {
            throw new RegistryException("Invalid action '" + action + "'");
        }
        resource.setProperty(this.stateProperty, newState);
        context.getRepository().put(resource.getPath(), resource);
    }

    public String[] getAvailableActions(RequestContext context) {
        ArrayList<String> actions = new ArrayList<String>();
        Resource resource = context.getResource();
        String currentState = resource.getProperty(this.stateProperty);
        int stateIndex = this.states.indexOf(currentState);
        if (stateIndex > -1 && stateIndex < this.states.size() - 1) {
            actions.add(PROMOTE);
        }
        if (stateIndex > 0) {
            actions.add(DEMOTE);
        }
        return actions.toArray(new String[actions.size()]);
    }

    public void dissociate(RequestContext context) {
        Resource resource = context.getResource();
        if (resource != null) {
            resource.removeProperty(this.stateProperty);
            resource.removeProperty(this.lifecyleProperty);
        }
    }

    public String getCurrentState(Resource resource) {
        return resource.getProperty(this.stateProperty);
    }

    static class Condition {
        public String property;
        public ConditionEnum condition;
        public String value;

        Condition(String property, String condition, String value) {
            this.property = property;
            this.condition = ConditionEnum.valueOf(condition);
            this.value = value;
        }

        public boolean isTrue(Resource resource) {
            String propVal = resource.getProperty(this.property);
            if (propVal == null) {
                return this.condition == ConditionEnum.isNull;
            }
            switch (this.condition) {
                case equals: {
                    return propVal.equals(this.value);
                }
                case contains: {
                    return propVal.indexOf(this.value) > -1;
                }
                case lessThan: {
                    return Integer.parseInt(propVal) < Integer.parseInt(this.value);
                }
                case greaterThan: {
                    return Integer.parseInt(propVal) > Integer.parseInt(this.value);
                }
            }
            return false;
        }

        public String getDescription() {
            StringBuffer ret = new StringBuffer();
            ret.append("Property '");
            ret.append(this.property);
            ret.append("' ");
            switch (this.condition) {
                case isNull: {
                    ret.append("must be null");
                    break;
                }
                case equals: {
                    ret.append("must equal '");
                    ret.append(this.value);
                    ret.append("'");
                    break;
                }
                case contains: {
                    ret.append("must contain '");
                    ret.append(this.value);
                    ret.append("'");
                    break;
                }
                case lessThan: {
                    ret.append("must be less than ");
                    ret.append(this.value);
                    break;
                }
                case greaterThan: {
                    ret.append("must be greater than ");
                    ret.append(this.value);
                }
            }
            return ret.toString();
        }
    }

    public static enum ConditionEnum {
        isNull,
        equals,
        contains,
        lessThan,
        greaterThan;

    }
}

