/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.RESTServiceUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.SwaggerProcessor;
import org.wso2.carbon.registry.extensions.handlers.utils.WADLProcessor;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class RESTServiceMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(RESTServiceMediaTypeHandler.class);
    private static final String INTERFACE_ELEMENT_LOCAL_NAME = "interface";
    private static final String SWAGGER_ELEMENT_LOCAL_NAME = "swagger";
    private static final String WADL_ELEMENT_LOCAL_NAME = "wadl";
    private String swaggerLocation;
    private String wadlLocation;

    public void setSwaggerLocationConfiguration(OMElement locationConfiguration) {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!"location".equals(confElement.getLocalName())) continue;
            this.swaggerLocation = confElement.getText();
            if (!this.swaggerLocation.startsWith("/")) {
                this.swaggerLocation = "/" + this.swaggerLocation;
            }
            if (this.swaggerLocation.endsWith("/")) continue;
            this.swaggerLocation = this.swaggerLocation + "/";
        }
    }

    public void setWadlLocationConfiguration(OMElement locationConfiguration) {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!"location".equals(confElement.getLocalName())) continue;
            this.wadlLocation = confElement.getText();
            if (!this.wadlLocation.startsWith("/")) {
                this.wadlLocation = "/" + this.wadlLocation;
            }
            if (this.wadlLocation.endsWith("/")) continue;
            this.wadlLocation = this.wadlLocation + "/";
        }
    }

    public void put(RequestContext requestContext) throws RegistryException {
        OMElement serviceInfoElement;
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        Registry registry = requestContext.getRegistry();
        Resource resource = requestContext.getResource();
        if (resource == null) {
            throw new RegistryException("Resource does not exist.");
        }
        Object resourceContent = resource.getContent();
        String serviceInfo = resourceContent instanceof String ? (String)resourceContent : RegistryUtils.decodeBytes((byte[])((byte[])resourceContent));
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(serviceInfo));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            serviceInfoElement = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            StringBuilder msg = new StringBuilder("Error in parsing the service content of the service. ").append("The requested path to store the service: ").append(requestContext.getResourcePath().getPath()).append(".");
            log.error((Object)msg.toString());
            throw new RegistryException(msg.toString(), (Throwable)e);
        }
        String serviceVersion = CommonUtil.getServiceVersion(serviceInfoElement);
        if (serviceVersion.length() == 0) {
            serviceVersion = "1.0.0";
            CommonUtil.setServiceVersion(serviceInfoElement, serviceVersion);
            resource.setContent((Object)serviceInfoElement.toString());
        }
        resource.setProperty("version", serviceVersion);
        InputStream inputStream = null;
        try {
            SwaggerProcessor swaggerProcessor = null;
            WADLProcessor wadlProcessor = null;
            OMElement interfaceElement = serviceInfoElement.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", INTERFACE_ELEMENT_LOCAL_NAME, ""));
            String swaggerPath = null;
            String wadlPath = null;
            if (interfaceElement != null) {
                String swaggerUrl = RESTServiceUtils.getDefinitionURL(serviceInfoElement, SWAGGER_ELEMENT_LOCAL_NAME);
                String wadlUrl = RESTServiceUtils.getDefinitionURL(serviceInfoElement, WADL_ELEMENT_LOCAL_NAME);
                interfaceElement.detach();
                if (CommonUtil.isValidUrl(swaggerUrl)) {
                    requestContext.setSourceURL(swaggerUrl);
                    swaggerProcessor = new SwaggerProcessor(requestContext, false);
                    inputStream = new URL(swaggerUrl).openStream();
                    swaggerPath = swaggerProcessor.processSwagger(inputStream, this.getChrootedLocation(requestContext.getRegistryContext(), this.swaggerLocation), swaggerUrl);
                    OMElement swaggerElement = interfaceElement.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", SWAGGER_ELEMENT_LOCAL_NAME, ""));
                    swaggerElement.detach();
                    swaggerElement.setText(swaggerPath);
                    interfaceElement.addChild((OMNode)swaggerElement);
                }
                if (CommonUtil.isValidUrl(wadlUrl)) {
                    requestContext.setSourceURL(wadlUrl);
                    wadlProcessor = new WADLProcessor(requestContext);
                    wadlProcessor.setCreateService(false);
                    wadlPath = wadlProcessor.importWADLToRegistry(requestContext, true);
                    OMElement wadlElement = interfaceElement.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", WADL_ELEMENT_LOCAL_NAME, ""));
                    wadlElement.detach();
                    wadlElement.setText(wadlPath);
                    interfaceElement.addChild((OMNode)wadlElement);
                }
                serviceInfoElement.addChild((OMNode)interfaceElement);
            }
            String servicePath = RESTServiceUtils.addServiceToRegistry(requestContext, serviceInfoElement);
            if (StringUtils.isNotBlank(swaggerPath)) {
                swaggerProcessor.saveEndpointElement(servicePath);
                CommonUtil.addDependency(registry, servicePath, swaggerPath);
            }
            if (StringUtils.isNotBlank(wadlPath)) {
                wadlProcessor.saveEndpointElement(requestContext, servicePath, serviceVersion);
                CommonUtil.addDependency(registry, servicePath, wadlPath);
            }
            requestContext.setProcessingComplete(true);
        }
        catch (IOException e) {
            throw new RegistryException("Cannot open a stream for the given URL, " + requestContext.getSourceURL(), (Throwable)e);
        }
        finally {
            CommonUtil.releaseUpdateLock();
            CommonUtil.closeInputStream(inputStream);
        }
    }

    private String getChrootedLocation(RegistryContext registryContext, String resourceLocation) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + resourceLocation));
    }
}

