/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.uddi.api_v3.AuthToken;
import org.wso2.carbon.registry.common.utils.artifact.manager.ArtifactManager;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.beans.BusinessServiceInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.UDDIPublisher;
import org.wso2.carbon.registry.extensions.handlers.utils.WADLProcessor;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLProcessor;
import org.wso2.carbon.registry.extensions.services.Utils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.uddi.utils.UDDIUtil;

public class ServiceMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(ServiceMediaTypeHandler.class);
    private static final String TRUNK = "trunk";
    private String defaultEnvironment;
    private boolean disableWSDLValidation = false;
    private boolean disableWADLValidation = false;
    private List<String> smartLifecycleLinks = new LinkedList<String>();
    private String defaultServiceVersion = "1.0.0";
    private boolean disableSymlinkCreation = true;

    public void setDefaultServiceVersion(String defaultServiceVersion) {
        this.defaultServiceVersion = defaultServiceVersion;
    }

    public void setSmartLifecycleLinks(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName("key"))) continue;
            this.smartLifecycleLinks.add(confElement.getText());
        }
    }

    public boolean isDisableSymlinkCreation() {
        return this.disableSymlinkCreation;
    }

    public void setDisableSymlinkCreation(String disableSymlinkCreation) {
        this.disableSymlinkCreation = Boolean.toString(true).equals(disableSymlinkCreation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        WSDLProcessor wsdl = null;
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            String definitionPath;
            String msg;
            OMElement serviceInfoElement;
            Registry registry = requestContext.getRegistry();
            Resource resource = requestContext.getResource();
            if (resource == null) {
                throw new RegistryException("The resource is not available.");
            }
            String originalServicePath = requestContext.getResourcePath().getPath();
            String resourceName = RegistryUtils.getResourceName((String)originalServicePath);
            OMElement previousServiceInfoElement = null;
            Object resourceContent = resource.getContent();
            String serviceInfo = resourceContent instanceof String ? (String)resourceContent : RegistryUtils.decodeBytes((byte[])((byte[])resourceContent));
            try {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(serviceInfo));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                serviceInfoElement = builder.getDocumentElement();
            }
            catch (Exception e) {
                String msg2 = "Error in parsing the service content of the service. The requested path to store the service: " + originalServicePath + ".";
                log.error((Object)msg2);
                throw new RegistryException(msg2, (Throwable)e);
            }
            String serviceName = CommonUtil.getServiceName(serviceInfoElement);
            String serviceNamespace = CommonUtil.getServiceNamespace(serviceInfoElement);
            String serviceVersion = CommonUtil.getServiceVersion(serviceInfoElement);
            if (serviceVersion.length() == 0) {
                serviceVersion = this.defaultServiceVersion;
                CommonUtil.setServiceVersion(serviceInfoElement, serviceVersion);
                resource.setContent((Object)serviceInfoElement.toString());
            }
            String servicePath = "";
            if (serviceInfoElement.getChildrenWithLocalName("newServicePath").hasNext()) {
                Iterator OmElementIterator = serviceInfoElement.getChildrenWithLocalName("newServicePath");
                if (OmElementIterator.hasNext()) {
                    OMElement next = (OMElement)OmElementIterator.next();
                    servicePath = next.getText();
                }
            } else {
                servicePath = registry.resourceExists(originalServicePath) ? originalServicePath : this.getServicePath(registry, resource, serviceInfoElement, serviceName, serviceNamespace, serviceVersion);
            }
            String serviceId = resource.getUUID();
            if (serviceId == null) {
                serviceId = UUID.randomUUID().toString();
                resource.setUUID(serviceId);
            }
            if (registry.resourceExists(servicePath)) {
                Resource oldResource = registry.get(servicePath);
                Object content = oldResource.getContent();
                String oldContent = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
                OMElement oldServiceInfoElement = null;
                if (serviceInfo.equals(oldContent)) {
                    String tempPath = "/_system/governance/" + resourceName;
                    if (!originalServicePath.equals(tempPath)) {
                        String path = RegistryUtils.getRelativePathToOriginal((String)servicePath, (String)"/_system/governance");
                        ArtifactManager.getArtifactManager().getTenantArtifactRepository().addArtifact(path);
                        return;
                    }
                    requestContext.setProcessingComplete(true);
                    return;
                }
                if ("true".equals(resource.getProperty("registry.DefinitionImport"))) {
                    resource.removeProperty("registry.DefinitionImport");
                    try {
                        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(oldContent));
                        StAXOMBuilder builder = new StAXOMBuilder(reader);
                        oldServiceInfoElement = builder.getDocumentElement();
                        CommonUtil.setServiceName(oldServiceInfoElement, CommonUtil.getServiceName(serviceInfoElement));
                        CommonUtil.setServiceNamespace(oldServiceInfoElement, CommonUtil.getServiceNamespace(serviceInfoElement));
                        CommonUtil.setDefinitionURL(oldServiceInfoElement, CommonUtil.getDefinitionURL(serviceInfoElement));
                        CommonUtil.setEndpointEntries(oldServiceInfoElement, CommonUtil.getEndpointEntries(serviceInfoElement));
                        CommonUtil.setServiceVersion(oldServiceInfoElement, org.wso2.carbon.registry.common.utils.CommonUtil.getServiceVersion((OMElement)serviceInfoElement));
                        serviceInfoElement = oldServiceInfoElement;
                        resource.setContent((Object)serviceInfoElement.toString());
                        resource.setDescription(oldResource.getDescription());
                    }
                    catch (Exception e) {
                        String msg3 = "Error in parsing the service content of the service. The requested path to store the service: " + originalServicePath + ".";
                        log.error((Object)msg3);
                        throw new RegistryException(msg3, (Throwable)e);
                    }
                }
                try {
                    previousServiceInfoElement = AXIOMUtil.stringToOM((String)oldContent);
                }
                catch (XMLStreamException e) {
                    msg = "Error in parsing the service content of the service. The requested path to store the service: " + originalServicePath + ".";
                    log.error((Object)msg);
                    throw new RegistryException(msg, (Throwable)e);
                }
            }
            if ("true".equals(resource.getProperty("registry.DefinitionImport"))) {
                resource.removeProperty("registry.DefinitionImport");
            }
            String definitionURL = CommonUtil.getDefinitionURL(serviceInfoElement);
            String oldDefinition = null;
            if (previousServiceInfoElement != null && (!"".equals(oldDefinition = CommonUtil.getDefinitionURL(previousServiceInfoElement)) && "".equals(definitionURL) || !"".endsWith(oldDefinition) && !oldDefinition.equals(definitionURL))) {
                try {
                    registry.removeAssociation(servicePath, oldDefinition, "depends");
                    registry.removeAssociation(oldDefinition, servicePath, "usedBy");
                    EndpointUtils.removeEndpointEntry(oldDefinition, servicePath, serviceInfoElement, registry);
                    resource.setContent((Object)RegistryUtils.decodeBytes((byte[])serviceInfoElement.toString().getBytes()));
                }
                catch (RegistryException e) {
                    throw new RegistryException("Failed to remove endpoints from Service UI : " + serviceName, (Throwable)e);
                }
            }
            boolean alreadyAdded = false;
            if (definitionURL != null && (definitionURL.startsWith("http://") || definitionURL.startsWith("https://"))) {
                if (definitionURL.toLowerCase().endsWith("wsdl")) {
                    wsdl = this.buildWSDLProcessor(requestContext);
                    RequestContext context = new RequestContext(registry, requestContext.getRepository(), requestContext.getVersionRepository());
                    context.setResourcePath(new ResourcePath("/" + serviceName + ".wsdl"));
                    context.setSourceURL(definitionURL);
                    ResourceImpl tmpResource = new ResourceImpl();
                    tmpResource.setProperty("version", serviceVersion);
                    tmpResource.setProperty("resource.source", "Auto");
                    context.setResource((Resource)tmpResource);
                    definitionPath = wsdl.addWSDLToRegistry(context, definitionURL, null, false, false, this.disableWSDLValidation, this.disableSymlinkCreation);
                } else if (definitionURL.toLowerCase().endsWith("wadl")) {
                    WADLProcessor wadlProcessor = this.buildWADLProcessor(requestContext);
                    wadlProcessor.setCreateService(false);
                    RequestContext context = new RequestContext(registry, requestContext.getRepository(), requestContext.getVersionRepository());
                    context.setResourcePath(new ResourcePath("/" + serviceName + ".wadl"));
                    context.setSourceURL(definitionURL);
                    ResourceImpl tmpResource = new ResourceImpl();
                    tmpResource.setProperty("version", serviceVersion);
                    tmpResource.setProperty("resource.source", "Auto");
                    context.setResource((Resource)tmpResource);
                    definitionPath = wadlProcessor.importWADLToRegistry(context, this.disableWADLValidation);
                } else {
                    throw new RegistryException("Invalid service definition found. Please enter a valid WSDL/WADL URL");
                }
                if (definitionPath == null) {
                    return;
                }
                definitionURL = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)definitionPath);
                CommonUtil.setDefinitionURL(serviceInfoElement, definitionURL);
                resource.setContent((Object)RegistryUtils.decodeBytes((byte[])serviceInfoElement.toString().getBytes()));
                ((ResourceImpl)resource).prepareContentForPut();
                this.persistServiceResource(registry, resource, servicePath);
                alreadyAdded = true;
                registry.addAssociation(servicePath, definitionPath, "depends");
                registry.addAssociation(definitionPath, servicePath, "usedBy");
            } else if (definitionURL != null && definitionURL.startsWith("/")) {
                definitionPath = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)definitionURL);
                definitionPath = CommonUtil.getRegistryPath(requestContext.getRegistry().getRegistryContext(), definitionPath);
                boolean addItHere = false;
                if (!registry.resourceExists(definitionPath)) {
                    msg = "Associating service to a non-existing WSDL. wsdl url: " + definitionPath + ", service path: " + servicePath + ".";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                if (!registry.resourceExists(servicePath)) {
                    addItHere = true;
                } else {
                    Association[] dependencies = registry.getAssociations(servicePath, "depends");
                    boolean dependencyFound = false;
                    if (dependencies != null) {
                        for (Association dependency : dependencies) {
                            if (!definitionPath.equals(dependency.getDestinationPath())) continue;
                            dependencyFound = true;
                        }
                    }
                    if (!dependencyFound) {
                        addItHere = true;
                    }
                }
                if (addItHere) {
                    ((ResourceImpl)resource).prepareContentForPut();
                    this.persistServiceResource(registry, resource, servicePath);
                    alreadyAdded = true;
                    registry.addAssociation(servicePath, definitionPath, "depends");
                    registry.addAssociation(definitionPath, servicePath, "usedBy");
                }
            }
            if (!alreadyAdded) {
                ((ResourceImpl)resource).prepareContentForPut();
                this.persistServiceResource(registry, resource, servicePath);
            }
            if (definitionURL != null) {
                if (oldDefinition == null) {
                    EndpointUtils.saveEndpointsFromServices(requestContext, servicePath, serviceInfoElement, registry, CommonUtil.getUnchrootedSystemRegistry(requestContext));
                } else if (oldDefinition != null && !definitionURL.equals(oldDefinition)) {
                    EndpointUtils.saveEndpointsFromServices(requestContext, servicePath, serviceInfoElement, registry, CommonUtil.getUnchrootedSystemRegistry(requestContext));
                }
            }
            String symlinkLocation = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)requestContext.getResource().getProperty("SymlinkPropertyName"));
            if (!servicePath.equals(originalServicePath) && requestContext.getRegistry().resourceExists(originalServicePath)) {
                Resource serviceResource = requestContext.getRegistry().get(RegistryUtils.getParentPath((String)originalServicePath));
                String isLink = serviceResource.getProperty("registry.link");
                String mountPoint = serviceResource.getProperty("registry.mountpoint");
                String targetPoint = serviceResource.getProperty("registry.targetpoint");
                String actualPath = serviceResource.getProperty("registry.actualpath");
                if (isLink != null && mountPoint != null && targetPoint != null) {
                    symlinkLocation = actualPath + "/";
                }
                if (symlinkLocation != null) {
                    requestContext.getSystemRegistry().createLink(symlinkLocation + resourceName, servicePath);
                }
            }
            requestContext.setProcessingComplete(true);
            if (wsdl != null && "enable".equals(System.getProperty("uddi"))) {
                AuthToken authToken = UDDIUtil.getPublisherAuthToken();
                if (authToken == null) {
                    return;
                }
                BusinessServiceInfo businessServiceInfo = new BusinessServiceInfo();
                businessServiceInfo.setServiceDescription(CommonUtil.getServiceDescription(serviceInfoElement));
                WSDLInfo wsdlInfo = wsdl.getMasterWSDLInfo();
                businessServiceInfo.setServiceWSDLInfo(wsdlInfo);
                UDDIPublisher publisher = new UDDIPublisher();
                publisher.publishBusinessService(authToken, businessServiceInfo);
            }
            String path = RegistryUtils.getRelativePathToOriginal((String)servicePath, (String)"/_system/governance");
            ArtifactManager.getArtifactManager().getTenantArtifactRepository().addArtifact(path);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    private String getServicePath(Registry registry, Resource resource, OMElement serviceInfoElement, String serviceName, String serviceNamespace, String serviceVersion) {
        String servicePath;
        if (Utils.getRxtService() == null) {
            servicePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)(registry.getRegistryContext().getServicePath() + (serviceNamespace == null ? "" : CommonUtil.derivePathFragmentFromNamespace(serviceNamespace)) + serviceVersion + "/" + serviceName));
        } else {
            String pathExpression = Utils.getRxtService().getStoragePath(resource.getMediaType());
            servicePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)CommonUtil.getPathFromPathExpression(pathExpression, serviceInfoElement, null));
            servicePath = CommonUtil.getRegistryPath(registry.getRegistryContext(), servicePath);
        }
        return servicePath;
    }

    protected WSDLProcessor buildWSDLProcessor(RequestContext requestContext) {
        return new WSDLProcessor(requestContext);
    }

    protected WADLProcessor buildWADLProcessor(RequestContext requestContext) {
        return new WADLProcessor(requestContext);
    }

    private void persistServiceResource(Registry registry, Resource resource, String servicePath) throws RegistryException {
        registry.put(servicePath, resource);
    }

    public void setDisableWSDLValidation(String disableWSDLValidation) {
        this.disableWSDLValidation = Boolean.toString(true).equals(disableWSDLValidation);
    }

    public void setDisableWADLValidation(String disableWADLValidation) {
        this.disableWADLValidation = Boolean.getBoolean(disableWADLValidation);
    }

    public String mergeServiceContent(String newContent, String oldContent) {
        return newContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            Registry registry = requestContext.getRegistry();
            ResourcePath resourcePath = requestContext.getResourcePath();
            if (resourcePath == null) {
                throw new RegistryException("The resource path is not available.");
            }
            Resource resource = registry.get(resourcePath.getPath());
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }
}

