/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.extensions.services.RXTStoragePathService;
import org.wso2.carbon.registry.extensions.services.RXTStoragePathServiceImpl;
import org.wso2.carbon.registry.extensions.services.Utils;

@Component(name="org.wso2.carbon.registry.extensions", immediate=true)
public class RegistryRXTStoragePathComponent {
    private static Log log = LogFactory.getLog(RegistryRXTStoragePathComponent.class);
    private RegistryService registryService;
    private ServiceRegistration extensionServiceRegistration = null;

    @Activate
    protected void activate(ComponentContext context) {
        RXTStoragePathServiceImpl service = new RXTStoragePathServiceImpl();
        this.extensionServiceRegistration = context.getBundleContext().registerService(RXTStoragePathService.class.getName(), (Object)service, null);
        Utils.setRxtService(service);
        if (log.isDebugEnabled()) {
            log.debug((Object)"******* Registry Extensions bundle is activated ******* ");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (this.extensionServiceRegistration != null) {
            this.extensionServiceRegistration.unregister();
            this.extensionServiceRegistration = null;
        }
        Utils.setRxtService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"******* Registry Extensions bundle is deactivated ******* ");
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
    }
}

