/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.jmx;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.wso2.carbon.registry.core.statistics.StatisticsCollector;
import org.wso2.carbon.registry.extensions.jmx.InvocationStatisticsMBean;

public class InvocationStatistics
implements InvocationStatisticsMBean,
StatisticsCollector {
    private Map<String, AtomicLong> map = new ConcurrentHashMap<String, AtomicLong>();

    public String[] getInvokedMethods() {
        return this.map.keySet().toArray(new String[this.map.size()]);
    }

    public void collect(Object ... objects) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
        String className = stackTraceElement.getClassName();
        String methodName = className.substring(className.lastIndexOf(".") + 1) + "." + stackTraceElement.getMethodName();
        AtomicLong atomicLong = this.map.get(methodName);
        if (atomicLong == null) {
            this.map.put(methodName, new AtomicLong(1L));
        } else {
            atomicLong.incrementAndGet();
        }
    }

    public long getInvocationCounts(String methodName) {
        return this.map.get(methodName).get();
    }
}

