/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.beans.ServiceDocumentsBean;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.registry.extensions.services.Utils;
import org.wso2.carbon.registry.extensions.utils.URLProcessor;
import org.wso2.carbon.user.core.service.RealmService;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static Random generator = new Random();
    private static InheritableThreadLocal<Map<String, String>> artifactIndexMap = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return null;
        }
    };
    private static InheritableThreadLocal<Map<String, String>> symbolicLinkMap = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return null;
        }
    };
    private static InheritableThreadLocal<Set<String>> importedArtifacts = new InheritableThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new ConcurrentSkipListSet<String>();
        }
    };
    private static ThreadLocal<Boolean> scmTaskInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> updateInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> deleteInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> restoringInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> addingAssociationInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static String getUniqueNameforNamespace(String commonSchemaLocation, String targetNamespace1) {
        String targetNamespace = targetNamespace1.replaceAll("\\s+$", "");
        targetNamespace = targetNamespace.replace("://", "/");
        targetNamespace = targetNamespace.replace(".", "/");
        targetNamespace = targetNamespace.replace("#", "/");
        while (targetNamespace.indexOf("//") > 0) {
            targetNamespace = targetNamespace.replace("//", "/");
        }
        String resourcePath = commonSchemaLocation.endsWith("/") ? commonSchemaLocation + targetNamespace : commonSchemaLocation + "/" + targetNamespace;
        if (!targetNamespace.endsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        return resourcePath;
    }

    public static String derivePathFragmentFromNamespace(String namespace) {
        String packageName;
        if (namespace == null || (packageName = URLProcessor.deriveRegistryPath(namespace)) == null) {
            return "//";
        }
        String pathFragment = "/" + packageName.replace(".", "/");
        if (pathFragment.endsWith("/")) {
            return pathFragment;
        }
        return pathFragment + "/";
    }

    public static String getServiceName(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Name")) != null) {
            return overview.getFirstChildWithName(new QName("Name")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")).getText();
        }
        return "";
    }

    public static String getServiceVersion(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Version")) != null) {
            return overview.getFirstChildWithName(new QName("Version")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "version")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "version")).getText();
        }
        return "";
    }

    public static String getAttributeValue(OMElement element, String attributeName) {
        int i;
        String[] parts = attributeName.split("_");
        OMElement attributeElement = element;
        for (i = 0; i < parts.length; ++i) {
            if ((attributeElement = attributeElement.getFirstChildWithName(new QName(parts[i]))) != null && i == parts.length - 1) {
                return attributeElement.getText();
            }
            if (attributeElement == null) break;
        }
        attributeElement = element;
        for (i = 0; i < parts.length; ++i) {
            if ((attributeElement = attributeElement.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", parts[i]))) != null && i == parts.length - 1) {
                return attributeElement.getText();
            }
            if (attributeElement == null) break;
        }
        return null;
    }

    public static OMElement setServiceAttribute(OMElement element, String fieldName, String fieldValue) {
        OMElement omElement;
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            omElement = OMAbstractFactory.getOMFactory().createOMElement(new QName(fieldName));
            omElement.setText(fieldValue);
            overview.addChild((OMNode)omElement);
        }
        if ((overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"))) != null) {
            omElement = OMAbstractFactory.getOMFactory().createOMElement(new QName("http://www.wso2.org/governance/metadata", fieldName));
            omElement.setText(fieldValue);
            overview.addChild((OMNode)omElement);
        }
        return element;
    }

    public static void setServiceName(OMElement element, String serviceName) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Name")) != null) {
            overview.getFirstChildWithName(new QName("Name")).setText(serviceName);
            return;
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")) != null) {
            overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")).setText(serviceName);
        }
    }

    public static String getServiceNamespace(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Namespace")) != null) {
            return overview.getFirstChildWithName(new QName("Namespace")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")).getText();
        }
        return "";
    }

    public static String computeServicePathWithVersion(String path, String version) throws RegistryException {
        String temp = version;
        String suffix = "-SNAPSHOT";
        if (temp.endsWith(suffix)) {
            temp = temp.substring(0, temp.length() - suffix.length());
        }
        if (!temp.matches("^(\\d+[.]*)+\\d+(-[a-zA-Z0-9]+)?$")) {
            String msg = "The specified service version " + version + " is invalid. The requested path to store the service: " + path + ".";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return path + "/" + version + "/" + "service";
    }

    public static String computeProcessPathWithVersion(String path, String version) throws RegistryException {
        if (!version.matches("^(\\d+[.]*)+\\d+(-[a-zA-Z0-9]+)?$")) {
            String msg = "The specified process version " + version + " is invalid. The requested path to store the process: " + path + ".";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return path + "/" + version.replace(".", "/") + "/" + "process";
    }

    public static String computeSLAPathWithVersion(String path, String version) throws RegistryException {
        if (!version.matches("^(\\d+[.]*)+\\d+(-[a-zA-Z0-9]+)?$")) {
            String msg = "The specified sla version " + version + " is invalid. The requested path to store the sla: " + path + ".";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return path + "/" + version.replace(".", "/") + "/" + "sla";
    }

    public static void setServiceNamespace(OMElement element, String namespace) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Namespace")) != null) {
            overview.getFirstChildWithName(new QName("Namespace")).setText(namespace);
            return;
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")) != null) {
            overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")).setText(namespace);
        }
    }

    public static OMElement[] getEndpointEntries(OMElement element) {
        OMElement endPoints = element.getFirstChildWithName(new QName("endpoints"));
        if (endPoints != null) {
            Iterator it = endPoints.getChildrenWithLocalName("entry");
            ArrayList<OMElement> endpointList = new ArrayList<OMElement>();
            while (it.hasNext()) {
                endpointList.add((OMElement)it.next());
            }
            return endpointList.toArray(new OMElement[endpointList.size()]);
        }
        endPoints = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "endpoints"));
        if (endPoints != null) {
            Iterator it = endPoints.getChildrenWithName(new QName("http://www.wso2.org/governance/metadata", "entry"));
            ArrayList<OMElement> endpointList = new ArrayList<OMElement>();
            while (it.hasNext()) {
                endpointList.add((OMElement)it.next());
            }
            return endpointList.toArray(new OMElement[endpointList.size()]);
        }
        return null;
    }

    public static void setEndpointEntries(OMElement element, OMElement[] endPointsList) {
        OMElement endPoints = element.getFirstChildWithName(new QName("endpoints"));
        if (endPointsList != null) {
            if (endPoints != null) {
                Iterator it = endPoints.getChildElements();
                while (it.hasNext()) {
                    OMElement omElement = (OMElement)it.next();
                    omElement.detach();
                }
                for (OMElement endPoint : endPointsList) {
                    endPoints.addChild((OMNode)endPoint);
                }
                return;
            }
            endPoints = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "endpoints"));
            if (endPoints != null) {
                Iterator it = endPoints.getChildElements();
                while (it.hasNext()) {
                    OMElement omElement = (OMElement)it.next();
                    omElement.detach();
                }
                for (OMElement endPoint : endPointsList) {
                    endPoints.addChild((OMNode)endPoint);
                }
            }
        }
    }

    public static Map<String, String> getOverviewEntries(OMElement element) {
        HashMap<String, String> prop = new HashMap<String, String>();
        OMElement endPoints = element.getFirstChildWithName(new QName("overview"));
        if (endPoints != null) {
            Iterator it = endPoints.getChildElements();
            while (it.hasNext()) {
                OMElement omelement = (OMElement)it.next();
                prop.put(omelement.getLocalName(), omelement.getText());
            }
            return prop;
        }
        endPoints = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (endPoints != null) {
            Iterator it = endPoints.getChildElements();
            while (it.hasNext()) {
                OMElement omelement = (OMElement)it.next();
                prop.put(omelement.getLocalName(), omelement.getText());
            }
            return prop;
        }
        return null;
    }

    public static void setServiceVersion(OMElement element, String version) {
        OMElement omElement;
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            if (overview.getFirstChildWithName(new QName("Version")) != null) {
                overview.getFirstChildWithName(new QName("Version")).setText(version);
                return;
            }
            omElement = OMAbstractFactory.getOMFactory().createOMElement(new QName("Version"));
            omElement.setText(version);
            overview.addChild((OMNode)omElement);
        }
        if ((overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"))) != null) {
            if (overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "version")) != null) {
                overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "version")).setText(version);
            } else {
                omElement = OMAbstractFactory.getOMFactory().createOMElement(new QName("http://www.wso2.org/governance/metadata", "version"));
                omElement.setText(version);
                overview.addChild((OMNode)omElement);
            }
        }
    }

    public static void setDefinitionURL(OMElement element, String namespace) {
        OMElement overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "interface"));
        if (overview == null) {
            OMElement interfaceElement = OMAbstractFactory.getOMFactory().createOMElement(new QName("http://www.wso2.org/governance/metadata", "interface"));
            OMElement wsdlURLElement = OMAbstractFactory.getOMFactory().createOMElement(new QName("http://www.wso2.org/governance/metadata", "wsdlURL"));
            wsdlURLElement.setText(namespace);
            interfaceElement.addChild((OMNode)wsdlURLElement);
            element.addChild((OMNode)interfaceElement);
            return;
        }
        if (overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "wsdlURL")) != null) {
            overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "wsdlURL")).setText(namespace);
        }
    }

    public static String getDefinitionURL(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Interface"));
        if (overview != null && overview.getFirstChildWithName(new QName("WSDL-URL")) != null) {
            return overview.getFirstChildWithName(new QName("WSDL-URL")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "interface"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "wsdlURL")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "wsdlURL")).getText();
        }
        return "";
    }

    public static String getWorkflowURL(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "definition"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "bpelURL")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "bpelURL")).getText();
        }
        return "";
    }

    public static ArrayList<ServiceDocumentsBean> getDocLinks(OMElement element) {
        ArrayList<ServiceDocumentsBean> documents = new ArrayList<ServiceDocumentsBean>();
        OMElement docLinks = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "docLinks"));
        if (docLinks != null) {
            for (int itemNo = 0; itemNo <= 3; ++itemNo) {
                ServiceDocumentsBean document = new ServiceDocumentsBean();
                String appender = itemNo == 0 ? "" : "" + itemNo + "";
                String description = "documentComment" + appender;
                String url = "url" + appender;
                String type = "documentType" + appender;
                if (docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", url)) != null) {
                    String documentUrl = docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", url)).getText();
                    document.setDocumentUrl(documentUrl);
                }
                if (document.getDocumentUrl() == null || document.getDocumentUrl().isEmpty()) break;
                documents.add(document);
                if (docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", description)) != null) {
                    String documentDesc = docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", description)).getText();
                    document.setDocumentDescription(documentDesc);
                }
                if (docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", type)) == null) continue;
                String documentType = docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", type)).getText();
                document.setDocumentType(documentType);
            }
        }
        return documents;
    }

    public static String getServiceDescription(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "description")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "description")).getText();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addService(OMElement service, RequestContext context) throws RegistryException {
        String path;
        Registry registry = context.getRegistry();
        Resource resource = registry.newResource();
        if (Utils.getRxtService() == null) {
            String version = context.getResource().getProperty("version");
            String tempNamespace = CommonUtil.derivePathFragmentFromNamespace(CommonUtil.getServiceNamespace(service));
            path = CommonUtil.getChrootedServiceLocation(registry, context.getRegistryContext()) + tempNamespace + version + "/" + CommonUtil.getServiceName(service);
            path = CommonUtil.getRegistryPath(context.getRegistry().getRegistryContext(), path);
        } else {
            String pathExpression = Utils.getRxtService().getStoragePath("application/vnd.wso2-service+xml");
            path = RegistryUtils.getAbsolutePath((RegistryContext)context.getRegistryContext(), (String)CommonUtil.getPathFromPathExpression(pathExpression, service, context.getResource().getProperties()));
            log.info((Object)("Checking local paths, absolute path: " + path + " | path: " + CommonUtil.getRegistryPath(context.getRegistry().getRegistryContext(), path)));
        }
        String content = service.toString();
        resource.setContent((Object)RegistryUtils.encodeString((String)content));
        resource.setMediaType("application/vnd.wso2-service+xml");
        boolean lockAlreadyAcquired = !CommonUtil.isUpdateLockAvailable();
        CommonUtil.releaseUpdateLock();
        try {
            if (registry.resourceExists(path)) {
                Resource existingResource = registry.get(path);
                resource.setUUID(existingResource.getUUID());
            } else {
                resource.setUUID(UUID.randomUUID().toString());
            }
            resource.setProperty("resource.source", "Auto");
            resource.setProperty("registry.DefinitionImport", "true");
            registry.put(path, resource);
            String defaultLifeCycle = CommonUtil.getDefaultLifecycle(registry, "service");
            if (defaultLifeCycle != null && !defaultLifeCycle.isEmpty()) {
                String[] lifeCycles;
                for (String lifeCycle : lifeCycles = defaultLifeCycle.split(",")) {
                    if (!StringUtils.isNotEmpty((String)lifeCycle)) continue;
                    registry.associateAspect(resource.getId(), lifeCycle);
                }
            }
        }
        finally {
            if (lockAlreadyAcquired) {
                CommonUtil.acquireUpdateLock();
            }
        }
        registry.addAssociation(path, RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)CommonUtil.getDefinitionURL(service)), "depends");
        registry.addAssociation(RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)CommonUtil.getDefinitionURL(service)), path, "usedBy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSoapService(OMElement service, RequestContext context) throws RegistryException {
        String path;
        Registry registry = context.getRegistry();
        Resource resource = registry.newResource();
        if (Utils.getRxtService() == null) {
            String version = context.getResource().getProperty("version");
            String tempNamespace = CommonUtil.derivePathFragmentFromNamespace(CommonUtil.getServiceNamespace(service));
            path = CommonUtil.getChrootedServiceLocation(registry, context.getRegistryContext()) + tempNamespace + version + "/" + CommonUtil.getServiceName(service);
        } else {
            String pathExpression = Utils.getRxtService().getStoragePath("application/vnd.wso2-soap-service+xml");
            String absolutePath = RegistryUtils.getAbsolutePath((RegistryContext)context.getRegistryContext(), (String)CommonUtil.getPathFromPathExpression(pathExpression, service, context.getResource().getProperties()));
            if (CurrentSession.getLocalPathMap() != null && !Boolean.valueOf((String)CurrentSession.getLocalPathMap().get("archieve-upload")).booleanValue()) {
                path = CommonUtil.getRegistryPath(context.getRegistry().getRegistryContext(), absolutePath);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saving current session local paths, key: " + path + " | value: " + absolutePath));
                }
                CurrentSession.getLocalPathMap().put(path, absolutePath);
            } else {
                path = absolutePath;
            }
        }
        String content = service.toString();
        resource.setContent((Object)RegistryUtils.encodeString((String)content));
        resource.setMediaType("application/vnd.wso2-soap-service+xml");
        boolean lockAlreadyAcquired = !CommonUtil.isUpdateLockAvailable();
        CommonUtil.releaseUpdateLock();
        try {
            if (registry.resourceExists(path)) {
                Resource existingResource = registry.get(path);
                resource.setUUID(existingResource.getUUID());
            } else {
                resource.setUUID(UUID.randomUUID().toString());
            }
            resource.setProperty("resource.source", "Auto");
            resource.setProperty("registry.DefinitionImport", "true");
            registry.put(path, resource);
            String defaultLifeCycle = CommonUtil.getDefaultLifecycle(registry, "soapservice");
            CommonUtil.applyDefaultLifeCycle(registry, resource, path, defaultLifeCycle);
        }
        finally {
            if (lockAlreadyAcquired) {
                CommonUtil.acquireUpdateLock();
            }
        }
        registry.addAssociation(path, RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)CommonUtil.getDefinitionURL(service)), "depends");
        registry.addAssociation(RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)CommonUtil.getDefinitionURL(service)), path, "usedBy");
    }

    public static void applyDefaultLifeCycle(Registry registry, Resource resource, String path, String defaultLifeCycle) throws RegistryException {
        block4: {
            if (defaultLifeCycle == null || defaultLifeCycle.isEmpty()) break block4;
            Object[] lifeCycles = defaultLifeCycle.split(",");
            ArrayUtils.reverse((Object[])lifeCycles);
            if (CurrentSession.getLocalPathMap() != null && !Boolean.valueOf((String)CurrentSession.getLocalPathMap().get("archieve-upload")).booleanValue()) {
                for (Object lifeCycle : lifeCycles) {
                    if (!StringUtils.isNotEmpty((String)lifeCycle)) continue;
                    registry.associateAspect(resource.getId(), (String)lifeCycle);
                }
            } else {
                for (Object lifeCycle : lifeCycles) {
                    if (!StringUtils.isNotEmpty((String)lifeCycle)) continue;
                    registry.associateAspect(path, (String)lifeCycle);
                }
            }
        }
    }

    public static String getRegistryPath(RegistryContext requestContext, String servicePath) {
        List mounts = requestContext.getMounts();
        for (Mount mount : mounts) {
            String mountPath = mount.getPath();
            if (!servicePath.startsWith(mountPath) || servicePath.startsWith(mount.getTargetPath())) continue;
            return servicePath.replace(mountPath, mount.getTargetPath());
        }
        return servicePath;
    }

    public static String getPathFromPathExpression(String pathExpression, OMElement content, Properties properties) {
        String output = CommonUtil.replaceNameAndNamespace(pathExpression, content);
        String[] elements = output.split("@");
        for (int i = 1; i < elements.length; ++i) {
            String msg;
            if (elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0) continue;
            String key = elements[i].split("}")[0].substring(1);
            String artifactAttribute = CommonUtil.getAttributeValue(content, key);
            if (artifactAttribute != null) {
                output = output.replace("@{" + key + "}", artifactAttribute);
                if (!log.isDebugEnabled()) continue;
                msg = "OutPut : " + output + " Key: " + key + " artifactAttribute: " + artifactAttribute;
                log.debug((Object)msg);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            msg = "Value for required attribute " + key + " found empty.";
            log.debug((Object)msg);
        }
        return CommonUtil.getPathFromPathExpression(output, properties, content);
    }

    public static String getPathFromPathExpression(String pathExpression, Properties properties, OMElement content) {
        String artifactAttribute;
        String key;
        int i;
        String[] elements = pathExpression.split("@");
        for (i = 1; i < elements.length; ++i) {
            if (elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0 || properties.get((key = elements[i].split("}")[0].substring(1)).toLowerCase()) == null || !(properties.get(key.toLowerCase()) instanceof List) || (artifactAttribute = (String)((List)properties.get(key.toLowerCase())).get(0)) == null) continue;
            pathExpression = pathExpression.replace("@{" + key + "}", artifactAttribute);
            if (!log.isDebugEnabled()) continue;
            String msg = "pathExpression : " + pathExpression + " Key: " + key + " artifactAttribute: " + artifactAttribute;
            log.debug((Object)msg);
        }
        elements = pathExpression.split("@");
        for (i = 1; i < elements.length; ++i) {
            if (elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0) continue;
            key = elements[i].split("}")[0].substring(1);
            if (properties.get((key = key.replace("overview_", "")).toLowerCase()) == null || (artifactAttribute = (String)((List)properties.get(key.toLowerCase())).get(0)) == null) continue;
            pathExpression = pathExpression.replace("@{overview_" + key + "}", artifactAttribute);
            if (content == null) continue;
            CommonUtil.setServiceAttribute(content, key, artifactAttribute);
        }
        return pathExpression;
    }

    public static String replaceExpressionOfPath(String pathExpression, String namespace, String value) {
        String[] elements = pathExpression.split("@");
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0) continue;
            String key = elements[i].split("}")[0].substring(1);
            if (namespace.equalsIgnoreCase(key)) {
                pathExpression = pathExpression.replace("@{" + key + "}", value);
                continue;
            }
            if (!key.equalsIgnoreCase("overview_" + namespace)) continue;
            pathExpression = pathExpression.replace("@{overview_" + namespace + "}", value);
        }
        return pathExpression;
    }

    private static String replaceNameAndNamespace(String pathExpression, OMElement content) {
        String output = pathExpression;
        String tempNamespace = CommonUtil.derivePathFragmentFromNamespace(CommonUtil.getServiceNamespace(content));
        String name = CommonUtil.getServiceName(content);
        if (name != null) {
            output = output.replace("@{name}", name);
            if (tempNamespace.startsWith("/")) {
                tempNamespace = tempNamespace.substring(1);
            }
            if (tempNamespace.endsWith("/")) {
                tempNamespace = tempNamespace.substring(0, tempNamespace.length() - 1);
            }
            output = output.replace("@{namespace}", tempNamespace);
        }
        return output;
    }

    private static String getChrootedServiceLocation(Registry registry, RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)registry.getRegistryContext().getServicePath());
    }

    public static String getDefaultLifecycle(Registry registry, String shortName) throws RegistryException {
        String[] rxtList = null;
        String lifecycle = "";
        for (String rxtContent : rxtList = MediaTypesUtils.getResultPaths((Registry)registry, (String)"application/vnd.wso2.registry-ext-type+xml")) {
            OMElement lifecycleElement;
            Resource resource = registry.get(rxtContent);
            Object content = resource.getContent();
            String elementString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
            OMElement configElement = null;
            try {
                configElement = AXIOMUtil.stringToOM((String)elementString);
            }
            catch (XMLStreamException e) {
                throw new RegistryException("Error while serializing to OM content from String", (Throwable)e);
            }
            if (!shortName.equals(configElement.getAttributeValue(new QName("shortName"))) || (lifecycleElement = configElement.getFirstChildWithName(new QName("lifecycle"))) == null) continue;
            lifecycle = lifecycleElement.getText();
        }
        return lifecycle;
    }

    public static void copyProperties(Resource originResource, Resource targetResource) {
        Properties properties = originResource.getProperties();
        if (properties != null) {
            List<String> linkProperties = Arrays.asList("registry.link", "registry.user", "registry.mount", "registry.author", "registry.mountpoint", "registry.targetpoint", "registry.actualpath", "registry.realpath");
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                String key = (String)e.getKey();
                if (linkProperties.contains(key)) continue;
                targetResource.setProperty(key, (List)e.getValue());
            }
        }
    }

    public static boolean isArtifactIndexMapExisting() {
        return artifactIndexMap.get() != null;
    }

    public static void createArtifactIndexMap() {
        artifactIndexMap.set(new ConcurrentHashMap());
    }

    public static void addToArtifactIndexMap(String key, String value) {
        ((Map)artifactIndexMap.get()).put(key, value);
    }

    public static Map<String, String> getAndRemoveArtifactIndexMap() {
        Map output = (Map)artifactIndexMap.get();
        artifactIndexMap.set(null);
        return output;
    }

    public static boolean isSymbolicLinkMapExisting() {
        return symbolicLinkMap.get() != null;
    }

    public static void createSymbolicLinkMap() {
        symbolicLinkMap.set(new ConcurrentHashMap());
    }

    public static void addToSymbolicLinkMap(String key, String value) {
        ((Map)symbolicLinkMap.get()).put(key, value);
    }

    public static Map<String, String> getAndRemoveSymbolicLinkMap() {
        Map output = (Map)symbolicLinkMap.get();
        symbolicLinkMap.set(null);
        return output;
    }

    public static void loadImportedArtifactMap() {
        importedArtifacts.get();
    }

    public static void clearImportedArtifactMap() {
        importedArtifacts.remove();
    }

    public static void addImportedArtifact(String path) {
        ((Set)importedArtifacts.get()).add(path);
    }

    public static boolean isImportedArtifactExisting(String path) {
        return ((Set)importedArtifacts.get()).contains(path);
    }

    public static boolean isSCMLockAvailable() {
        return scmTaskInProgress.get() == false;
    }

    public static void acquireSCMLock() {
        scmTaskInProgress.set(true);
    }

    public static void releaseSCMLock() {
        scmTaskInProgress.set(false);
    }

    public static boolean isUpdateLockAvailable() {
        return updateInProgress.get() == false;
    }

    public static void acquireUpdateLock() {
        updateInProgress.set(true);
    }

    public static void releaseUpdateLock() {
        updateInProgress.set(false);
    }

    public static boolean isDeleteLockAvailable() {
        return deleteInProgress.get() == false;
    }

    public static void acquireDeleteLock() {
        deleteInProgress.set(true);
    }

    public static void releaseDeleteLock() {
        deleteInProgress.set(false);
    }

    public static boolean isRestoringLockAvailable() {
        return restoringInProgress.get() == false;
    }

    public static void acquireRestoringLock() {
        restoringInProgress.set(true);
    }

    public static void releaseRestoringLock() {
        restoringInProgress.set(false);
    }

    public static boolean isAddingAssociationLockAvailable() {
        return addingAssociationInProgress.get() == false;
    }

    public static void acquireAddingAssociationLock() {
        addingAssociationInProgress.set(true);
    }

    public static void releaseAddingAssociationLock() {
        addingAssociationInProgress.set(false);
    }

    public static String getEndpointPathFromUrl(String url) {
        String urlToPath = EndpointUtils.deriveEndpointFromUrl(url);
        return EndpointUtils.getEndpointLocation() + urlToPath;
    }

    public static Registry getUnchrootedSystemRegistry(RequestContext requestContext) throws RegistryException {
        Registry registry = requestContext.getRegistry();
        RealmService realmService = registry.getRegistryContext().getRealmService();
        String systemUser = "wso2.system.user";
        return new UserRegistry(systemUser, CurrentSession.getTenantId(), registry, realmService, null);
    }

    public static String getConsumerType(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Type")) != null) {
            return overview.getFirstChildWithName(new QName("Type")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "type")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "type")).getText();
        }
        return "";
    }

    public static String getPeopleGroup(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Group")) != null) {
            return overview.getFirstChildWithName(new QName("Group")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "group")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "group")).getText();
        }
        return "";
    }

    public static String getPeopleType(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Type")) != null) {
            return overview.getFirstChildWithName(new QName("Type")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "type")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "type")).getText();
        }
        return "";
    }

    public static Association[] getDependenciesRecursively(Registry registry, String resourcePath) throws RegistryException {
        return CommonUtil.getDependenciesRecursively(registry, resourcePath, new ArrayList<String>());
    }

    private static Association[] getDependenciesRecursively(Registry registry, String resourcePath, List<String> traversedDependencyPaths) throws RegistryException {
        ArrayList<Association> dependencies = new ArrayList<Association>();
        if (!traversedDependencyPaths.contains(resourcePath)) {
            traversedDependencyPaths.add(resourcePath);
            List<Association> tempDependencies = Arrays.asList(registry.getAssociations(resourcePath, "depends"));
            for (Association association : tempDependencies) {
                if (traversedDependencyPaths.contains(association.getDestinationPath())) continue;
                dependencies.add(association);
                List<Association> childDependencies = Arrays.asList(CommonUtil.getDependenciesRecursively(registry, association.getDestinationPath(), traversedDependencyPaths));
                if (childDependencies.isEmpty()) continue;
                dependencies.addAll(childDependencies);
            }
        }
        return dependencies.toArray(new Association[dependencies.size()]);
    }

    public static ByteArrayOutputStream readSourceContent(InputStream inputStream) throws RegistryException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int nextChar;
            while ((nextChar = inputStream.read()) != -1) {
                outputStream.write(nextChar);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RegistryException("Exception occurred while reading content", (Throwable)e);
        }
        return outputStream;
    }

    public static void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error occurred when closing the input stream", (Throwable)e);
            }
        }
    }

    public static void closeOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error occurred when closing the output stream", (Throwable)e);
            }
        }
    }

    public static void addDependency(Registry registry, String source, String target) throws RegistryException {
        registry.addAssociation(source, target, "depends");
        registry.addAssociation(target, source, "usedBy");
    }

    public static boolean isValidUrl(String url) {
        return StringUtils.isNotBlank((String)url) && !url.startsWith("/_system/governance");
    }
}

